/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.CarResources;

public class CarClassLoader
extends SecureClassLoader {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log log = LogFactory.getLog(CarClassLoader.class);
    private final CarResources carResources;

    CarClassLoader(CarResources carResources) {
        super(carResources.getClass().getClassLoader());
        this.carResources = carResources;
    }

    public Class findClass(final String name) throws ClassNotFoundException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws ClassNotFoundException {
                byte[] buf = null;
                String pkgName = CarClassLoader.this.getPackageName(name);
                InputStream in = null;
                try {
                    String file = name.replace('.', '/') + ".class";
                    CarResources crs = CarResources.getInstance();
                    int size = (int)crs.getResourceSize(file);
                    in = crs.getResourceAsStream(file);
                    if (in == null || size == -1) {
                        throw new Exception("Car resource " + file + " not found.");
                    }
                    buf = new byte[size];
                    int offSet = 0;
                    int bytesRead = 0;
                    int remaining = size;
                    for (int totalRead = 0; totalRead < size; totalRead += bytesRead) {
                        bytesRead = in.read(buf, offSet, remaining);
                        remaining -= bytesRead;
                        offSet += bytesRead;
                    }
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(name, e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {
                        log.error((Object)("CarClassLoader::findClass() Could not close inputStream " + ioe));
                    }
                }
                CarClassLoader.this.createPackage(pkgName);
                return CarClassLoader.this.defineTheClass(name, buf, 0, buf.length);
            }
        };
        try {
            return (Class)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    private Class defineTheClass(String n, byte[] b, int offset, int len) {
        return super.defineClass(n, b, offset, len);
    }

    private void createPackage(String pkgName) {
        try {
            if (null != pkgName && null == this.getPackage(pkgName)) {
                this.definePackage(pkgName, "", "", "", "", "", "", null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String getPackageName(String name) {
        if (name.indexOf(".") != -1) {
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(name, ".");
            int tokens = st.countTokens();
            for (int count = 1; st.hasMoreTokens() && count < tokens; ++count) {
                sb.append(st.nextToken());
                if (count == tokens - 1) continue;
                sb.append(".");
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public URL findResource(String res) {
        return this.carResources.findResource(res);
    }
}

