/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.car.ParsingContext;
import org.jasig.portal.car.PathRouter;
import org.jasig.portal.car.ProcessIfTagHandler;
import org.jasig.portal.car.RoutingHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentTagHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ComponentTagHandler.class);
    private ParsingContext ctx = null;
    private RoutingHandler routingHandler = null;
    private ProcessIfTagHandler processTagHandler = null;
    private ContentHandler currentHandler = null;

    ComponentTagHandler(ParsingContext ctx, PathRouter[] routers) {
        this.routingHandler = new RoutingHandler(ctx, routers);
        this.processTagHandler = new ProcessIfTagHandler(ctx, this.routingHandler);
        this.currentHandler = this.routingHandler;
        this.ctx = ctx;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("A non-fatal parsing error occurred while parsing META-INF/comp.xml in " + this.ctx.getJarFile().getName() + "."), (Throwable)exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new RuntimeException(exception.toString());
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("A parsing warning occurred while parsing META-INF/comp.xml in " + this.ctx.getJarFile().getName() + "."), (Throwable)exception);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("processIf") && this.ctx.getPath().equals(DescriptorHandler.COMPONENT)) {
            this.processTagHandler.setAttributes(atts);
            this.currentHandler = this.processTagHandler;
        } else {
            this.currentHandler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("processIf") && this.ctx.getPath().equals(DescriptorHandler.COMPONENT)) {
            this.currentHandler = this.routingHandler;
        } else {
            this.currentHandler.endElement(namespaceURI, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentHandler.characters(ch, start, length);
    }
}

