/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.car.ParsingContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ExtensionTagHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ExtensionTagHandler.class);
    private ContentHandler extHandler = null;
    private ParsingContext ctx = null;

    public ExtensionTagHandler(ParsingContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.extHandler != null) {
            this.extHandler.characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.extHandler != null) {
            this.extHandler.startElement(namespaceURI, localName, qName, atts);
        }
        if (qName.equals("ext") && this.ctx.getPath().equals(DescriptorHandler.EXTENSIONS)) {
            this.extHandler = null;
            String handlerClass = atts.getValue("contentHandler");
            if (handlerClass == null) {
                log.error((Object)("Ignoring invalid extension while processing deployment descriptor for " + this.ctx.getJarFile().getName() + ". Attribute 'contentHandler' must be " + "specified."));
                return;
            }
            Class<?> c = null;
            Object obj = null;
            try {
                CarResources cRes = CarResources.getInstance();
                ClassLoader cl = cRes.getClassLoader();
                c = cl.loadClass(handlerClass);
            }
            catch (ClassNotFoundException clfe) {
                log.error((Object)("Specified contentHandler class " + handlerClass + " not found. Ignoring extension block " + "in deployment descriptor of " + this.ctx.getJarFile().getName() + "."));
                return;
            }
            catch (Throwable t) {
                log.error((Object)("Error occurred loading specified contentHandler class " + handlerClass + ". Ignoring extension block " + "in deployment descriptor of " + this.ctx.getJarFile().getName() + "."), t);
                return;
            }
            try {
                obj = c.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Unable to create specified contentHandler class " + handlerClass + " for extension block" + " in deployment descriptor of " + this.ctx.getJarFile().getName() + ". Ignoring extension. Details: " + e));
                return;
            }
            try {
                this.extHandler = obj;
            }
            catch (ClassCastException cce) {
                log.error((Object)("Specified contentHandler class " + handlerClass + " for extension in deployment " + "descriptor of " + this.ctx.getJarFile().getName() + " does not implement ContentHandler. " + "Ignoring extension."));
                return;
            }
            this.extHandler.startDocument();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("ext") && this.ctx.getPath().equals(DescriptorHandler.EXTENSIONS)) {
            if (this.extHandler != null) {
                this.extHandler.endDocument();
            }
            this.extHandler = null;
        }
        if (this.extHandler != null) {
            this.extHandler.endElement(namespaceURI, localName, qName);
        }
    }
}

