/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channel;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelPublishingService;
import org.jasig.portal.events.support.ModifiedChannelDefinitionPortalEvent;
import org.jasig.portal.events.support.PublishedChannelDefinitionPortalEvent;
import org.jasig.portal.events.support.RemovedChannelDefinitionPortalEvent;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ChannelPublishingServiceImpl
implements IChannelPublishingService,
ApplicationContextAware {
    private Log log = LogFactory.getLog(ChannelPublishingServiceImpl.class);
    private IChannelRegistryStore channelRegistryStore;
    private ApplicationEventPublisher eventPublisher;

    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        this.channelRegistryStore = channelRegistryStore;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.eventPublisher = applicationContext;
    }

    @Override
    public IChannelDefinition saveChannelDefinition(IChannelDefinition definition, IPerson publisher, ChannelCategory[] categories, IGroupMember[] groupMembers) {
        boolean newChannel = definition.getId() < 0;
        this.channelRegistryStore.saveChannelDefinition(definition);
        definition = this.channelRegistryStore.getChannelDefinition(definition.getFName());
        String chanKey = String.valueOf(definition.getId());
        IEntity channelDefEntity = GroupService.getEntity(chanKey, IChannelDefinition.class);
        Iterator iter = channelDefEntity.getAllContainingGroups();
        while (iter.hasNext()) {
            IEntityGroup group = (IEntityGroup)iter.next();
            group.removeMember(channelDefEntity);
            group.update();
        }
        for (ChannelCategory category : categories) {
            this.channelRegistryStore.addChannelToCategory(definition, category);
        }
        AuthorizationService authService = AuthorizationService.instance();
        String target = "CHAN_ID." + definition.getId();
        IUpdatingPermissionManager upm = authService.newUpdatingPermissionManager("UP_FRAMEWORK");
        IPermission[] permissions = new IPermission[groupMembers.length];
        for (int i = 0; i < groupMembers.length; ++i) {
            IAuthorizationPrincipal authPrincipal = authService.newPrincipal(groupMembers[i]);
            permissions[i] = upm.newPermission(authPrincipal);
            permissions[i].setType("GRANT");
            permissions[i].setActivity("SUBSCRIBE");
            permissions[i].setTarget(target);
        }
        if (!newChannel) {
            IPermission[] oldPermissions = upm.getPermissions("SUBSCRIBE", target);
            upm.removePermissions(oldPermissions);
        }
        upm.addPermissions(permissions);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Channel " + definition.getId() + " has been " + (newChannel ? "published" : "modified") + "."));
        }
        if (newChannel) {
            this.eventPublisher.publishEvent((ApplicationEvent)new PublishedChannelDefinitionPortalEvent((Object)definition, publisher, definition));
        } else {
            this.eventPublisher.publishEvent((ApplicationEvent)new ModifiedChannelDefinitionPortalEvent((Object)definition, publisher, definition));
        }
        return definition;
    }

    @Override
    public void removeChannelDefinition(IChannelDefinition channelDefinition, IPerson person) {
        IChannelDefinition channelDef = this.channelRegistryStore.getChannelDefinition(channelDefinition.getId());
        String chanKey = String.valueOf(channelDefinition.getId());
        IEntity channelDefEntity = GroupService.getEntity(chanKey, IChannelDefinition.class);
        Iterator iter = channelDefEntity.getAllContainingGroups();
        while (iter.hasNext()) {
            IEntityGroup group = (IEntityGroup)iter.next();
            group.removeMember(channelDefEntity);
            group.update();
        }
        AuthorizationService authService = AuthorizationService.instance();
        String target = "CHAN_ID." + channelDefinition.getId();
        IUpdatingPermissionManager upm = authService.newUpdatingPermissionManager("UP_FRAMEWORK");
        IPermission[] oldPermissions = upm.getPermissions("SUBSCRIBE", target);
        upm.removePermissions(oldPermissions);
        this.channelRegistryStore.deleteChannelDefinition(channelDef);
        this.eventPublisher.publishEvent((ApplicationEvent)new RemovedChannelDefinitionPortalEvent((Object)channelDef, person, channelDef));
    }
}

