/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.LocalConnectionContext;
import org.jasig.portal.tools.versioning.Version;
import org.jasig.portal.tools.versioning.VersionsManager;
import org.jasig.portal.utils.DTDResolver;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.jasig.portal.utils.cache.CacheFactoryLocator;
import org.jasig.portal.utils.uri.IUriScrutinizer;
import org.jasig.portal.utils.uri.PrefixUriScrutinizer;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

@Deprecated
public class CGenericXSLT
extends BaseChannel
implements IChannel,
ICacheable {
    private static final Map<Serializable, Document> contentCache = CacheFactoryLocator.getCacheFactory().getCache("org.jasig.portal.channels.CONTENT_CACHE");
    private boolean cacheGlobalMode = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.channels.CGenericXSLT.cache_global_mode", false);
    private long cacheContentLoaded;
    private String xmlUri;
    private String sslUri;
    private String xslTitle;
    private String xslUri;
    private final Map params = new HashMap();
    private long cacheTimeout;
    private LocalConnectionContext localConnContext = null;
    private int channelCacheScope = 0;
    private IUriScrutinizer uriScrutinizer;

    @Override
    public void setStaticData(ChannelStaticData sd) throws ResourceMissingException {
        String connContext;
        String gcm;
        String trimmedCacheScopeText;
        String cacheScopeText;
        String denyXmlUriPrefixesParam;
        String allowXmlUriPrefixesParam = sd.getParameter("upc_allow_xmlUri_prefixes");
        PrefixUriScrutinizer temp = PrefixUriScrutinizer.instanceFromParameters(allowXmlUriPrefixesParam, denyXmlUriPrefixesParam = sd.getParameter("upc_deny_xmlUri_prefixes"));
        if (temp == null) {
            throw new IllegalArgumentException("CGenericXSLT channel requires a non-null IUriScrutinizer");
        }
        this.uriScrutinizer = temp;
        this.xslUri = null;
        this.xslTitle = null;
        this.sslUri = null;
        this.xmlUri = null;
        this.cacheTimeout = PropertiesManager.getPropertyAsLong("org.jasig.portal.channels.CGenericXSLT.default_cache_timeout");
        String scrutinizeXmlUriAsStaticDataString = sd.getParameter("restrict_xmlUri_inStaticData");
        boolean scrutinizeXmlUriAsStaticData = "true".equals(scrutinizeXmlUriAsStaticDataString);
        String xmlUriParam = sd.getParameter("xmlUri");
        if (scrutinizeXmlUriAsStaticData) {
            this.setXmlUri(xmlUriParam);
        } else {
            this.xmlUri = xmlUriParam;
        }
        this.sslUri = sd.getParameter("sslUri");
        this.xslTitle = sd.getParameter("xslTitle");
        this.xslUri = sd.getParameter("xslUri");
        String cacheTimeoutText = sd.getParameter("cacheTimeout");
        if (cacheTimeoutText != null) {
            this.cacheTimeout = Long.parseLong(cacheTimeoutText);
        }
        if ((cacheScopeText = sd.getParameter("cacheScope")) != null && (trimmedCacheScopeText = cacheScopeText.trim()).length() > 0) {
            if (trimmedCacheScopeText.equals("system")) {
                this.channelCacheScope = 1;
            } else if (trimmedCacheScopeText.equals("instance")) {
                this.channelCacheScope = 0;
            } else {
                this.log.warn((Object)("CGnericXSLT ChannelStaticData parameter [system] had unrecognized value [" + trimmedCacheScopeText + "]; 'failing shut' with instance scoped caching."));
                this.channelCacheScope = 0;
            }
        }
        if ((gcm = sd.getParameter("cacheGlobalMode")) != null) {
            if ("true".equals(gcm = gcm.trim().toLowerCase())) {
                this.cacheGlobalMode = true;
            } else if ("false".equals(gcm)) {
                this.cacheGlobalMode = false;
            } else if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Invalid channel [" + sd.getChannelPublishId() + ":" + this.xmlUri + "] parameter cacheGlobalMode value [" + this.cacheGlobalMode + "]. Valid values are true|false. Defaulting to [" + this.cacheGlobalMode + "]."));
            }
        }
        if ((connContext = sd.getParameter("upc_localConnContext")) != null && !connContext.trim().equals("")) {
            try {
                this.localConnContext = (LocalConnectionContext)Class.forName(connContext).newInstance();
                this.localConnContext.init(sd);
            }
            catch (Exception e) {
                this.log.error((Object)("CGenericXSLT: Cannot initialize ILocalConnectionContext: " + connContext), (Throwable)e);
            }
        }
        this.params.putAll(sd);
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) {
        String s;
        this.runtimeData = rd;
        String xmlUri = rd.getParameter("xmlUri");
        if (xmlUri != null) {
            this.setXmlUri(xmlUri);
        }
        if ((s = rd.getParameter("xslTitle")) != null) {
            this.xslTitle = s;
        }
        Enumeration enum1 = rd.getParameterNames();
        while (enum1.hasMoreElements()) {
            String n = (String)enum1.nextElement();
            if (rd.getParameter(n) == null) continue;
            this.params.put(n, rd.getParameter(n));
        }
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        Version[] versions;
        boolean cacheit;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this);
        }
        if (this.params != null) {
            for (String n : this.params.keySet()) {
                if (this.params.get(n) == null) continue;
                this.runtimeData.put(n, this.params.get(n));
            }
        }
        Document xmlDoc = null;
        boolean bl = cacheit = this.cacheGlobalMode && this.cacheTimeout >= 0L && this.localConnContext == null;
        if (cacheit) {
            xmlDoc = this.getCacheContent(this.xmlUri);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Global cache hit [" + (xmlDoc != null) + "] for channel: " + this.xmlUri));
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Global cache not enabled for channel: " + this.xmlUri));
        }
        if (xmlDoc == null) {
            InputStream inputStream = null;
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setNamespaceAware(true);
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                DTDResolver dtdResolver = new DTDResolver();
                docBuilder.setEntityResolver(dtdResolver);
                URL url = this.localConnContext != null ? ResourceLoader.getResourceAsURL(this.getClass(), this.localConnContext.getDescriptor(this.xmlUri, this.runtimeData)) : ResourceLoader.getResourceAsURL(this.getClass(), this.xmlUri);
                URLConnection urlConnect = url.openConnection();
                if (this.localConnContext != null) {
                    try {
                        this.localConnContext.sendLocalData(urlConnect, this.runtimeData);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("CGenericXSLT: Unable to send data through " + this.runtimeData.getParameter("upc_localConnContext")), (Throwable)e);
                    }
                }
                inputStream = urlConnect.getInputStream();
                xmlDoc = docBuilder.parse(inputStream);
            }
            catch (IOException ioe) {
                throw new ResourceMissingException(this.xmlUri, "", ioe);
            }
            catch (Exception e) {
                throw new GeneralRenderingException("Problem parsing " + this.xmlUri, (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ioe) {
                    throw new PortalException("CGenericXSLT:renderXML():: could not close InputStream", (Throwable)ioe);
                }
            }
            if (cacheit) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Global cache store for channel: " + this.xmlUri));
                }
                this.setCacheContent(this.xmlUri, xmlDoc);
            }
        }
        this.runtimeData.put("baseActionURL", this.runtimeData.getBaseActionURL());
        this.runtimeData.put("isRenderingAsRoot", String.valueOf(this.runtimeData.isRenderingAsRoot()));
        VersionsManager versionsManager = VersionsManager.getInstance();
        for (Version version : versions = versionsManager.getVersions()) {
            String paramName = "version-" + version.getFname();
            this.runtimeData.setParameter(paramName, version.dottedTriple());
        }
        Version uPortalVersion = versionsManager.getVersion("UP_FRAMEWORK");
        this.runtimeData.put("uP_productAndVersion", "uPortal " + uPortalVersion.dottedTriple());
        if (this.params != null) {
            for (String n : this.params.keySet()) {
                if (this.params.get(n) == null) continue;
                this.runtimeData.put(n, this.params.get(n));
            }
        }
        XSLT xslt = XSLT.getTransformer(this);
        xslt.setXML(xmlDoc);
        if (this.xslUri != null) {
            xslt.setXSL(this.xslUri);
        } else {
            xslt.setXSL(this.sslUri, this.xslTitle, this.runtimeData.getBrowserInfo());
        }
        xslt.setTarget(out);
        xslt.setStylesheetParameters(this.runtimeData);
        xslt.transform();
    }

    @Override
    public ChannelCacheKey generateKey() {
        ChannelCacheKey k = new ChannelCacheKey();
        k.setKey(this.getKey());
        k.setKeyScope(this.channelCacheScope);
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        if (!(validity instanceof Long)) {
            return false;
        }
        if (System.currentTimeMillis() - (Long)validity > this.cacheTimeout * 1000L) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Framework cache timeout: " + this.xmlUri));
            }
            return false;
        }
        if (this.getCacheContentLoaded() > (Long)validity) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Global cache timeout: >cacheContentLoaded: " + this.getCacheContentLoaded() + " >validity: " + validity + " >currentTime: " + System.currentTimeMillis() + " >url: " + this.xmlUri));
            }
            return false;
        }
        return true;
    }

    private String getKey() {
        StringBuffer sbKey = new StringBuffer(1024);
        sbKey.append("xmluri:").append(this.xmlUri).append(", ");
        sbKey.append("sslUri:").append(this.sslUri).append(", ");
        String xslUriForKey = this.xslUri;
        try {
            if (xslUriForKey == null) {
                String s = ResourceLoader.getResourceAsURLString(CGenericXSLT.class, this.sslUri);
                xslUriForKey = XSLT.getStylesheetURI(s, this.runtimeData.getBrowserInfo());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            xslUriForKey = "Not attainable: " + e;
        }
        sbKey.append("locales:").append(LocaleManager.stringValueOf(this.runtimeData.getLocales()));
        sbKey.append("xslUri:").append(xslUriForKey).append(", ");
        sbKey.append("cacheTimeout:").append(this.cacheTimeout).append(", ");
        sbKey.append("isRenderingAsRoot:").append(this.runtimeData.isRenderingAsRoot()).append(", ");
        if (this.localConnContext != null) {
            sbKey.append("descriptor:").append(this.localConnContext.getDescriptor(this.xmlUri, this.runtimeData)).append(", ");
        }
        sbKey.append("params:").append(this.params.toString());
        return sbKey.toString();
    }

    private void setXmlUri(String xmlUriArg) {
        URL url = null;
        try {
            url = ResourceLoader.getResourceAsURL(this.getClass(), xmlUriArg);
        }
        catch (ResourceMissingException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Resource [" + xmlUriArg + "] missing.");
            iae.initCause(e);
            throw iae;
        }
        String urlString = url.toExternalForm();
        try {
            this.uriScrutinizer.scrutinize(new URI(urlString));
        }
        catch (URISyntaxException e1) {
            IllegalArgumentException iae2 = new IllegalArgumentException("xmlUri [" + xmlUriArg + "] resolved to a URI with bad syntax.");
            iae2.initCause(e1);
            throw iae2;
        }
        this.xmlUri = xmlUriArg;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("xmlUri = " + this.xmlUri + "\n");
        str.append("xslUri = " + this.xslUri + "\n");
        str.append("sslUri = " + this.sslUri + "\n");
        str.append("xslTitle = " + this.xslTitle + "\n");
        if (this.params != null) {
            str.append("params = " + this.params.toString() + "\n");
        }
        return str.toString();
    }

    public synchronized void setCacheContent(String key, Document data) {
        contentCache.put((Serializable)((Object)key), data);
        this.cacheContentLoaded = System.currentTimeMillis() - 2000L;
    }

    public synchronized Document getCacheContent(String key) {
        return contentCache.get(key);
    }

    public synchronized long getCacheContentLoaded() {
        return this.cacheContentLoaded;
    }
}

