/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.ccil.cowan.tagsoup.Parser;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.SaferHTMLHandler;
import org.jasig.portal.services.HttpClientManager;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XML;
import org.jasig.portal.utils.XSLT;
import org.jasig.portal.utils.uri.BlockedUriException;
import org.jasig.portal.utils.uri.IUriScrutinizer;
import org.jasig.portal.utils.uri.PrefixUriScrutinizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
public class CSyndFeed
extends BaseChannel
implements ICacheable {
    private static final String SSL_LOCATION = "CSyndFeed/CSyndFeed.ssl";
    private SyndFeed feed = null;
    private int cacheTimeout = 500;
    private IUriScrutinizer uriScrutinizer;
    private int limit = 15;
    private String xmlUri = null;

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        this.feed = CSyndFeed.getFeed(this.xmlUri);
        Document doc = this.feed == null ? CSyndFeed.buildErrorDocument() : CSyndFeed.buildNewsDocument(this.feed, this.limit);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("XML: " + XML.serializeNode(doc)));
        }
        XSLT xslt = XSLT.getTransformer(this);
        xslt.setXML(doc);
        xslt.setXSL(SSL_LOCATION, this.runtimeData.getBrowserInfo());
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        xslt.setTarget(out);
        xslt.transform();
    }

    private static Document buildErrorDocument() {
        Document doc = DocumentFactory.getNewDocument();
        Element newsNode = doc.createElement("error");
        newsNode.setTextContent("There was an error retrieving the news source. Please try back later.");
        doc.appendChild(newsNode);
        return doc;
    }

    private static Document buildNewsDocument(SyndFeed feed, int limit) {
        Document doc = DocumentFactory.getNewDocument();
        Element newsNode = doc.createElement("news");
        doc.appendChild(newsNode);
        Element temp = doc.createElement("desc");
        temp.setTextContent(feed.getDescription());
        newsNode.appendChild(temp);
        temp = doc.createElement("link");
        temp.setTextContent(SaferHTMLHandler.sanitizeURL(feed.getLink()));
        newsNode.appendChild(temp);
        SyndImage image = feed.getImage();
        if (image != null) {
            Element imageNode = doc.createElement("image");
            newsNode.appendChild(imageNode);
            temp = doc.createElement("url");
            temp.setTextContent(SaferHTMLHandler.sanitizeURL(image.getUrl()));
            imageNode.appendChild(temp);
            temp = doc.createElement("title");
            temp.setTextContent(image.getTitle());
            imageNode.appendChild(temp);
            temp = doc.createElement("description");
            temp.setTextContent(image.getDescription());
            imageNode.appendChild(temp);
            temp = doc.createElement("link");
            temp.setTextContent(SaferHTMLHandler.sanitizeURL(image.getLink()));
            imageNode.appendChild(temp);
        }
        Element itemsNode = doc.createElement("items");
        newsNode.appendChild(itemsNode);
        List entries = feed.getEntries();
        Iterator i = entries.iterator();
        for (int count = 0; i.hasNext() && count < limit; ++count) {
            SyndEntry item = (SyndEntry)i.next();
            Element itemNode = doc.createElement("item");
            itemsNode.appendChild(itemNode);
            Element n = doc.createElement("title");
            itemNode.appendChild(n);
            n.setTextContent(item.getTitle());
            n = doc.createElement("link");
            itemNode.appendChild(n);
            n.setTextContent(SaferHTMLHandler.sanitizeURL(item.getLink()));
            SyndContent sc = item.getDescription();
            if (sc == null) continue;
            String text = sc.getValue();
            n = doc.createElement("description");
            itemNode.appendChild(n);
            Parser p = new Parser();
            try {
                SaferHTMLHandler c = new SaferHTMLHandler(doc, n);
                p.setContentHandler((ContentHandler)c);
                p.parse(new InputSource(new StringReader(text)));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return doc;
    }

    @Override
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        this.staticData = sd;
        String allowXmlUriPrefixesParam = sd.getParameter("upc_allow_xmlUri_prefixes");
        String denyXmlUriPrefixesParam = sd.getParameter("upc_deny_xmlUri_prefixes");
        this.uriScrutinizer = PrefixUriScrutinizer.instanceFromParameters(allowXmlUriPrefixesParam, denyXmlUriPrefixesParam);
        String scrutinizeXmlUriAsStaticDataString = sd.getParameter("restrict_xmlUri_inStaticData");
        boolean scrutinizeXmlUriAsStaticData = "true".equals(scrutinizeXmlUriAsStaticDataString);
        String xmlUriParam = sd.getParameter("xmlUri");
        if (scrutinizeXmlUriAsStaticData) {
            this.setXmlUri(xmlUriParam);
        } else {
            this.xmlUri = xmlUriParam;
        }
        String param = sd.getParameter("cacheTimeout");
        try {
            this.cacheTimeout = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            this.cacheTimeout = 500;
        }
        param = sd.getParameter("viewNum");
        try {
            this.limit = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            this.limit = 15;
        }
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyndFeed getFeed(String xmlUri) throws PortalException {
        SyndFeed feed;
        block11: {
            try {
                SyndFeedInput input = new SyndFeedInput();
                if (xmlUri.substring(0, 7).equalsIgnoreCase("http://") || xmlUri.substring(0, 8).equalsIgnoreCase("https://")) {
                    HttpClient client = HttpClientManager.getNewHTTPClient();
                    GetMethod get = new GetMethod(xmlUri);
                    try {
                        get.setFollowRedirects(true);
                        int rc = client.executeMethod((HttpMethod)get);
                        if (rc != 200) {
                            throw new PortalException("HttpStatus:" + rc + " url: " + xmlUri);
                        }
                        InputStream in = get.getResponseBodyAsStream();
                        feed = input.build((Reader)new XmlReader(in));
                        break block11;
                    }
                    finally {
                        get.releaseConnection();
                    }
                }
                URL feedUrl = new URL(xmlUri);
                feed = input.build((Reader)new XmlReader(feedUrl));
            }
            catch (MalformedURLException e) {
                throw new PortalException(e);
            }
            catch (IllegalArgumentException e) {
                throw new PortalException(e);
            }
            catch (FeedException e) {
                throw new PortalException(e);
            }
            catch (IOException e) {
                throw new PortalException(e);
            }
            catch (BlockedUriException e) {
                throw new PortalException(e);
            }
        }
        return feed;
    }

    @Override
    public ChannelCacheKey generateKey() {
        ChannelCacheKey k = null;
        k = new ChannelCacheKey();
        k.setKeyScope(1);
        k.setKey("RSS:xmlUri:" + this.xmlUri + ",limit:" + this.limit);
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        if (!(validity instanceof Long)) {
            return false;
        }
        return System.currentTimeMillis() - (Long)validity < (long)(this.cacheTimeout * 1000);
    }

    private void setXmlUri(String xmlUriArg) {
        URL url = null;
        try {
            url = ResourceLoader.getResourceAsURL(this.getClass(), xmlUriArg);
        }
        catch (ResourceMissingException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Resource [" + xmlUriArg + "] missing.");
            iae.initCause(e);
            throw iae;
        }
        String urlString = url.toExternalForm();
        try {
            this.uriScrutinizer.scrutinize(new URI(urlString));
        }
        catch (URISyntaxException e1) {
            throw new IllegalArgumentException("xmlUri [" + xmlUriArg + "] resolved to a URI with bad syntax.");
        }
        this.xmlUri = xmlUriArg;
    }
}

