/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.jsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.channels.jsp.Deployer;

@Deprecated
public class DeploymentSpec {
    private static final SimpleDateFormat cFormatter = new SimpleDateFormat("yyyy.MMMMM.dd HH:mm");
    private static final String PROP_CAR_ID_DEPLOYED_SUFFIX = "_deployed";
    private static final String PROP_CAR_ID_PREFIX = "car_";
    private static final String PROP_CAR_COUNT = "carCount";
    private static final String DEPLOYMENT_FILE_NAME = "jspCars.deployed";
    private static final String DEPLOYMENT_PATH = "/WEB-INF";
    private static boolean initialized = false;
    private Properties mDeployInfo = null;
    private File mDepFile = null;
    private String mDepInfoPath = null;
    private int mCarCount = 0;
    private Map mCarIdsByCarPath;
    private static final DeploymentSpec instance = new DeploymentSpec();

    public static DeploymentSpec getInstance() throws PortalException {
        if (!initialized) {
            instance.loadDeploymentInfo();
        }
        return instance;
    }

    private DeploymentSpec() {
    }

    private String getDeploymentSpecPath() throws PortalException {
        if (this.mDepInfoPath == null) {
            ServletContext ctx = PortalSessionManager.getInstance().getServletContext();
            this.mDepInfoPath = ctx.getRealPath(DEPLOYMENT_PATH);
            if (this.mDepInfoPath == null) {
                throw new PortalException("Unable to locate WEB-INF directory.");
            }
        }
        return this.mDepInfoPath;
    }

    private void writeDeploymentSpec() throws PortalException {
        String filePath = this.getDeploymentSpecPath();
        String fullName = filePath + "/" + DEPLOYMENT_FILE_NAME;
        File dirPath = new File(filePath);
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        try {
            FileOutputStream out = new FileOutputStream(fullName);
            this.mDeployInfo.store(out, "Deployment information for JSP Car file resources. Generated by " + Deployer.class.getName() + ". Car paths " + "are relative to the CAR directory. Deployment paths for " + ".class and .properties files are relative to the value of " + "property " + "org.jasig.portal.channels.jsp.Deployer.context.relative.classesPath" + " while .jsp, .jspf, and .jsf files are relative to the " + "value of property " + "org.jasig.portal.channels.jsp.Deployer.context.relative.jspPath" + ". Both properties are specified in portal.properties and " + "should not be changed.");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new PortalException("Unable to store deployment information in '" + fullName + "'.", (Throwable)e);
        }
    }

    private String getNewCarEntryId() {
        int newId = ++this.mCarCount;
        this.mDeployInfo.setProperty(PROP_CAR_COUNT, "" + newId);
        return PROP_CAR_ID_PREFIX + newId;
    }

    public void addDeploymentFor(String carFilePath, List resources) throws PortalException {
        String carEntryId = (String)this.mCarIdsByCarPath.get(carFilePath);
        if (carEntryId == null) {
            carEntryId = this.getNewCarEntryId();
        }
        this.mDeployInfo.put(carEntryId, carFilePath);
        this.mDeployInfo.put(carEntryId + PROP_CAR_ID_DEPLOYED_SUFFIX, cFormatter.format(new Date()));
        for (String resource : resources) {
            this.mDeployInfo.put(resource, carEntryId);
        }
        this.writeDeploymentSpec();
    }

    public List removeEntriesFor(String carFilePath) {
        String carId = null;
        for (Map.Entry<Object, Object> entry : this.mDeployInfo.entrySet()) {
            if (!entry.getValue().equals(carFilePath)) continue;
            carId = (String)entry.getKey();
            break;
        }
        if (carId == null) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        Iterator<Map.Entry<Object, Object>> itr = this.mDeployInfo.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            if (!entry.getValue().equals(carId)) continue;
            String resPath = (String)entry.getKey();
            entries.add(resPath);
            itr.remove();
        }
        return entries;
    }

    public boolean isDeployInfoAvailableFor(String resource) {
        return this.mDeployInfo.containsKey(resource);
    }

    private void loadDeploymentInfo() throws PortalException {
        String path = this.getDeploymentSpecPath();
        this.mDepFile = new File(path + "/" + DEPLOYMENT_FILE_NAME);
        Properties newInfo = new Properties();
        HashMap<Object, String> carIdsByCarPath = new HashMap<Object, String>();
        int carCount = 0;
        if (this.mDepFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.mDepFile);
                newInfo.load(fis);
                String sCarCount = newInfo.getProperty(PROP_CAR_COUNT);
                carCount = Integer.parseInt(sCarCount);
                fis.close();
            }
            catch (Exception e) {
                throw new PortalException("Unable to load deployment information from file '" + this.mDepFile.getAbsolutePath() + "'.", (Throwable)e);
            }
            for (Map.Entry<Object, Object> entry : newInfo.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(PROP_CAR_ID_PREFIX) || key.endsWith(PROP_CAR_ID_DEPLOYED_SUFFIX)) continue;
                carIdsByCarPath.put(entry.getValue(), key);
            }
        }
        this.mCarIdsByCarPath = carIdsByCarPath;
        this.mCarCount = carCount;
        this.mDeployInfo = newInfo;
        initialized = true;
    }

    public long getTimeOfDeploymentForResource(String resourcePath) throws PortalException {
        String carDate = null;
        String carId = null;
        long depDate = -1L;
        try {
            carId = this.mDeployInfo.getProperty(resourcePath);
            if (carId != null) {
                carDate = this.mDeployInfo.getProperty(carId + PROP_CAR_ID_DEPLOYED_SUFFIX);
                depDate = cFormatter.parse(carDate).getTime();
            }
        }
        catch (Exception e1) {
            throw new PortalException("Unable to parse date '" + carDate + "' for entry '" + resourcePath + "' from file '" + this.mDepFile.getAbsolutePath() + "'.");
        }
        return depDate;
    }
}

