/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.portlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.pluto.descriptors.common.SecurityRoleRefDD;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.url.AbstractHttpServletRequestWrapper;

public class PortletHttpServletRequestWrapper
extends AbstractHttpServletRequestWrapper {
    public static final String ATTRIBUTE__HTTP_SERVLET_REQUEST = PortletHttpServletRequestWrapper.class.getName() + ".PORTLET_HTTP_SERVLET_REQUEST";
    private final Map<String, String[]> parameters;
    private final IPerson person;
    private final List<SecurityRoleRefDD> securityRoleRefs;

    public PortletHttpServletRequestWrapper(HttpServletRequest httpServletRequest, Map<String, List<String>> parameters, IPerson person, List<SecurityRoleRefDD> securityRoleRefs) {
        super(httpServletRequest);
        Validate.notNull(parameters, (String)"parameters can not be null");
        Validate.notNull((Object)person, (String)"person can not be null");
        Validate.notNull(securityRoleRefs, (String)"securityRoleRefs can not be null");
        this.parameters = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, List<String>> parameterEntry : parameters.entrySet()) {
            String name = parameterEntry.getKey();
            List<String> values = parameterEntry.getValue();
            if (values == null) {
                this.parameters.put(name, null);
                continue;
            }
            this.parameters.put(name, values.toArray(new String[values.size()]));
        }
        this.person = person;
        this.securityRoleRefs = securityRoleRefs;
    }

    @Override
    public Object getAttribute(String name) {
        if (ATTRIBUTE__HTTP_SERVLET_REQUEST.equals(name)) {
            return this;
        }
        return super.getAttribute(name);
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public boolean isUserInRole(String role) {
        boolean isUserInRole = super.isUserInRole(role);
        if (isUserInRole) {
            return true;
        }
        IGroupMember groupForRole = GroupService.getGroupMember(role, IEntityGroup.class);
        if (groupForRole == null) {
            return false;
        }
        EntityIdentifier personEntityId = this.person.getEntityIdentifier();
        IGroupMember personGroupMember = GroupService.getGroupMember(personEntityId);
        SecurityRoleRefDD securityRoleRef = this.getSecurityRoleRef(role);
        if (securityRoleRef == null) {
            return false;
        }
        String roleLink = securityRoleRef.getRoleLink();
        IGroupMember groupForRoleLink = GroupService.getGroupMember(roleLink, IEntityGroup.class);
        if (groupForRoleLink == null) {
            return false;
        }
        return personGroupMember.isDeepMemberOf(groupForRoleLink);
    }

    private SecurityRoleRefDD getSecurityRoleRef(String role) {
        for (SecurityRoleRefDD securityRoleRef : this.securityRoleRefs) {
            String roleRefName = securityRoleRef.getRoleName();
            if (!role.equals(roleRefName)) continue;
            return securityRoleRef;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PortletHttpServletRequestWrapper)) {
            return false;
        }
        PortletHttpServletRequestWrapper rhs = (PortletHttpServletRequestWrapper)object;
        return new EqualsBuilder().append((Object)this.getWrappedRequest(), (Object)rhs.getWrappedRequest()).append(this.parameters, rhs.parameters).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(500546767, -122181035).append((Object)this.getWrappedRequest()).append(this.parameters).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("wrappedRequest", (Object)this.getWrappedRequest()).append("parameters", this.parameters).toString();
    }
}

