/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.dao.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.type.NullableType;
import org.hibernate.usertype.UserType;

public class BaseEscapedStringType
implements UserType {
    private static final char QUOTING_CHAR = '\"';
    private final NullableType type;

    public BaseEscapedStringType(NullableType type) {
        Validate.notNull((Object)type);
        if (!String.class.isAssignableFrom(type.getReturnedClass())) {
            throw new IllegalArgumentException(type + " returns " + type.getReturnedClass() + " which cannot be cast to a " + String.class);
        }
        this.type = type;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return new String((String)value);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        if (x == null) {
            return 0;
        }
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String dbValue = (String)this.type.nullSafeGet(rs, names[0]);
        if (dbValue == null) {
            return null;
        }
        return this.unescape(dbValue);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value != null) {
            String escapedValue = this.escape((String)value);
            this.type.nullSafeSet(st, (Object)escapedValue, index);
        } else {
            this.type.nullSafeSet(st, value, index);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Class<?> returnedClass() {
        return String.class;
    }

    public int[] sqlTypes() {
        return new int[]{this.type.sqlType()};
    }

    protected String escape(String string) {
        return '\"' + string + '\"';
    }

    protected Object unescape(String string) throws HibernateException {
        if (string.charAt(0) != '\"' || string.charAt(string.length() - 1) != '\"') {
            throw new HibernateException("Persistent storage of " + this.getClass().getName() + " corrupted, database contained string [" + string + "] which should be surrouned by " + '\"' + " characters.");
        }
        return string.substring(1, string.length() - 1);
    }
}

