/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.ComponentGroupServiceDescriptor;
import org.jasig.portal.utils.ResourceLoader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GroupServiceConfiguration {
    private static final Log log = LogFactory.getLog(GroupServiceConfiguration.class);
    private static String SERVICES_XML = "/properties/groups/compositeGroupServices.xml";
    private static GroupServiceConfiguration configuration;
    private GroupConfigurationHandler serviceHandler;
    private List serviceDescriptors = new ArrayList();
    private Map attributes = new HashMap();

    public GroupServiceConfiguration() {
        this.serviceHandler = new GroupConfigurationHandler();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public static synchronized GroupServiceConfiguration getConfiguration() throws Exception {
        if (configuration == null) {
            configuration = new GroupServiceConfiguration();
            configuration.parseXml();
        }
        return configuration;
    }

    public String getDefaultService() {
        return (String)this.getAttributes().get("defaultService");
    }

    public String getNodeSeparator() {
        Object nodeSeparator = this.getAttributes().get("nodeSeparator");
        return nodeSeparator == null ? "." : (String)nodeSeparator;
    }

    public List getServiceDescriptors() {
        return this.serviceDescriptors;
    }

    protected void parseAttributes(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getQName(i);
            String value = atts.getValue(i);
            this.getAttributes().put(name, value);
        }
    }

    protected void parseXml() throws Exception {
        InputSource xmlSource = new InputSource(ResourceLoader.getResourceAsStream(GroupServiceConfiguration.class, SERVICES_XML));
        if (xmlSource != null) {
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setContentHandler(this.serviceHandler);
            reader.parse(xmlSource);
        }
    }

    public static synchronized void reset() {
        configuration = null;
    }

    class GroupConfigurationHandler
    extends DefaultHandler {
        ComponentGroupServiceDescriptor svcDescriptor;
        String elementName;
        StringBuffer elementValue;

        GroupConfigurationHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementName = qName;
            this.elementValue = new StringBuffer();
            if (qName.equals("servicelist")) {
                log.info((Object)"Parsing group service configuration.");
                GroupServiceConfiguration.this.parseAttributes(atts);
            } else if (qName.equals("service")) {
                log.debug((Object)"Parsing configuration for component service.");
                this.svcDescriptor = new ComponentGroupServiceDescriptor();
                for (int i = 0; i < atts.getLength(); ++i) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    this.svcDescriptor.put(name, value);
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            String val = this.elementValue.toString();
            if (qName.equals("service")) {
                GroupServiceConfiguration.this.serviceDescriptors.add(this.svcDescriptor);
                log.debug((Object)("Parsed configuration for " + this.svcDescriptor.getName()));
            } else if (qName.equals("servicelist")) {
                log.debug((Object)"Done parsing group service configuration.");
            } else if (qName.equals("internally_managed")) {
                this.svcDescriptor.setInternallyManaged("TRUE".equalsIgnoreCase(val));
            } else if (qName.equals("caching_enabled")) {
                this.svcDescriptor.setCachingEnabled("TRUE".equalsIgnoreCase(val));
            } else {
                this.svcDescriptor.setAttribute(this.elementName, val);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.elementName == null || this.elementName.equals("service") || this.elementName.equals("servicelist")) {
                return;
            }
            String chValue = new String(ch, start, length);
            this.elementValue.append(chValue);
        }
    }
}

