/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.smartldap;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.danann.cernunnos.Task;
import org.danann.cernunnos.TaskRequest;
import org.danann.cernunnos.runtime.RuntimeRequestResponse;
import org.danann.cernunnos.runtime.ScriptRunner;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.ComponentGroupServiceDescriptor;
import org.jasig.portal.groups.EntityTestingGroupImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntityGroupStoreFactory;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.smartldap.LdapRecord;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.services.PersonDirectory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public final class SmartLdapGroupStore
implements IEntityGroupStore {
    private ApplicationContext spring_context = null;
    private long groupsTreeRefreshIntervalSeconds = 900L;
    private volatile long lastTreeRefreshTime = 0L;
    private final ScriptRunner runner;
    private final Task initTask;
    private final Log log = LogFactory.getLog(this.getClass());
    private GroupsTree groupsTree;
    public static final String UNSUPPORTED_MESSAGE = "The SmartLdap implementation of JA-SIG Groups and Permissions (GaP) does not support this operation.";
    public static final String ROOT_KEY = "SmartLdap ROOT";
    public static final String ROOT_DESC = "A root group provided for the SmartLdapGroupStore.";
    public static final IEntityGroup ROOT_GROUP = SmartLdapGroupStore.createRootGroup();

    @Override
    public boolean contains(IEntityGroup group, IGroupMember member) throws GroupsException {
        this.log.warn((Object)"Unsupported method accessed:  SmartLdapGroupStore.contains");
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void delete(IEntityGroup group) throws GroupsException {
        this.log.warn((Object)"Unsupported method accessed:  SmartLdapGroupStore.delete");
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public IEntityGroup find(String key) throws GroupsException {
        if (this.isTreeRefreshRequired()) {
            this.refreshTree();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking find() for key:  " + key));
        }
        return this.groupsTree.getGroups().get(key);
    }

    @Override
    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        LinkedList<IEntityGroup> rslt;
        block14: {
            block13: {
                if (this.isTreeRefreshRequired()) {
                    this.refreshTree();
                }
                rslt = new LinkedList<IEntityGroup>();
                if (!gm.isGroup()) break block13;
                IEntityGroup group = (IEntityGroup)gm;
                List<String> list = this.groupsTree.getParents().get(group.getLocalKey());
                if (list == null) break block14;
                for (String s : list) {
                    rslt.add(this.groupsTree.getGroups().get(s));
                }
                break block14;
            }
            if (gm.isEntity() && gm.getEntityType().equals(ROOT_GROUP.getEntityType())) {
                EntityIdentifier ei = gm.getUnderlyingEntityIdentifier();
                HashMap seed = new HashMap();
                LinkedList<String> seedValue = new LinkedList<String>();
                seedValue.add(ei.getKey());
                seed.put("username", seedValue);
                Map attr = PersonDirectory.getPersonAttributeDao().getMultivaluedUserAttributes(seed);
                if (attr != null && !attr.isEmpty()) {
                    IPerson p = PersonFactory.createPerson();
                    p.setAttributes(attr);
                    String attrName = (String)this.spring_context.getBean("memberOfAttributeName");
                    Object[] groupKeys = p.getAttributeValues(attrName);
                    if (groupKeys != null) {
                        Object objs;
                        LinkedList<String> list = new LinkedList<String>();
                        if (groupKeys instanceof String) {
                            list.add((String)groupKeys);
                        } else if (groupKeys instanceof Object[]) {
                            objs = groupKeys;
                            for (Object o : objs) {
                                list.add((String)o);
                            }
                        } else if (groupKeys instanceof List) {
                            objs = (List)groupKeys;
                            Iterator i$ = objs.iterator();
                            while (i$.hasNext()) {
                                Object o = i$.next();
                                list.add((String)o);
                            }
                        }
                        for (String s : list) {
                            if (!this.groupsTree.getGroups().containsKey(s)) continue;
                            rslt.add(this.groupsTree.getGroups().get(s));
                        }
                    }
                }
            }
        }
        return rslt.iterator();
    }

    @Override
    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        if (this.isTreeRefreshRequired()) {
            this.refreshTree();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking findEntitiesForGroup() for group:  " + group.getLocalKey()));
        }
        return this.findMemberGroups(group);
    }

    @Override
    public ILockableEntityGroup findLockable(String key) throws GroupsException {
        this.log.warn((Object)"Unsupported method accessed:  SmartLdapGroupStore.findLockable");
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public String[] findMemberGroupKeys(IEntityGroup group) throws GroupsException {
        if (this.isTreeRefreshRequired()) {
            this.refreshTree();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking findMemberGroupKeys() for group:  " + group.getLocalKey()));
        }
        LinkedList<String> rslt = new LinkedList<String>();
        Iterator it = this.findMemberGroups(group);
        while (it.hasNext()) {
            IEntityGroup g = (IEntityGroup)it.next();
            rslt.add(g.getKey());
        }
        return rslt.toArray(new String[0]);
    }

    @Override
    public Iterator findMemberGroups(IEntityGroup group) throws GroupsException {
        if (this.isTreeRefreshRequired()) {
            this.refreshTree();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking findMemberGroups() for group:  " + group.getLocalKey()));
        }
        LinkedList<IEntityGroup> rslt = new LinkedList<IEntityGroup>();
        List<String> list = this.groupsTree.getChildren().get(group.getLocalKey());
        if (list != null) {
            for (String s : list) {
                rslt.add(this.groupsTree.getGroups().get(s));
            }
        }
        return rslt.iterator();
    }

    @Override
    public IEntityGroup newInstance(Class entityType) throws GroupsException {
        this.log.warn((Object)"Unsupported method accessed:  SmartLdapGroupStore.newInstance");
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        String[][] specials;
        if (this.isTreeRefreshRequired()) {
            this.refreshTree();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking searchForGroups():  query=" + query + ", method=" + method + ", leaftype=" + leaftype.getClass().getName()));
        }
        if (!leaftype.equals(ROOT_GROUP.getEntityType())) {
            return new EntityIdentifier[0];
        }
        for (String[] s : specials = new String[][]{{"\\", "\\\\"}, {"[", "\\["}, {"{", "\\{"}, {"^", "\\^"}, {"$", "\\$"}, {".", "\\."}, {"|", "\\|"}, {"?", "\\?"}, {"*", "\\*"}, {"+", "\\+"}, {"(", "\\("}, {")", "\\)"}}) {
            query = query.replace(s[0], s[1]);
        }
        String regex = null;
        switch (method) {
            case 1: {
                regex = query.toUpperCase();
                break;
            }
            case 2: {
                regex = query.toUpperCase() + ".*";
                break;
            }
            case 3: {
                regex = ".*" + query.toUpperCase();
                break;
            }
            case 4: {
                regex = ".*" + query.toUpperCase() + ".*";
                break;
            }
            default: {
                String msg = "Unsupported search method:  " + method;
                throw new GroupsException(msg);
            }
        }
        LinkedList<EntityIdentifier> rslt = new LinkedList<EntityIdentifier>();
        for (Map.Entry<String, List<String>> y : this.groupsTree.getKeysByUpperCaseName().entrySet()) {
            if (!y.getKey().matches(regex)) continue;
            List<String> keys = y.getValue();
            for (String k : keys) {
                rslt.add(new EntityIdentifier(k, IEntityGroup.class));
            }
        }
        return rslt.toArray(new EntityIdentifier[0]);
    }

    @Override
    public void update(IEntityGroup group) throws GroupsException {
        this.log.warn((Object)"Unsupported method accessed:  SmartLdapGroupStore.update");
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void updateMembers(IEntityGroup group) throws GroupsException {
        this.log.warn((Object)"Unsupported method accessed:  SmartLdapGroupStore.updateMembers");
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    private static IEntityGroup createRootGroup() {
        EntityTestingGroupImpl rslt = new EntityTestingGroupImpl(ROOT_KEY, IPerson.class);
        rslt.setCreatorID("System");
        rslt.setName(ROOT_KEY);
        rslt.setDescription(ROOT_DESC);
        return rslt;
    }

    private SmartLdapGroupStore() {
        URL u = this.getClass().getResource("/properties/groups/SmartLdapGroupStoreConfig.xml");
        this.spring_context = new FileSystemXmlApplicationContext(u.toExternalForm());
        if (this.spring_context.containsBean("groupsTreeRefreshIntervalSeconds")) {
            this.groupsTreeRefreshIntervalSeconds = (Long)this.spring_context.getBean("groupsTreeRefreshIntervalSeconds");
        }
        this.runner = new ScriptRunner();
        this.initTask = this.runner.compileTask(this.getClass().getResource("init.crn").toExternalForm());
    }

    private boolean isTreeRefreshRequired() {
        if (this.groupsTree == null) {
            return true;
        }
        if (this.groupsTreeRefreshIntervalSeconds <= 0L) {
            return false;
        }
        long treeExpiresTimestamp = this.lastTreeRefreshTime + this.groupsTreeRefreshIntervalSeconds * 1000L;
        return System.currentTimeMillis() > treeExpiresTimestamp;
    }

    private synchronized void refreshTree() {
        if (!this.isTreeRefreshRequired()) {
            return;
        }
        boolean doJoin = this.groupsTree == null;
        Thread refresh = new Thread("SmartLdap Refresh Worker"){

            @Override
            public void run() {
                SmartLdapGroupStore.this.groupsTree = SmartLdapGroupStore.this.buildGroupsTree();
            }
        };
        refresh.setDaemon(true);
        refresh.start();
        if (doJoin) {
            try {
                this.log.info((Object)"Joining the SmartLdap Refresh Worker Thread");
                refresh.join();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        this.lastTreeRefreshTime = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    private GroupsTree buildGroupsTree() {
        Map<String, IEntityGroup> new_groups = Collections.synchronizedMap(new HashMap());
        Map<String, List<String>> new_parents = Collections.synchronizedMap(new HashMap());
        Map<String, List<String>> new_children = Collections.synchronizedMap(new HashMap());
        Map<String, List<String>> new_keysByUpperCaseName = Collections.synchronizedMap(new HashMap());
        RuntimeRequestResponse req = new RuntimeRequestResponse();
        HashSet set = new HashSet();
        req.setAttribute("GROUPS", set);
        for (String name : this.spring_context.getBeanDefinitionNames()) {
            req.setAttribute(name, this.spring_context.getBean(name));
        }
        this.runner.run(this.initTask, (TaskRequest)req);
        if (this.log.isInfoEnabled()) {
            String msg = "init() found " + set.size() + " records.";
            this.log.info((Object)msg);
        }
        for (LdapRecord r : set) {
            IEntityGroup g = r.getGroup();
            new_groups.put(g.getLocalKey(), g);
        }
        for (LdapRecord r : set) {
            void var11_19;
            IEntityGroup g = r.getGroup();
            for (String string : r.getKeysOfChildren()) {
                if (!new_groups.containsKey(string)) break;
                List<String> parentsList = (List<String>)new_parents.get(string);
                if (parentsList == null) {
                    parentsList = Collections.synchronizedList(new LinkedList());
                    new_parents.put(string, parentsList);
                }
                parentsList.add(g.getLocalKey());
            }
            List<String> childrenList = Collections.synchronizedList(new LinkedList());
            for (String childKey : r.getKeysOfChildren()) {
                if (!new_groups.containsKey(childKey)) continue;
                childrenList.add(childKey);
            }
            new_children.put(g.getLocalKey(), childrenList);
            List list = (List)new_keysByUpperCaseName.get(g.getName().toUpperCase());
            if (list == null) {
                List list2 = Collections.synchronizedList(new LinkedList());
                new_keysByUpperCaseName.put(g.getName().toUpperCase(), list2);
            }
            var11_19.add(g.getLocalKey());
        }
        new_groups.put(ROOT_GROUP.getLocalKey(), ROOT_GROUP);
        List<String> childrenOfRoot = Collections.synchronizedList(new LinkedList());
        for (String possibleChildKey : new_groups.keySet()) {
            if (possibleChildKey.equals(ROOT_GROUP.getLocalKey()) || new_parents.containsKey(possibleChildKey)) continue;
            List<String> p = Collections.synchronizedList(new LinkedList());
            p.add(ROOT_GROUP.getLocalKey());
            new_parents.put(possibleChildKey, p);
            childrenOfRoot.add(possibleChildKey);
        }
        new_children.put(ROOT_GROUP.getLocalKey(), childrenOfRoot);
        List<String> groupsWithMyName = (List<String>)new_keysByUpperCaseName.get(ROOT_GROUP.getName().toUpperCase());
        if (groupsWithMyName == null) {
            groupsWithMyName = Collections.synchronizedList(new LinkedList());
            new_keysByUpperCaseName.put(ROOT_GROUP.getName().toUpperCase(), groupsWithMyName);
        }
        groupsWithMyName.add(ROOT_GROUP.getLocalKey());
        if (this.log.isInfoEnabled()) {
            String msg = "init() :: final size of each collection is as follows...\n\tgroups=" + new_groups.size() + "\n\tparents=" + new_parents.size() + "\n\tchildren=" + new_children.size() + "\n\tkeysByUpperCaseName=" + new_keysByUpperCaseName.size();
            this.log.info((Object)msg);
        }
        if (this.log.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.setLength(0);
            msg.append("Here are the keys of the new_groups collection:");
            for (String string : new_groups.keySet()) {
                msg.append("\n\t").append(string);
            }
            this.log.trace((Object)msg.toString());
            msg.setLength(0);
            msg.append("Here are the parents of each child in the new_parents collection:");
            for (Map.Entry entry : new_parents.entrySet()) {
                msg.append("\n\tchild=").append((String)entry.getKey());
                for (String s : (List)entry.getValue()) {
                    msg.append("\n\t\tparent=").append(s);
                }
            }
            this.log.trace((Object)msg.toString());
            msg.setLength(0);
            msg.append("Here are the children of each parent in the new_children collection:");
            for (Map.Entry entry : new_children.entrySet()) {
                msg.append("\n\tparent=").append((String)entry.getKey());
                for (String s : (List)entry.getValue()) {
                    msg.append("\n\t\tchild=").append(s);
                }
            }
            this.log.trace((Object)msg.toString());
            msg.append("Here are the groups that have each name in the new_keysByUpperCaseName collection:");
            for (Map.Entry entry : new_keysByUpperCaseName.entrySet()) {
                msg.append("\n\tname=").append((String)entry.getKey());
                for (String s : (List)entry.getValue()) {
                    msg.append("\n\t\tgroup=").append(s);
                }
            }
            this.log.trace((Object)msg.toString());
        }
        return new GroupsTree(new_groups, new_parents, new_children, new_keysByUpperCaseName);
    }

    private static final class GroupsTree {
        private final Map<String, IEntityGroup> groups;
        private final Map<String, List<String>> parents;
        private final Map<String, List<String>> children;
        private final Map<String, List<String>> keysByUpperCaseName;

        public GroupsTree(Map<String, IEntityGroup> groups, Map<String, List<String>> parents, Map<String, List<String>> children, Map<String, List<String>> keysByUpperCaseName) {
            if (groups == null) {
                String msg = "Argument 'groups' cannot be null.";
                throw new IllegalArgumentException(msg);
            }
            if (parents == null) {
                String msg = "Argument 'parents' cannot be null.";
                throw new IllegalArgumentException(msg);
            }
            if (children == null) {
                String msg = "Argument 'children' cannot be null.";
                throw new IllegalArgumentException(msg);
            }
            if (keysByUpperCaseName == null) {
                String msg = "Argument 'keysByUpperCaseName' cannot be null.";
                throw new IllegalArgumentException(msg);
            }
            this.groups = groups;
            this.parents = parents;
            this.children = children;
            this.keysByUpperCaseName = keysByUpperCaseName;
        }

        public Map<String, IEntityGroup> getGroups() {
            return this.groups;
        }

        public Map<String, List<String>> getParents() {
            return this.parents;
        }

        public Map<String, List<String>> getChildren() {
            return this.children;
        }

        public Map<String, List<String>> getKeysByUpperCaseName() {
            return this.keysByUpperCaseName;
        }
    }

    public static final class Factory
    implements IEntityGroupStoreFactory {
        private static final IEntityGroupStore INSTANCE = new SmartLdapGroupStore();

        @Override
        public IEntityGroupStore newGroupStore() throws GroupsException {
            return INSTANCE;
        }

        @Override
        public IEntityGroupStore newGroupStore(ComponentGroupServiceDescriptor svcDescriptor) throws GroupsException {
            return INSTANCE;
        }
    }
}

