/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io;

import java.io.Writer;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.io.AbstractTokenReplacementFilter;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;

public class ChannelTitleIncorporationWiterFilter
extends AbstractTokenReplacementFilter {
    public static final String TITLE_TOKEN_PREFIX = "UP:CHANNEL_TITLE-{";
    public static final int MAX_CHANNEL_ID_LENGTH = 32;
    public static final String TITLE_TOKEN_SUFFIX = "}";
    private final ChannelManager channelManager;
    private final IUserLayoutManager userLayoutManager;

    public ChannelTitleIncorporationWiterFilter(Writer wrappedWriter, ChannelManager channelManager, IUserLayoutManager userLayoutManager) {
        super(wrappedWriter, TITLE_TOKEN_PREFIX, 32, TITLE_TOKEN_SUFFIX);
        this.channelManager = channelManager;
        this.userLayoutManager = userLayoutManager;
    }

    @Override
    protected String replaceToken(String channelId) {
        IUserLayoutChannelDescription channelNode = (IUserLayoutChannelDescription)this.userLayoutManager.getNode(channelId);
        boolean disableDynamicTitle = Boolean.valueOf(channelNode.getParameterValue("disableDynamicTitle"));
        String title = null;
        if (!disableDynamicTitle) {
            title = this.channelManager.getChannelTitle(channelId);
        }
        if (title == null) {
            title = channelNode.getTitle();
        }
        return title;
    }
}

