/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jasig.portal.lang.Resources;
import org.jasig.portal.lang.ThrowableHelper;
import org.jasig.portal.lang.TypeConverter;

public final class StackTrace {
    private static final int DEFAULT_STACK_TRACE_ARRAY_SIZE = TypeConverter.toInt(Resources.getString(StackTrace.class, "getStackTraceElement.default_stack_trace_array_size"));
    private static final int NATIVE_METHOD = -2;
    private static final int PRIME = 31;
    private String mFileName;
    private String mClassName;
    private String mMethodName;
    private int mLineNumber = -1;

    public final String getFileName() {
        String fileName = this.mFileName;
        if (null == fileName) {
            fileName = Resources.getString(StackTrace.class, "unknown_source");
        }
        return fileName;
    }

    public final String getClassName() {
        return this.mClassName;
    }

    public final String getMethodName() {
        return this.mMethodName;
    }

    public final int getLineNumber() {
        return this.mLineNumber;
    }

    public final boolean isNativeMethod() {
        return -2 == this.mLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StackTrace[] getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        StackTrace[] elements = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            elements = StackTrace.getStackTrace(throwable, stringWriter.toString());
        }
        finally {
            if (null != printWriter) {
                printWriter.close();
            }
        }
        return elements;
    }

    static final StackTrace[] getStackTrace(Throwable throwable, String stackTrace) {
        if (null == throwable) {
            throw new NullPointerException(ThrowableHelper.getInternationalizedMessage(StackTrace.class, "getStackTraceElement.error.throwable_is_null"));
        }
        if (null == stackTrace) {
            throw new NullPointerException(ThrowableHelper.getInternationalizedMessage(StackTrace.class, "getStackTraceElement.error.stack_trace_is_null"));
        }
        if (stackTrace.equals("")) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(StackTrace.class, "getStackTraceElement.error.stack_trace_is_empty"));
        }
        return StackTrace.parseStackTrace(throwable, stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StackTrace[] getStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        StackTrace[] clientFrames = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            Throwable t = new Throwable();
            t.printStackTrace(printWriter);
            printWriter.close();
            StackTrace[] frames = StackTrace.getStackTrace(t, stringWriter.toString());
            clientFrames = new StackTrace[frames.length - 1];
            System.arraycopy(frames, 1, clientFrames, 0, clientFrames.length);
        }
        finally {
            if (null != printWriter) {
                printWriter.close();
            }
        }
        return clientFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StackTrace getStackTrace(int index) {
        StackTrace element = null;
        PrintWriter printWriter = null;
        try {
            if (0 <= index) {
                String moniker = "dummy moniker";
                StringWriter stringWriter = new StringWriter();
                printWriter = new PrintWriter(stringWriter);
                Throwable throwable = new Throwable(moniker);
                throwable.printStackTrace(printWriter);
                StackTrace[] elements = StackTrace.getStackTrace(throwable, stringWriter.toString());
                if (0 < index + 1 && elements.length > index + 1) {
                    element = elements[index + 1];
                }
            }
        }
        finally {
            if (null != printWriter) {
                printWriter.close();
            }
        }
        return element;
    }

    static final StackTrace[] convertStackTrace(Object[] stackTrace) {
        int size = stackTrace.length;
        StackTrace[] elements = new StackTrace[size];
        for (int i = 0; i < size; ++i) {
            elements[i] = StackTrace.convertElement(stackTrace[i]);
        }
        return elements;
    }

    private static final StackTrace convertElement(Object element) {
        StackTrace stackTraceElement = null;
        try {
            Method getClassName = element.getClass().getMethod("getClassName", null);
            Method getMethodName = element.getClass().getMethod("getMethodName", null);
            Method getFileName = element.getClass().getMethod("getFileName", null);
            Method getLineNumber = element.getClass().getMethod("getLineNumber", null);
            stackTraceElement = new StackTrace((String)getClassName.invoke(element, (Object[])null), (String)getMethodName.invoke(element, (Object[])null), (String)getFileName.invoke(element, (Object[])null), (Integer)getLineNumber.invoke(element, (Object[])null));
        }
        catch (Exception x) {
            ThrowableHelper.handle(x);
        }
        return stackTraceElement;
    }

    private static final StackTrace[] parseStackTrace(Throwable throwable, String stackTrace) {
        try {
            stackTrace = stackTrace.substring(null != throwable.getLocalizedMessage() ? (throwable.getClass().getName() + ":" + throwable.getLocalizedMessage()).length() + 1 : throwable.getClass().getName().length() + 1);
        }
        catch (IndexOutOfBoundsException x) {
            ThrowableHelper.handle(x);
        }
        Object[] stackTraceObjects = StackTrace.parseStackTrace(stackTrace);
        StackTrace[] stackTraceArray = new StackTrace[stackTraceObjects.length];
        if (null != stackTraceObjects) {
            System.arraycopy(stackTraceObjects, 0, stackTraceArray, 0, stackTraceArray.length);
        }
        return stackTraceArray;
    }

    private static final Object[] parseStackTrace(String stackTrace) {
        ParseState state = new ParseState(stackTrace);
        ArrayList<StackTrace> stackTraceElements = new ArrayList<StackTrace>(DEFAULT_STACK_TRACE_ARRAY_SIZE);
        while (state.mIndex + 3 < state.mSize) {
            StackTrace frame = StackTrace.parseStackTrace(state);
            stackTraceElements.add(frame);
        }
        return stackTraceElements.toArray();
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(this.mClassName).append(".").append(this.mMethodName);
        if (this.isNativeMethod()) {
            buffer.append("(" + Resources.getString(StackTrace.class, "native_method") + ")");
        } else if (null != this.mFileName && 0 <= this.mLineNumber) {
            buffer.append("(").append(this.mFileName).append(":").append(this.mLineNumber).append(")");
        } else if (null != this.mFileName) {
            buffer.append("(").append(this.mFileName).append(")");
        } else {
            buffer.append("(" + Resources.getString(StackTrace.class, "unknown_source") + ")");
        }
        return buffer.toString();
    }

    public static final String toString(StackTrace[] elements) {
        String sep = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            buffer.append(elements[i].toString()).append(sep);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj instanceof StackTrace) {
            StackTrace e = (StackTrace)obj;
            isEqual = e.mClassName.equals(this.mClassName) && e.mLineNumber == this.mLineNumber && StackTrace.eq(this.mMethodName, e.mMethodName) && StackTrace.eq(this.mFileName, e.mFileName);
        }
        return isEqual;
    }

    private static final boolean eq(Object a, Object b) {
        return a == b || null != a && a.equals(b);
    }

    public int hashCode() {
        int result = 31 * this.mClassName.hashCode() + this.mMethodName.hashCode();
        result = 31 * result + (null == this.mFileName ? 0 : this.mFileName.hashCode());
        result = 31 * result + this.mLineNumber;
        return result;
    }

    private StackTrace(String className, String methodName, String fileName, int lineNumber) {
        this.mClassName = className;
        this.mMethodName = methodName;
        this.mFileName = fileName;
        this.mLineNumber = lineNumber;
    }

    private static final StackTrace parseStackTrace(ParseState state) {
        int classNameStart;
        String className = null;
        String methodName = null;
        String fileName = null;
        int lineNumber = -1;
        int methodNameStart = 0;
        int methodNameEnd = 0;
        while (state.mIndex + 2 < state.mSize) {
            if ('a' == state.mStackTraceCharacters[state.mIndex] && 't' == state.mStackTraceCharacters[state.mIndex + 1] && ' ' == state.mStackTraceCharacters[state.mIndex + 2]) {
                state.mIndex += 3;
                break;
            }
            state.mIndex++;
        }
        int classNameEnd = classNameStart = state.mIndex;
        while (state.mIndex < state.mSize) {
            if ('.' == state.mStackTraceCharacters[state.mIndex]) {
                classNameEnd = state.mIndex;
                methodNameStart = classNameEnd + 1;
            } else if ('(' == state.mStackTraceCharacters[state.mIndex]) {
                methodNameEnd = state.mIndex;
                break;
            }
            state.mIndex++;
        }
        try {
            className = state.mStackTrace.substring(classNameStart, classNameEnd);
        }
        catch (IndexOutOfBoundsException x) {
            ThrowableHelper.handle(x);
        }
        try {
            methodName = state.mStackTrace.substring(methodNameStart, methodNameEnd);
        }
        catch (IndexOutOfBoundsException x) {
            ThrowableHelper.handle(x);
        }
        int fileNameStart = state.mIndex + 1;
        if (state.mIndex + 14 < state.mSize && 'U' == state.mStackTraceCharacters[state.mIndex + 1] && 'n' == state.mStackTraceCharacters[state.mIndex + 2] && 'k' == state.mStackTraceCharacters[state.mIndex + 3] && 'n' == state.mStackTraceCharacters[state.mIndex + 4] && 'o' == state.mStackTraceCharacters[state.mIndex + 5] && 'w' == state.mStackTraceCharacters[state.mIndex + 6] && 'n' == state.mStackTraceCharacters[state.mIndex + 7] && ' ' == state.mStackTraceCharacters[state.mIndex + 8] && 'S' == state.mStackTraceCharacters[state.mIndex + 9] && 'o' == state.mStackTraceCharacters[state.mIndex + 10] && 'u' == state.mStackTraceCharacters[state.mIndex + 11] && 'r' == state.mStackTraceCharacters[state.mIndex + 12] && 'c' == state.mStackTraceCharacters[state.mIndex + 13] && 'e' == state.mStackTraceCharacters[state.mIndex + 14]) {
            fileName = null;
            lineNumber = -1;
        } else if (state.mIndex + 13 < state.mSize && 'N' == state.mStackTraceCharacters[state.mIndex + 1] && 'a' == state.mStackTraceCharacters[state.mIndex + 2] && 't' == state.mStackTraceCharacters[state.mIndex + 3] && 'i' == state.mStackTraceCharacters[state.mIndex + 4] && 'v' == state.mStackTraceCharacters[state.mIndex + 5] && 'e' == state.mStackTraceCharacters[state.mIndex + 6] && ' ' == state.mStackTraceCharacters[state.mIndex + 7] && 'M' == state.mStackTraceCharacters[state.mIndex + 8] && 'e' == state.mStackTraceCharacters[state.mIndex + 9] && 't' == state.mStackTraceCharacters[state.mIndex + 10] && 'h' == state.mStackTraceCharacters[state.mIndex + 11] && 'o' == state.mStackTraceCharacters[state.mIndex + 12] && 'd' == state.mStackTraceCharacters[state.mIndex + 13]) {
            lineNumber = -2;
        } else {
            block6: while (state.mIndex < state.mSize) {
                char ch = state.mStackTraceCharacters[state.mIndex];
                if ('\n' == ch || '\r' == ch) {
                    if (state.mIndex + 1 >= state.mSize || '\n' != state.mStackTraceCharacters[state.mIndex + 1]) break;
                    state.mIndex++;
                    break;
                }
                if ('.' == ch) {
                    int fileNameEnd = state.mIndex + 5;
                    int lineNumberStart = fileNameEnd + 1;
                    fileName = state.mStackTrace.substring(fileNameStart, fileNameEnd);
                    state.mIndex = lineNumberStart;
                    while (state.mIndex < state.mSize) {
                        ch = state.mStackTraceCharacters[state.mIndex];
                        if ('\n' == ch || '\r' == ch) {
                            if (state.mIndex + 1 >= state.mSize || '\n' != state.mStackTraceCharacters[state.mIndex + 1]) break block6;
                            state.mIndex++;
                            break block6;
                        }
                        if (')' == state.mStackTraceCharacters[state.mIndex]) {
                            int lineNumberEnd = state.mIndex;
                            lineNumber = TypeConverter.toInt(state.mStackTrace.substring(lineNumberStart, lineNumberEnd));
                        }
                        state.mIndex++;
                    }
                    break;
                }
                state.mIndex++;
            }
        }
        StackTrace frame = new StackTrace(className, methodName, fileName, lineNumber);
        return frame;
    }

    private static class ParseState {
        private String mStackTrace;
        private char[] mStackTraceCharacters;
        private int mSize;
        private int mIndex;

        private ParseState(String stackTrace) {
            this.mStackTrace = stackTrace;
            this.mStackTraceCharacters = this.mStackTrace.toCharArray();
            this.mSize = this.mStackTraceCharacters.length;
            this.mIndex = 0;
        }
    }
}

