/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutChannelDescription;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class TransientUserLayoutManagerWrapper
implements IUserLayoutManager {
    private static final Log log = LogFactory.getLog(TransientUserLayoutManagerWrapper.class);
    public static final String TRANSIENT_FOLDER_ID = "ft1";
    public static final String SUBSCRIBE_PREFIX = "ctf";
    private IUserLayoutManager man = null;
    private Map mFnameMap = Collections.synchronizedMap(new HashMap());
    private Map mSubIdMap = Collections.synchronizedMap(new HashMap());
    private Map mChanMap = Collections.synchronizedMap(new HashMap());
    private String mFocusedId = "";
    private int mSubId = 0;

    public TransientUserLayoutManagerWrapper(IUserLayoutManager manager) throws PortalException {
        this.man = manager;
        if (this.man == null) {
            throw new PortalException("Cannot wrap a null IUserLayoutManager !");
        }
    }

    public IUserLayoutManager getOriginalLayoutManager() throws PortalException {
        return this.man;
    }

    public void setOriginalLayoutManager(IUserLayoutManager man) throws PortalException {
        this.man = man;
    }

    @Override
    public IUserLayout getUserLayout() throws PortalException {
        return this.man.getUserLayout();
    }

    @Override
    public void setUserLayout(IUserLayout userLayout) throws PortalException {
        this.man.setUserLayout(userLayout);
    }

    @Override
    public void getUserLayout(ContentHandler ch) throws PortalException {
        this.man.getUserLayout(new TransientUserLayoutManagerSAXFilter(ch));
    }

    @Override
    public void getUserLayout(String nodeId, ContentHandler ch) throws PortalException {
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        if (null != node) {
            IUserLayoutNodeDescription layoutNode = null;
            try {
                layoutNode = this.man.getNode(nodeId);
            }
            catch (PortalException pe) {
                // empty catch block
            }
            if (layoutNode != null) {
                this.man.getUserLayout(nodeId, new TransientUserLayoutManagerSAXFilter(ch));
            } else {
                Document doc = DocumentFactory.getNewDocument();
                try {
                    Element e = node.getXML(doc);
                    doc.appendChild(e);
                    Transformer trans = TransformerFactory.newInstance().newTransformer();
                    trans.transform(new DOMSource(doc), new SAXResult(new TransientUserLayoutManagerSAXFilter(ch)));
                }
                catch (Exception e) {
                    throw new PortalException("Encountered an exception trying to output user layout", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setLayoutStore(IUserLayoutStore ls) {
        this.man.setLayoutStore(ls);
    }

    @Override
    public Document getUserLayoutDOM() throws PortalException {
        return this.man.getUserLayoutDOM();
    }

    @Override
    public void loadUserLayout() throws PortalException {
        this.man.loadUserLayout();
    }

    @Override
    public void loadUserLayout(boolean reload) throws PortalException {
        this.man.loadUserLayout(reload);
    }

    @Override
    public void saveUserLayout() throws PortalException {
        this.man.saveUserLayout();
    }

    @Override
    public IUserLayoutNodeDescription getNode(String nodeId) throws PortalException {
        IUserLayoutNodeDescription ulnd;
        block3: {
            ulnd = null;
            try {
                ulnd = this.man.getNode(nodeId);
            }
            catch (PortalException pe) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Node '" + nodeId + "' is not in layout, " + "checking for a transient node..."));
            }
        }
        if (null == ulnd) {
            ulnd = this.getTransientNode(nodeId);
        }
        return ulnd;
    }

    @Override
    public IUserLayoutNodeDescription addNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.man.addNode(node, parentId, nextSiblingId);
    }

    @Override
    public boolean moveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.moveNode(nodeId, parentId, nextSiblingId);
        }
        return false;
    }

    @Override
    public boolean deleteNode(String nodeId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.deleteNode(nodeId);
        }
        return false;
    }

    @Override
    public boolean updateNode(IUserLayoutNodeDescription node) throws PortalException {
        String nodeId = node.getId();
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.updateNode(node);
        }
        return false;
    }

    @Override
    public boolean canAddNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.man.canAddNode(node, parentId, nextSiblingId);
    }

    @Override
    public boolean canMoveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canMoveNode(nodeId, parentId, nextSiblingId);
        }
        return false;
    }

    @Override
    public boolean canDeleteNode(String nodeId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canDeleteNode(nodeId);
        }
        return false;
    }

    @Override
    public boolean canUpdateNode(IUserLayoutNodeDescription node) throws PortalException {
        String nodeId = node.getId();
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canUpdateNode(node);
        }
        return false;
    }

    @Override
    public void markAddTargets(IUserLayoutNodeDescription node) throws PortalException {
        this.man.markAddTargets(node);
    }

    @Override
    public void markMoveTargets(String nodeId) throws PortalException {
        this.man.markMoveTargets(nodeId);
    }

    @Override
    public String getParentId(String nodeId) throws PortalException {
        if (this.mChanMap.containsKey(nodeId) || TRANSIENT_FOLDER_ID.equals(nodeId)) {
            return null;
        }
        return this.man.getParentId(nodeId);
    }

    public Enumeration getChildIds(String nodeId) throws PortalException {
        return this.man.getChildIds(nodeId);
    }

    @Override
    public String getNextSiblingId(String nodeId) throws PortalException {
        return this.man.getNextSiblingId(nodeId);
    }

    @Override
    public String getPreviousSiblingId(String nodeId) throws PortalException {
        return this.man.getPreviousSiblingId(nodeId);
    }

    @Override
    public String getCacheKey() throws PortalException {
        return this.man.getCacheKey();
    }

    @Override
    public int getLayoutId() {
        return this.man.getLayoutId();
    }

    @Override
    public String getRootFolderId() {
        return this.man.getRootFolderId();
    }

    @Override
    public int getDepth(String nodeId) throws PortalException {
        return this.man.getDepth(nodeId);
    }

    @Override
    public IUserLayoutNodeDescription createNodeDescription(int nodeType) throws PortalException {
        return this.man.createNodeDescription(nodeType);
    }

    @Override
    public boolean addLayoutEventListener(LayoutEventListener l) {
        return this.man.addLayoutEventListener(l);
    }

    @Override
    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return this.man.removeLayoutEventListener(l);
    }

    protected IChannelDefinition getChannelDefinition(String subId) throws PortalException {
        IChannelDefinition chanDef = (IChannelDefinition)this.mChanMap.get(subId);
        if (null == chanDef) {
            String fname = this.getFname(subId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("TransientUserLayoutManagerWrapper>>getChannelDefinition, attempting to get a channel definition using functional name: " + fname));
            }
            try {
                chanDef = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(fname);
            }
            catch (Exception e) {
                throw new PortalException("Failed to get channel information for subscribeId: " + subId);
            }
            this.mChanMap.put(subId, chanDef);
        }
        return chanDef;
    }

    public String getFname(String subId) {
        return (String)this.mSubIdMap.get(subId);
    }

    @Override
    public String getSubscribeId(String fname) throws PortalException {
        String subId = (String)this.mFnameMap.get(fname);
        if (subId == null) {
            subId = this.man.getSubscribeId(fname);
        }
        if (subId == null) {
            try {
                IChannelDefinition chanDef = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(fname);
                if (chanDef != null) {
                    subId = this.getNextSubscribeId();
                    this.mFnameMap.put(fname, subId);
                    this.mSubIdMap.put(subId, fname);
                    this.mChanMap.put(subId, chanDef);
                }
            }
            catch (Exception e) {
                log.error((Object)("TransientUserLayoutManagerWrapper::getSubscribeId() : an exception encountered while trying to obtain ChannelDefinition for fname \"" + fname + "\" : " + e));
                subId = null;
            }
        }
        return subId;
    }

    public String getFocusedId() {
        return this.mFocusedId;
    }

    public void setFocusedId(String subscribeId) {
        this.mFocusedId = subscribeId;
    }

    private IUserLayoutChannelDescription getTransientNode(String nodeId) throws PortalException {
        String fname = this.getFname(nodeId);
        if (null == fname || fname.equals("")) {
            throw new PortalException("Could not find a transient node for id: " + nodeId);
        }
        UserLayoutChannelDescription ulnd = new UserLayoutChannelDescription();
        try {
            IChannelDefinition chanDef = (IChannelDefinition)this.mChanMap.get(nodeId);
            if (null == chanDef) {
                chanDef = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(fname);
                this.mChanMap.put(nodeId, chanDef);
            }
            ulnd.setId(nodeId);
            ulnd.setName(chanDef.getName());
            ulnd.setUnremovable(true);
            ulnd.setImmutable(true);
            ulnd.setHidden(false);
            ulnd.setTitle(chanDef.getTitle());
            ulnd.setDescription(chanDef.getDescription());
            ulnd.setClassName(chanDef.getJavaClass());
            ulnd.setChannelPublishId("" + chanDef.getId());
            ulnd.setChannelTypeId("" + chanDef.getTypeId());
            ulnd.setFunctionalName(chanDef.getFName());
            ulnd.setTimeout(chanDef.getTimeout());
            ulnd.setEditable(chanDef.isEditable());
            ulnd.setHasHelp(chanDef.hasHelp());
            ulnd.setHasAbout(chanDef.hasAbout());
            Set<IChannelParameter> parms = chanDef.getParameters();
            for (IChannelParameter parm : parms) {
                ulnd.setParameterValue(parm.getName(), parm.getValue());
                ulnd.setParameterOverride(parm.getName(), parm.getOverride());
            }
        }
        catch (Exception e) {
            throw new PortalException("Failed to obtain channel definition using fname: " + fname);
        }
        return ulnd;
    }

    private synchronized String getNextSubscribeId() {
        ++this.mSubId;
        return SUBSCRIBE_PREFIX + this.mSubId;
    }

    @Override
    public void processLayoutParameters(IPerson person, UserPreferences userPrefs, HttpServletRequest req) throws PortalException {
        this.man.processLayoutParameters(person, userPrefs, req);
    }

    class TransientUserLayoutManagerSAXFilter
    extends SAX2FilterImpl {
        private static final String LAYOUT = "layout";
        private static final String LAYOUT_FRAGMENT = "layout_fragment";
        private static final String FOLDER = "folder";
        private static final String CHANNEL = "channel";
        private static final String PARAMETER = "parameter";

        public TransientUserLayoutManagerSAXFilter(ContentHandler handler) {
            super(handler);
        }

        public TransientUserLayoutManagerSAXFilter(XMLReader parent) {
            super(parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String id = atts.getValue("ID");
            if (null != id && id.equals(TransientUserLayoutManagerWrapper.this.getRootFolderId())) {
                super.startElement(uri, localName, qName, atts);
                AttributesImpl folderAtts = new AttributesImpl();
                folderAtts.addAttribute("", "ID", "ID", "ID", TransientUserLayoutManagerWrapper.TRANSIENT_FOLDER_ID);
                folderAtts.addAttribute("", "type", "type", "CDATA", "regular");
                folderAtts.addAttribute("", "hidden", "hidden", "CDATA", "true");
                folderAtts.addAttribute("", "unremovable", "unremovable", "CDATA", "true");
                folderAtts.addAttribute("", "immutable", "immutable", "CDATA", "true");
                folderAtts.addAttribute("", "name", "name", "CDATA", "Transient Folder");
                this.startElement("", FOLDER, FOLDER, folderAtts);
                return;
            }
            if (qName.equals(FOLDER)) {
                id = atts.getValue("ID");
                if (null != id && id.equals(TransientUserLayoutManagerWrapper.TRANSIENT_FOLDER_ID)) {
                    super.startElement(uri, localName, qName, atts);
                    String subscribeId = "";
                    try {
                        subscribeId = TransientUserLayoutManagerWrapper.this.getFocusedId();
                        if (null != subscribeId && !subscribeId.equals("") && TransientUserLayoutManagerWrapper.this.mSubIdMap.containsKey(subscribeId)) {
                            IChannelDefinition chanDef = TransientUserLayoutManagerWrapper.this.getChannelDefinition(subscribeId);
                            AttributesImpl channelAttrs = new AttributesImpl();
                            channelAttrs.addAttribute("", "ID", "ID", "ID", subscribeId);
                            channelAttrs.addAttribute("", "typeID", "typeID", "CDATA", "" + chanDef.getTypeId());
                            channelAttrs.addAttribute("", "hidden", "hidden", "CDATA", "false");
                            channelAttrs.addAttribute("", "editable", "editable", "CDATA", CommonUtils.boolToStr(chanDef.isEditable()));
                            channelAttrs.addAttribute("", "unremovable", "unremovable", "CDATA", "true");
                            channelAttrs.addAttribute("", "name", "name", "CDATA", chanDef.getName());
                            channelAttrs.addAttribute("", "description", "description", "CDATA", chanDef.getDescription());
                            channelAttrs.addAttribute("", "title", "title", "CDATA", chanDef.getTitle());
                            channelAttrs.addAttribute("", "class", "class", "CDATA", chanDef.getJavaClass());
                            channelAttrs.addAttribute("", "chanID", "chanID", "CDATA", "" + chanDef.getId());
                            channelAttrs.addAttribute("", "fname", "fname", "CDATA", chanDef.getFName());
                            channelAttrs.addAttribute("", "timeout", "timeout", "CDATA", "" + chanDef.getTimeout());
                            channelAttrs.addAttribute("", "hasHelp", "hasHelp", "CDATA", CommonUtils.boolToStr(chanDef.hasHelp()));
                            channelAttrs.addAttribute("", "hasAbout", "hasAbout", "CDATA", CommonUtils.boolToStr(chanDef.hasAbout()));
                            this.startElement("", CHANNEL, CHANNEL, channelAttrs);
                            Set<IChannelParameter> chanParms = chanDef.getParameters();
                            for (IChannelParameter parm : chanParms) {
                                AttributesImpl parmAttrs = new AttributesImpl();
                                parmAttrs.addAttribute("", "name", "name", "CDATA", parm.getName());
                                parmAttrs.addAttribute("", "value", "value", "CDATA", parm.getValue());
                                this.startElement("", PARAMETER, PARAMETER, parmAttrs);
                                this.endElement("", PARAMETER, PARAMETER);
                            }
                            this.endElement("", CHANNEL, CHANNEL);
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Could not obtain channel definition from database for subscribe id: " + subscribeId), (Throwable)e);
                    }
                    super.endElement(uri, localName, qName);
                    return;
                }
                AttributesImpl attsImpl = new AttributesImpl(atts);
                super.startElement(uri, localName, qName, attsImpl);
            } else {
                AttributesImpl attsImpl = new AttributesImpl(atts);
                super.startElement(uri, localName, qName, attsImpl);
            }
        }
    }
}

