/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.UserIdentityStoreFactory;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.dlm.DistributedUserPreferences;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.layout.dlm.UserView;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FragmentActivator
extends SingletonDoubleCheckedCreator<Boolean> {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(FragmentActivator.class);
    private final List<FragmentDefinition> fragments;
    private final IUserIdentityStore identityStore = UserIdentityStoreFactory.getUserIdentityStoreImpl();
    private final RDBMDistributedLayoutStore dls;
    private final Map<String, UserView> userViews;
    private static final int CHANNELS = 0;
    private static final int FOLDERS = 1;

    public FragmentActivator(RDBMDistributedLayoutStore dls, List<FragmentDefinition> fragments) {
        this.dls = dls;
        this.userViews = new ConcurrentHashMap<String, UserView>();
        this.fragments = fragments;
    }

    void activateFragments() {
        this.get(new Object[0]);
    }

    @Override
    protected Boolean createSingleton(Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\n\n------ Distributed Layout ------\nproperties loaded = " + this.dls.getPropertyCount() + "\nfragment definitions loaded = " + (this.fragments == null ? 0 : this.fragments.size()) + "\n\n------ Beginning Activation ------\n"));
        }
        if (this.fragments == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"\n\nNo Fragments to Activate.");
            }
        } else {
            for (FragmentDefinition fragmentDefinition : this.fragments) {
                this.activateFragment(fragmentDefinition);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"\n\n------ done with Activation ------\n");
        }
        return true;
    }

    private void activateFragment(FragmentDefinition fd) {
        if (fd == null) {
            String msg = "Argument 'fd' [FragmentDefinition] cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (fd.isNoAudienceIncluded()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\n\n------ skipping " + fd + " - " + fd.getName() + ", no evaluators found"));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\n\n------ activating " + fd + " - " + fd.getName()));
            }
            try {
                IPerson owner = this.bindToOwner(fd);
                UserView view = new UserView(owner.getID());
                this.loadLayout(view, fd, owner);
                if (owner.getAttribute("newlyCreated") != null) {
                    owner.setAttribute("RDBMDistributedLayoutStore.PLF", view.layout);
                    this.saveLayout(view, owner);
                }
                this.loadPreferences(view, fd);
                this.fragmentizeLayout(view, fd);
                this.fragmentizeTSUP(view, fd);
                this.fragmentizeSSUP(view, fd);
                this.setUserView(fd.getOwnerId(), view);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("\n\n------ done activating " + fd.getName()));
                }
            }
            catch (Exception e) {
                String msg = "Problem activating DLM fragment '" + fd.getName() + "' no content for this fragment will be included in user layouts.";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msg, (Throwable)e);
                }
                LOG.warn((Object)(msg + " Enable DEBUG logging for the full stack trace."));
            }
        }
    }

    public UserView getUserView(FragmentDefinition fd) {
        UserView rslt;
        if (fd == null) {
            String msg = "Argument 'fd' [FragmentDefinition] cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (!this.hasUserView(fd)) {
            this.activateFragment(fd);
        }
        if ((rslt = this.userViews.get(fd.getOwnerId())) == null) {
            LOG.warn((Object)("No UserView object is present for owner '" + fd.getOwnerId() + "' -- null will be returned"));
        }
        return rslt;
    }

    public void setUserView(String ownerId, UserView v) {
        if (ownerId == null) {
            String msg = "Argument 'ownerId' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (v == null) {
            String msg = "Argument 'v' [UserView] cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting UserView instance for user:  " + ownerId));
        }
        this.userViews.put(ownerId, v);
    }

    public boolean hasUserView(FragmentDefinition fd) {
        if (fd == null) {
            String msg = "Argument 'fd' [FragmentDefinition] cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.userViews.containsKey(fd.getOwnerId());
    }

    private void saveLayout(UserView view, IPerson owner) throws Exception {
        UserProfile profile = new UserProfile();
        profile.setProfileId(view.profileId);
        this.dls.setUserLayout(owner, profile, view.layout, true, false);
    }

    private IPerson bindToOwner(FragmentDefinition fragment) {
        PersonImpl owner = new PersonImpl();
        owner.setAttribute("username", fragment.getOwnerId());
        int userID = -1;
        try {
            userID = this.identityStore.getPortalUID(owner, false);
        }
        catch (AuthorizationException ae) {
            // empty catch block
        }
        if (userID == -1) {
            userID = this.createOwner(owner, fragment);
            owner.setAttribute("newlyCreated", "" + (userID != -1));
        }
        owner.setID(userID);
        return owner;
    }

    private int createOwner(IPerson owner, FragmentDefinition fragment) {
        String defaultUser = null;
        int userID = -1;
        if (fragment.defaultLayoutOwnerID != null) {
            defaultUser = fragment.defaultLayoutOwnerID;
        } else if (this.dls.getProperty("defaultLayoutOwner") != null) {
            defaultUser = this.dls.getProperty("defaultLayoutOwner");
        } else {
            try {
                defaultUser = PropertiesManager.getProperty("org.jasig.portal.services.Authentication.defaultTemplateUserName");
            }
            catch (RuntimeException re) {
                throw new RuntimeException("\n\n WARNING: defaultLayoutOwner is not specified in dlm.xml and no default user is configured for the system. Owner '" + fragment.getOwnerId() + "' for " + "fragment '" + fragment.getName() + "' can not be " + "created. The fragment will not be available for " + "inclusion into user layouts.\n", re);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\n\nOwner '" + fragment.getOwnerId() + "' of fragment '" + fragment.getName() + "' not found. Creating as copy of '" + defaultUser + "'\n"));
        }
        if (defaultUser != null) {
            owner.setAttribute("uPortalTemplateUserName", defaultUser);
        }
        try {
            userID = this.identityStore.getPortalUID(owner, true);
        }
        catch (AuthorizationException ae) {
            throw new RuntimeException("\n\nWARNING: Anomaly occurred while creating owner '" + fragment.getOwnerId() + "' of fragment '" + fragment.getName() + "'. The fragment will not be " + "available for inclusion into user layouts.", ae);
        }
        return userID;
    }

    private void loadLayout(UserView view, FragmentDefinition fragment, IPerson owner) {
        if (view.getUserId() == -1) {
            return;
        }
        Document layout = null;
        try {
            UserProfile profile = this.dls.getUserProfileByFname(owner, "default");
            if (profile.getStructureStylesheetId() == 0 || profile.getThemeStylesheetId() == 0) {
                profile = this.dls.getSystemProfileByFname(profile.getProfileFname());
            }
            view.profileId = profile.getProfileId();
            view.profileFname = profile.getProfileFname();
            view.layoutId = profile.getLayoutId();
            view.structureStylesheetId = profile.getStructureStylesheetId();
            view.themeStylesheetId = profile.getThemeStylesheetId();
            layout = this.dls.getFragmentLayout(owner, profile);
            Element root = layout.getDocumentElement();
            root.setAttribute("ID", "u" + view.getUserId() + "l" + view.layoutId);
            view.layout = layout;
        }
        catch (Exception e) {
            throw new RuntimeException("Anomaly occurred while loading layout for fragment '" + fragment.getName() + "'. The fragment will not be " + "available for inclusion into user layouts.", e);
        }
    }

    private void loadPreferences(UserView view, FragmentDefinition fragment) {
        if (view.getUserId() == -1) {
            return;
        }
        PersonImpl p = new PersonImpl();
        p.setID(view.getUserId());
        p.setAttribute("username", fragment.getOwnerId());
        try {
            view.structUserPrefs = this.dls.getDistributedSSUP(p, view.profileId, view.structureStylesheetId);
            view.themeUserPrefs = this.dls.getDistributedTSUP(p, view.profileId, view.themeStylesheetId);
        }
        catch (Exception e) {
            throw new RuntimeException("Anomaly occurred while loading structure or theme stylesheet user preferences for fragment '" + fragment.getName() + "'. The fragment will not be " + "available for inclusion into user layouts.", e);
        }
    }

    void fragmentizeSSUP(UserView view, FragmentDefinition fragment) {
        Element root = view.layout.getDocumentElement();
        String labelBase = root.getAttribute("ID");
        this.fragmentizeIds(labelBase, view.structUserPrefs, 1);
        this.fragmentizeIds(labelBase, view.structUserPrefs, 0);
    }

    void fragmentizeTSUP(UserView view, FragmentDefinition fragment) {
        Element root = view.layout.getDocumentElement();
        String labelBase = root.getAttribute("ID");
        this.fragmentizeIds(labelBase, view.themeUserPrefs, 0);
    }

    private void fragmentizeIds(String labelBase, DistributedUserPreferences up, int which) {
        Enumeration elements = null;
        elements = which == 0 ? up.getChannels() : up.getFolders();
        Vector list = new Vector();
        while (elements.hasMoreElements()) {
            list.add(elements.nextElement());
        }
        elements = list.elements();
        while (elements.hasMoreElements()) {
            String id = (String)elements.nextElement();
            if (id.startsWith("u")) continue;
            if (which == 0) {
                up.changeChannelId(id, labelBase + id);
                continue;
            }
            up.changeFolderId(id, labelBase + id);
        }
    }

    void fragmentizeLayout(UserView view, FragmentDefinition fragment) {
        if (view.getUserId() == -1 || view.layout == null) {
            return;
        }
        Element layout = view.layout.getDocumentElement();
        Element root = (Element)layout.getFirstChild();
        NodeList children = root.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Element folder;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("folder") || (folder = (Element)node).getAttribute("type").equals("regular") && !folder.getAttribute("hidden").equals("true")) continue;
            try {
                root.removeChild(folder);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Anomaly occurred while stripping out  portions of layout for fragment '" + fragment.getName() + "'. The fragment will not be available for " + "inclusion into user layouts.", e);
            }
        }
        this.setIdsAndAttribs(layout, layout.getAttribute("ID"), "" + fragment.getIndex(), "" + fragment.getPrecedence());
    }

    private void setIdsAndAttribs(Element parent, String labelBase, String index, String precedence) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            String id;
            if (children.item(i).getNodeType() != 1 || (id = (child = (Element)children.item(i)).getAttribute("ID")).equals("")) continue;
            String newId = labelBase + id;
            child.setAttribute("ID", newId);
            child.setIdAttribute("ID", true);
            child.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:fragment", index);
            child.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:precedence", precedence);
            this.setIdsAndAttribs(child, labelBase, index, precedence);
        }
    }
}

