/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.FragmentComparator;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XML;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LegacyConfigurationLoader
implements ConfigurationLoader {
    private Resource configurationFile;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SingletonDoubleCheckedCreator<Boolean> loadedFlag = new SingletonDoubleCheckedCreator<Boolean>(){

        @Override
        protected Boolean createSingleton(Object ... args) {
            LegacyConfigurationLoader.this.loadFragmentInfo();
            return true;
        }
    };
    private List<FragmentDefinition> fragments = null;
    private Properties properties = null;

    public void setConfigurationFile(Resource configurationFile) {
        this.configurationFile = configurationFile;
    }

    protected void loadFragmentInfo() {
        Document doc;
        String configUrl;
        InputStream inputStream;
        try {
            inputStream = this.configurationFile.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not open InputStream to dlm configuration resource " + this.configurationFile, e);
        }
        try {
            configUrl = this.configurationFile.getURL().toExternalForm();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not convert dlm configuration resource to URL " + this.configurationFile, e);
        }
        try {
            doc = DocumentFactory.getDocumentFromStream(inputStream, configUrl);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could load dlm configuration resource " + this.configurationFile, e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Could parse dlm configuration resource " + this.configurationFile, e);
        }
        NodeList propertyNodes = doc.getElementsByTagName("dlm:property");
        this.properties = this.getProperties(propertyNodes);
        NodeList fragmentNodes = doc.getElementsByTagName("dlm:fragment");
        List<FragmentDefinition> localFragments = this.getFragments(fragmentNodes);
        if (localFragments != null) {
            Collections.sort(localFragments, new FragmentComparator());
            if (this.logger.isDebugEnabled()) {
                StringBuilder bfr = new StringBuilder();
                for (FragmentDefinition fragmentDefinition : localFragments) {
                    bfr.append(fragmentDefinition.getName());
                    bfr.append("[");
                    bfr.append(fragmentDefinition.getPrecedence());
                    bfr.append("],\n");
                }
                this.logger.debug((Object)("Fragments Sorted by Precedence and then index {\n" + bfr.toString() + " }"));
            }
            this.fragments = Collections.unmodifiableList(localFragments);
        }
    }

    @Override
    public List<FragmentDefinition> getFragments() {
        this.loadedFlag.get(new Object[0]);
        return this.fragments;
    }

    @Override
    public String getProperty(String propertyName) {
        this.loadedFlag.get(new Object[0]);
        return this.properties.getProperty(propertyName);
    }

    @Override
    public int getPropertyCount() {
        this.loadedFlag.get(new Object[0]);
        return this.properties.size();
    }

    protected Properties getProperties(NodeList props) {
        if (props == null || props.getLength() == 0) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node node = props.item(i);
            NamedNodeMap atts = node.getAttributes();
            Node name = atts.getNamedItem("name");
            Node value = atts.getNamedItem("value");
            if (name == null || name.equals("")) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("\n\n---------- Warning ----------\nThe 'name' attribute of the property element is required and must not be empty in \n'" + XML.serializeNode(node) + "'\nfrom distributed layout managment configuration " + "file \n" + this.configurationFile.toString() + "  \n-----------------------------\n"));
                continue;
            }
            if (value == null) {
                properties.put(name.getNodeValue(), "");
                continue;
            }
            properties.put(name.getNodeValue(), value.getNodeValue());
        }
        return properties;
    }

    protected List<FragmentDefinition> getFragments(NodeList frags) {
        if (frags == null || frags.getLength() == 0) {
            return null;
        }
        int fragmentCount = frags.getLength();
        this.fragments = new ArrayList<FragmentDefinition>(fragmentCount);
        for (int i = 0; i < fragmentCount; ++i) {
            Element fragmentElement = (Element)frags.item(i);
            try {
                FragmentDefinition fragment = new FragmentDefinition(fragmentElement);
                fragment.setIndex(i);
                this.fragments.add(fragment);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("DLM loaded fragment definition '" + fragment.getName() + "' owned by '" + fragment.getOwnerId() + "' with precedence " + fragment.getPrecedence() + (fragment.isNoAudienceIncluded() ? " and no specified audience. It will be editable by '" + fragment.getOwnerId() + "' but " + "not included in any user's layout." : (fragment.isNoAudienceIncluded() ? " with no audience. It will be editable by '" + fragment.getOwnerId() + "' but " + "not included in any user's layout." : " with audiences defined"))));
                continue;
            }
            catch (Exception e) {
                String msg = "Unable to load distributed layout fragment definition. Content from this fragment will not be avilable.";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Unable to load distributed layout fragment definition. Content from this fragment will not be avilable." + XML.serializeNode(fragmentElement)), (Throwable)e);
                    continue;
                }
                this.logger.warn((Object)("Unable to load distributed layout fragment definition. Content from this fragment will not be avilable. Enable DEBUG logging for stack trace.\n\tCaused By: " + e.getMessage() + XML.serializeNode(fragmentElement)));
            }
        }
        return this.fragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logConfigFileInfo() {
        if (this.logger.isInfoEnabled()) {
            InputStream is = null;
            try {
                is = this.configurationFile.getInputStream();
                this.logger.info((Object)("DLM config file: " + this.configurationFile));
            }
            catch (Exception exception) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }
}

