/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.IndexColumn;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.security.IPerson;

@Entity
public class Paren
extends Evaluator {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(Paren.class);
    @Column(name="PAREN_TYPE")
    private Type type = null;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @IndexColumn(name="EVAL_INDEX")
    @JoinTable(name="UP_DLM_EVALUATOR_PAREN", joinColumns={@JoinColumn(name="PAREN_EVAL_ID")}, inverseJoinColumns={@JoinColumn(name="CHILD_EVAL_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<Evaluator> evaluators = new LinkedList<Evaluator>();

    public Paren() {
    }

    public Paren(Type t) {
        this.type = t;
    }

    public void addEvaluator(Evaluator e) {
        this.evaluators.add(e);
    }

    @Override
    public boolean isApplicable(IPerson toPerson) {
        boolean rslt = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" >>>> calling paren[" + this + ", op=" + (Object)((Object)this.type) + "].isApplicable()"));
        }
        block0 : switch (this.type) {
            case OR: {
                rslt = false;
                for (Evaluator v : this.evaluators) {
                    if (!v.isApplicable(toPerson)) continue;
                    rslt = true;
                    break block0;
                }
                break;
            }
            case AND: {
                rslt = true;
                for (Evaluator v : this.evaluators) {
                    if (v.isApplicable(toPerson)) continue;
                    rslt = false;
                    break block0;
                }
                break;
            }
            case NOT: {
                rslt = false;
                for (Evaluator v : this.evaluators) {
                    if (!v.isApplicable(toPerson)) continue;
                    rslt = true;
                    break;
                }
                boolean bl = rslt = !rslt;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" ---- paren[" + this + ", op=" + (Object)((Object)this.type) + "].isApplicable()=" + rslt));
        }
        return rslt;
    }

    @Override
    public void toElement(Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        Element rslt = null;
        if (parent.getName().equals("fragment")) {
            QName q = new QName("audience", FragmentDefinition.NAMESPACE);
            rslt = DocumentHelper.createElement((QName)q);
            rslt.addAttribute("evaluatorFactory", this.getFactoryClass().getName());
        } else {
            rslt = DocumentHelper.createElement((String)"paren");
            rslt.addAttribute("mode", this.type.toString());
        }
        for (Evaluator v : this.evaluators) {
            v.toElement(rslt);
        }
        parent.add(rslt);
    }

    @Override
    public Class<? extends EvaluatorFactory> getFactoryClass() {
        return this.evaluators.get(0).getFactoryClass();
    }

    public static enum Type {
        OR,
        AND,
        NOT;

    }
}

