/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FindEntityController
extends AbstractController {
    private static final Log log = LogFactory.getLog(FindEntityController.class);
    private IGroupListHelper groupListHelper;
    private IPersonManager personManager;

    public FindEntityController() {
        this.setSupportedMethods(new String[]{"POST"});
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPerson person = this.personManager.getPerson(request);
        String entityType = request.getParameter("entityType");
        String entityId = request.getParameter("entityId");
        if (StringUtils.isBlank((String)entityType)) {
            return new ModelAndView("jsonView", "error", (Object)"No entityType specified.");
        }
        if (StringUtils.isBlank((String)entityId)) {
            return new ModelAndView("jsonView", "error", (Object)"No entityId specified.");
        }
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        if (!ap.hasPermission("org.jasig.portal.channels.groupsmanager.CGroupsManager", "VIEW", entityId)) {
            throw new AuthorizationException("User " + person.getUserName() + " does not have view permissions on entity " + entityId);
        }
        JsonEntityBean result = this.groupListHelper.getEntity(entityType, entityId, true);
        return new ModelAndView("jsonView", "result", (Object)result);
    }

    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }
}

