/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.services.GroupService;

public class GroupListHelperImpl
implements IGroupListHelper {
    private static final Log log = LogFactory.getLog(GroupListHelperImpl.class);

    @Override
    public Set<JsonEntityBean> search(String entityType, String searchTerm) {
        Class identifierType;
        EntityIdentifier[] identifiers;
        HashSet<JsonEntityBean> results = new HashSet<JsonEntityBean>();
        EntityEnum entityEnum = EntityEnum.getEntityEnum(entityType);
        if (entityEnum.isGroup()) {
            identifiers = GroupService.searchForGroups(searchTerm, 4, entityEnum.getClazz());
            identifierType = IEntityGroup.class;
        } else {
            identifiers = GroupService.searchForEntities(searchTerm, 4, entityEnum.getClazz());
            identifierType = entityEnum.getClazz();
        }
        for (int i = 0; i < identifiers.length; ++i) {
            JsonEntityBean jsonBean;
            if (!identifiers[i].getType().equals(identifierType)) continue;
            IGroupMember entity = GroupService.getGroupMember(identifiers[i]);
            if (entity instanceof IEntityGroup) {
                jsonBean = new JsonEntityBean((IEntityGroup)entity, this.getEntityType(entity));
                results.add(jsonBean);
                continue;
            }
            jsonBean = new JsonEntityBean(entity, this.getEntityType(entity));
            jsonBean.setName(this.lookupEntityName(jsonBean));
            results.add(jsonBean);
        }
        return results;
    }

    @Override
    public JsonEntityBean getEntity(String entityType, String entityId, boolean populateChildren) {
        EntityEnum entityEnum = EntityEnum.getEntityEnum(entityType);
        if (entityEnum.isGroup()) {
            IEntityGroup entity = GroupService.findGroup(entityId);
            if (entity == null) {
                return null;
            }
            JsonEntityBean jsonBean = new JsonEntityBean(entity, entityEnum.toString());
            if (populateChildren) {
                Iterator members = entity.getMembers();
                jsonBean = this.populateChildren(jsonBean, members);
            }
            return jsonBean;
        }
        IGroupMember entity = GroupService.getGroupMember(entityId, entityEnum.getClazz());
        if (entity == null || entity instanceof IEntityGroup) {
            return null;
        }
        JsonEntityBean jsonBean = new JsonEntityBean(entity, entityEnum.toString());
        jsonBean.setName(this.lookupEntityName(jsonBean));
        return jsonBean;
    }

    private JsonEntityBean populateChildren(JsonEntityBean jsonBean, Iterator<IGroupMember> children) {
        while (children.hasNext()) {
            IGroupMember member = children.next();
            String entityType = this.getEntityType(member);
            EntityEnum entityEnum = EntityEnum.getEntityEnum(entityType);
            JsonEntityBean jsonChild = entityEnum.isGroup() ? new JsonEntityBean((IEntityGroup)member, entityEnum.toString()) : new JsonEntityBean(member, entityEnum.toString());
            if (jsonChild.getName() == null) {
                jsonChild.setName(this.lookupEntityName(jsonChild));
            }
            jsonBean.addChild(jsonChild);
        }
        jsonBean.setChildrenInitialized(true);
        return jsonBean;
    }

    @Override
    public String getEntityType(IGroupMember entity) {
        if (entity.getEntityType().equals(IPerson.class)) {
            if (entity instanceof IEntityGroup) {
                return EntityEnum.GROUP.toString();
            }
            return EntityEnum.PERSON.toString();
        }
        if (entity.getEntityType().equals(IChannelDefinition.class)) {
            if (entity instanceof IEntityGroup) {
                return EntityEnum.CATEGORY.toString();
            }
            return EntityEnum.CHANNEL.toString();
        }
        return null;
    }

    @Override
    public List<JsonEntityBean> getEntityBeans(List<String> params) {
        if (params == null || params.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JsonEntityBean> beans = new ArrayList<JsonEntityBean>();
        for (String param : params) {
            String[] parts = param.split(":");
            JsonEntityBean member = this.getEntity(parts[0], parts[1], false);
            beans.add(member);
        }
        return beans;
    }

    @Override
    public String lookupEntityName(JsonEntityBean entity) {
        EntityEnum entityEnum = EntityEnum.getEntityEnum(entity.getEntityType());
        IEntityNameFinder finder = entityEnum.isGroup() ? EntityNameFinderService.instance().getNameFinder(IEntityGroup.class) : EntityNameFinderService.instance().getNameFinder(entityEnum.getClazz());
        try {
            return finder.getName(entity.getId());
        }
        catch (Exception e) {
            log.warn((Object)("Couldn't find name for entity " + entity.getId()), (Throwable)e);
            return null;
        }
    }
}

