/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.persondir.support;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.services.persondir.support.ICurrentUserProvider;

public class PersonManagerCurrentUserProvider
implements ICurrentUserProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPersonManager personManager;
    private IPortalRequestUtils portalRequestUtils;

    public IPersonManager getPersonManager() {
        return this.personManager;
    }

    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public String getCurrentUserName() {
        HttpServletRequest portalRequest;
        try {
            portalRequest = this.portalRequestUtils.getCurrentPortalRequest();
        }
        catch (IllegalStateException ise) {
            this.logger.warn((Object)"No current portal request available, cannot determine current user name.");
            return null;
        }
        IPerson person = this.personManager.getPerson(portalRequest);
        if (person == null) {
            this.logger.warn((Object)("IPersonManager returned no IPerson for request, cannot determine current user name. " + portalRequest));
            return null;
        }
        return person.getUserName();
    }
}

