/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.lang.Validate;
import org.jasig.portal.tools.versioning.Version;
import org.jasig.portal.tools.versioning.VersionsManager;

public class PortalContextImpl
implements PortalContext {
    private Properties portalProperties = new Properties();
    private Set<PortletMode> portletModes = Collections.emptySet();
    private Set<WindowState> windowStates = Collections.emptySet();

    public Properties getPortalProperties() {
        return this.portalProperties;
    }

    public void setPortalProperties(Properties portalProperties) {
        Validate.notNull((Object)portalProperties, (String)"portalProperties can not be null");
        this.portalProperties = portalProperties;
    }

    public Set<PortletMode> getPortletModes() {
        return this.portletModes;
    }

    public void setPortletModes(Set<PortletMode> portletModes) {
        Validate.notNull(portletModes, (String)"portletModes can not be null");
        this.portletModes = portletModes;
    }

    public Set<WindowState> getWindowStates() {
        return this.windowStates;
    }

    public void setWindowStates(Set<WindowState> windowStates) {
        Validate.notNull(windowStates, (String)"windowStates can not be null");
        this.windowStates = windowStates;
    }

    public String getPortalInfo() {
        VersionsManager versionManager = VersionsManager.getInstance();
        Version version = versionManager.getVersion("UP_FRAMEWORK");
        return "uPortal/" + version.dottedTriple();
    }

    public String getProperty(String name) {
        Validate.notNull((Object)name, (String)"Property name can not be null");
        return this.portalProperties.getProperty(name);
    }

    public Enumeration<String> getPropertyNames() {
        return this.portalProperties.propertyNames();
    }

    public Enumeration<PortletMode> getSupportedPortletModes() {
        return new IteratorEnumeration(this.portletModes.iterator());
    }

    public Enumeration<WindowState> getSupportedWindowStates() {
        return new IteratorEnumeration(this.windowStates.iterator());
    }
}

