/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container;

import javax.servlet.ServletContext;
import org.apache.commons.lang.Validate;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.RequiredContainerServices;
import org.apache.pluto.core.PortletContainerImpl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.web.context.ServletContextAware;

public class PortletContainerFactoryBean
extends AbstractFactoryBean
implements ServletContextAware,
InitializingBean,
DisposableBean {
    private PortletContainerImpl portletContainer;
    private ServletContext servletContext;
    private RequiredContainerServices requiredContainerServices;
    private OptionalContainerServices optionalContainerServices;
    private String portletContainerName = null;

    public String getPortletContainerName() {
        return this.portletContainerName;
    }

    public void setPortletContainerName(String portletContainerName) {
        this.portletContainerName = portletContainerName;
    }

    public RequiredContainerServices getRequiredContainerServices() {
        return this.requiredContainerServices;
    }

    @Required
    public void setRequiredContainerServices(RequiredContainerServices requiredContainerServices) {
        Validate.notNull((Object)requiredContainerServices, (String)"requiredContainerServices can not be null");
        this.requiredContainerServices = requiredContainerServices;
    }

    public OptionalContainerServices getOptionalContainerServices() {
        return this.optionalContainerServices;
    }

    @Required
    public void setOptionalContainerServices(OptionalContainerServices optionalContainerServices) {
        Validate.notNull((Object)optionalContainerServices, (String)"optionalContainerServices can not be null");
        this.optionalContainerServices = optionalContainerServices;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected Object createInstance() throws Exception {
        String containerName = this.getContainerName();
        this.portletContainer = new PortletContainerImpl(containerName, this.requiredContainerServices, this.optionalContainerServices);
        this.portletContainer.init(this.servletContext);
        return this.portletContainer;
    }

    protected void destroyInstance(Object instance) throws Exception {
        ((PortletContainer)instance).destroy();
    }

    public Class<PortletContainer> getObjectType() {
        return PortletContainer.class;
    }

    protected String getContainerName() {
        if (this.portletContainerName != null) {
            return this.portletContainerName;
        }
        return this.servletContext.getContextPath() + "-PlutoPortletContainer";
    }
}

