/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.container.properties.IRequestPropertiesManager;
import org.jasig.portal.portlet.om.IPortletWindow;

public class RequestPropertiesManagerBroker
implements IRequestPropertiesManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<IRequestPropertiesManager> propertiesManagers = Collections.emptyList();

    public List<IRequestPropertiesManager> getPropertiesManagers() {
        return this.propertiesManagers;
    }

    public void setPropertiesManagers(List<IRequestPropertiesManager> propertiesManagers) {
        Validate.notNull(propertiesManagers, (String)"propertiesManagers can not be null");
        this.propertiesManagers = propertiesManagers;
    }

    @Override
    public void addResponseProperty(HttpServletRequest request, IPortletWindow portletWindow, String property, String value) {
        for (IRequestPropertiesManager propertiesManager : this.propertiesManagers) {
            propertiesManager.addResponseProperty(request, portletWindow, property, value);
        }
    }

    @Override
    public void setResponseProperty(HttpServletRequest request, IPortletWindow portletWindow, String property, String value) {
        for (IRequestPropertiesManager propertiesManager : this.propertiesManagers) {
            propertiesManager.setResponseProperty(request, portletWindow, property, value);
        }
    }

    @Override
    public Map<String, String[]> getRequestProperties(HttpServletRequest request, IPortletWindow portletWindow) {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        for (IRequestPropertiesManager propertiesManager : this.propertiesManagers) {
            Map<String, String[]> newProperties = propertiesManager.getRequestProperties(request, portletWindow);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved properties '" + newProperties + "' from manager: " + propertiesManager));
            }
            properties.putAll(newProperties);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning properties '" + properties + "' for portlet " + portletWindow + " and request " + request));
        }
        return properties;
    }
}

