/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.Validate;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.dao.jpa.PortletEntityImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaPortletEntityDao
implements IPortletEntityDao {
    private static final String FIND_PORTLET_ENT_BY_CHAN_SUB_AND_USER = "from PortletEntityImpl portEnt where portEnt.channelSubscribeId = :channelSubscribeId and portEnt.userId = :userId";
    private static final String FIND_PORTLET_ENTS_BY_PORTLET_DEF = "from PortletEntityImpl portEnt where portEnt.portletDefinition = :portletDefinition";
    private static final String FIND_PORTLET_ENTS_BY_USER_ID = "from PortletEntityImpl portEnt where portEnt.userId = :userId";
    private static final String FIND_PORTLET_ENTS_BY_USER_ID_CACHE_REGION = PortletEntityImpl.class.getName() + ".query.FIND_PORTLET_ENTS_BY_USER_ID";
    private static final String FIND_PORTLET_ENTS_BY_PORTLET_DEF_CACHE_REGION = PortletEntityImpl.class.getName() + ".query.FIND_PORTLET_ENTS_BY_PORTLET_DEF";
    private static final String FIND_PORTLET_ENT_BY_CHAN_SUB_AND_USER_CACHE_REGION = PortletEntityImpl.class.getName() + ".query.FIND_PORTLET_ENT_BY_CHAN_SUB_AND_USER";
    private EntityManager entityManager;
    private IPortletDefinitionDao portletDefinitionDao;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public IPortletDefinitionDao getPortletDefinitionDao() {
        return this.portletDefinitionDao;
    }

    @Required
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        this.portletDefinitionDao = portletDefinitionDao;
    }

    @Override
    @Transactional
    public IPortletEntity createPortletEntity(IPortletDefinitionId portletDefinitionId, String channelSubscribeId, int userId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId can not be null");
        Validate.notNull((Object)channelSubscribeId, (String)"channelSubscribeId can not be null");
        IPortletDefinition portletDefinition = this.portletDefinitionDao.getPortletDefinition(portletDefinitionId);
        if (portletDefinition == null) {
            throw new DataRetrievalFailureException("No IPortletDefinition exists for IPortletDefinitionId='" + portletDefinitionId + "'");
        }
        PortletEntityImpl portletEntity = new PortletEntityImpl(portletDefinition, channelSubscribeId, userId);
        this.entityManager.persist((Object)portletEntity);
        return portletEntity;
    }

    @Override
    @Transactional
    public void deletePortletEntity(IPortletEntity portletEntity) {
        Validate.notNull((Object)portletEntity, (String)"portletEntity can not be null");
        IPortletEntity persistentPortletEntity = this.entityManager.contains((Object)portletEntity) ? portletEntity : (IPortletEntity)this.entityManager.merge((Object)portletEntity);
        this.entityManager.remove((Object)persistentPortletEntity);
    }

    @Override
    public IPortletEntity getPortletEntity(IPortletEntityId portletEntityId) {
        Validate.notNull((Object)portletEntityId, (String)"portletEntity can not be null");
        long internalPortletEntityId = Long.parseLong(portletEntityId.getStringId());
        PortletEntityImpl portletEntity = (PortletEntityImpl)this.entityManager.find(PortletEntityImpl.class, (Object)internalPortletEntityId);
        return portletEntity;
    }

    @Override
    public IPortletEntity getPortletEntity(String channelSubscribeId, int userId) {
        Validate.notNull((Object)channelSubscribeId, (String)"portletEntity can not be null");
        Query query = this.entityManager.createQuery(FIND_PORTLET_ENT_BY_CHAN_SUB_AND_USER);
        query.setParameter("channelSubscribeId", (Object)channelSubscribeId);
        query.setParameter("userId", (Object)userId);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_PORTLET_ENT_BY_CHAN_SUB_AND_USER_CACHE_REGION);
        query.setMaxResults(1);
        List portletEntities = query.getResultList();
        IPortletEntity portletEntity = (IPortletEntity)DataAccessUtils.uniqueResult((Collection)portletEntities);
        return portletEntity;
    }

    @Override
    public Set<IPortletEntity> getPortletEntities(IPortletDefinitionId portletDefinitionId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletEntity can not be null");
        IPortletDefinition portletDefinition = this.portletDefinitionDao.getPortletDefinition(portletDefinitionId);
        Query query = this.entityManager.createQuery(FIND_PORTLET_ENTS_BY_PORTLET_DEF);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_PORTLET_ENTS_BY_PORTLET_DEF_CACHE_REGION);
        query.setParameter("portletDefinition", (Object)portletDefinition);
        List portletEntities = query.getResultList();
        return new HashSet<IPortletEntity>(portletEntities);
    }

    @Override
    public Set<IPortletEntity> getPortletEntitiesForUser(int userId) {
        Query query = this.entityManager.createQuery(FIND_PORTLET_ENTS_BY_USER_ID);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_PORTLET_ENTS_BY_USER_ID_CACHE_REGION);
        query.setParameter("userId", (Object)userId);
        List portletEntities = query.getResultList();
        return new HashSet<IPortletEntity>(portletEntities);
    }

    @Override
    @Transactional
    public void updatePortletEntity(IPortletEntity portletEntity) {
        Validate.notNull((Object)portletEntity, (String)"portletEntity can not be null");
        this.entityManager.persist((Object)portletEntity);
    }
}

