/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.pluto.descriptors.portlet.PortletPreferenceDD;
import org.apache.pluto.internal.InternalPortletPreference;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.jasig.portal.portlet.om.IPortletPreference;

@Entity
@Table(name="UP_PORTLET_PREF")
@GenericGenerator(name="UP_PORTLET_PREF_GEN", strategy="native", parameters={@Parameter(name="sequence", value="UP_PORTLET_PREF_SEQ"), @Parameter(name="table", value="UP_JPA_UNIQUE_KEY"), @Parameter(name="column", value="NEXT_UP_PORTLET_PREF_HI")})
public class PortletPreferenceImpl
implements IPortletPreference {
    @Id
    @GeneratedValue(generator="UP_PORTLET_PREF_GEN")
    @Column(name="PORTLET_PREF_ID")
    private final long portletPreferenceId;
    @Column(name="NAME", nullable=false)
    @Type(type="nullSafeText")
    private String name = null;
    @Column(name="READ_ONLY", nullable=false)
    private boolean readOnly = false;
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="UP_PORTLET_PREF_VALUES", joinColumns={@JoinColumn(name="PORTLET_PREF_ID")})
    @IndexColumn(name="VALUE_ORDER")
    @Type(type="nullSafeText")
    @Column(name="VALUE")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    private List<String> values = null;

    public PortletPreferenceImpl() {
        this.portletPreferenceId = -1L;
    }

    public PortletPreferenceImpl(InternalPortletPreference portletPreference) {
        this.portletPreferenceId = -1L;
        this.name = portletPreference.getName();
        this.readOnly = portletPreference.isReadOnly();
        this.setValues(portletPreference.getValues());
    }

    public PortletPreferenceImpl(PortletPreferenceDD portletPreference) {
        this.portletPreferenceId = -1L;
        this.name = portletPreference.getName();
        this.readOnly = portletPreference.isReadOnly();
        List values = portletPreference.getValues();
        if (values != null) {
            this.setValues(values.toArray(new String[values.size()]));
        }
    }

    public PortletPreferenceImpl(String name, boolean readOnly, String ... values) {
        this.portletPreferenceId = -1L;
        this.name = name;
        this.readOnly = readOnly;
        this.setValues(values);
    }

    public String getName() {
        return this.name;
    }

    public String[] getValues() {
        if (this.values == null) {
            return null;
        }
        return this.values.toArray(new String[this.values.size()]);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setValues(String[] values) {
        if (values == null) {
            this.values = null;
        } else if (this.values == null) {
            this.values = new ArrayList<String>(Arrays.asList(values));
        } else {
            this.values.clear();
            this.values.addAll(Arrays.asList(values));
        }
    }

    public Object clone() {
        return new PortletPreferenceImpl(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPortletPreference)) {
            return false;
        }
        IPortletPreference rhs = (IPortletPreference)object;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.getName()).append(this.readOnly, rhs.isReadOnly()).append((Object[])this.getValues(), (Object[])rhs.getValues()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-1904185833, -1222355625).append((Object)this.name).append(this.readOnly).append(this.values).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("portletPreferenceId", this.portletPreferenceId).append("name", (Object)this.name).append("readOnly", this.readOnly).append("values", this.values).toString();
    }
}

