/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreferences;
import org.jasig.portal.portlet.registry.PortletEntityIdImpl;

class PersistentPortletEntityWrapper
implements IPortletEntity {
    private final IPortletEntity persistentEntity;
    private final IPortletEntityId standardEntityId;

    public PersistentPortletEntityWrapper(IPortletEntity persistentEntity) {
        this.persistentEntity = persistentEntity;
        this.standardEntityId = new PortletEntityIdImpl(this.persistentEntity.getPortletDefinitionId(), this.persistentEntity.getChannelSubscribeId(), this.persistentEntity.getUserId());
    }

    public IPortletEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public IPortletEntityId getPortletEntityId() {
        return this.standardEntityId;
    }

    @Override
    public IPortletDefinitionId getPortletDefinitionId() {
        return this.persistentEntity.getPortletDefinitionId();
    }

    @Override
    public String getChannelSubscribeId() {
        return this.persistentEntity.getChannelSubscribeId();
    }

    @Override
    public int getUserId() {
        return this.persistentEntity.getUserId();
    }

    @Override
    public IPortletPreferences getPortletPreferences() {
        return this.persistentEntity.getPortletPreferences();
    }

    @Override
    public void setPortletPreferences(IPortletPreferences portletPreferences) {
        this.persistentEntity.setPortletPreferences(portletPreferences);
    }

    public int hashCode() {
        return this.standardEntityId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentPortletEntityWrapper other = (PersistentPortletEntityWrapper)obj;
        return !(this.persistentEntity == null ? other.persistentEntity != null : !this.persistentEntity.equals(other.persistentEntity));
    }

    public String toString() {
        return "PersistentPortletEntityWrapper [standardEntityId=" + this.standardEntityId + ", persistentEntity=" + this.persistentEntity + "]";
    }
}

