/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import javax.servlet.ServletContext;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.spi.optional.PortletRegistryService;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.utils.Tuple;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.web.context.ServletContextAware;

public class PortletDefinitionRegistryImpl
implements IPortletDefinitionRegistry,
ServletContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IChannelRegistryStore channelRegistryStore;
    private IPortletDefinitionDao portletDefinitionDao;
    private OptionalContainerServices optionalContainerServices;
    private ServletContext servletContext;

    public IPortletDefinitionDao getPortletDefinitionDao() {
        return this.portletDefinitionDao;
    }

    @Required
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        Validate.notNull((Object)portletDefinitionDao);
        this.portletDefinitionDao = portletDefinitionDao;
    }

    public OptionalContainerServices getOptionalContainerServices() {
        return this.optionalContainerServices;
    }

    @Required
    public void setOptionalContainerServices(OptionalContainerServices optionalContainerServices) {
        Validate.notNull((Object)optionalContainerServices);
        this.optionalContainerServices = optionalContainerServices;
    }

    public IChannelRegistryStore getChannelRegistryStore() {
        return this.channelRegistryStore;
    }

    @Required
    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        Validate.notNull((Object)channelRegistryStore);
        this.channelRegistryStore = channelRegistryStore;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public IPortletDefinition createPortletDefinition(int channelPublishId) {
        return this.portletDefinitionDao.getPortletDefinition(channelPublishId);
    }

    @Override
    public IPortletDefinition getPortletDefinition(int channelPublishId) {
        return this.portletDefinitionDao.getPortletDefinition(channelPublishId);
    }

    @Override
    public IPortletDefinition getOrCreatePortletDefinition(int channelPublishId) {
        IPortletDefinition portletDefinition = this.getPortletDefinition(channelPublishId);
        if (portletDefinition != null) {
            return portletDefinition;
        }
        return this.createPortletDefinition(channelPublishId);
    }

    @Override
    public IPortletDefinition getPortletDefinition(IPortletDefinitionId portletDefinitionId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId can not be null");
        return this.portletDefinitionDao.getPortletDefinition(portletDefinitionId);
    }

    @Override
    public void updatePortletDefinition(IPortletDefinition portletDefinition) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition can not be null");
        this.portletDefinitionDao.updatePortletDefinition(portletDefinition);
    }

    @Override
    public PortletAppDD getParentPortletApplicationDescriptor(IPortletDefinitionId portletDefinitionId) throws PortletContainerException {
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletDefinitionId);
        if (portletDefinition == null) {
            return null;
        }
        Tuple<String, String> portletDescriptorKeys = this.getPortletDescriptorKeys(portletDefinition);
        PortletRegistryService portletRegistryService = this.optionalContainerServices.getPortletRegistryService();
        return portletRegistryService.getPortletApplicationDescriptor((String)portletDescriptorKeys.first);
    }

    @Override
    public PortletDD getParentPortletDescriptor(IPortletDefinitionId portletDefinitionId) throws PortletContainerException {
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletDefinitionId);
        if (portletDefinition == null) {
            return null;
        }
        Tuple<String, String> portletDescriptorKeys = this.getPortletDescriptorKeys(portletDefinition);
        PortletRegistryService portletRegistryService = this.optionalContainerServices.getPortletRegistryService();
        return portletRegistryService.getPortletDescriptor((String)portletDescriptorKeys.first, (String)portletDescriptorKeys.second);
    }

    @Override
    public Tuple<String, String> getPortletDescriptorKeys(IPortletDefinition portletDefinition) {
        String portletApplicationId;
        IChannelDefinition channelDefinition = portletDefinition.getChannelDefinition();
        IChannelParameter isFrameworkPortletParam = channelDefinition.getParameter("isFrameworkPortlet");
        if (isFrameworkPortletParam != null && Boolean.valueOf(isFrameworkPortletParam.getValue()).booleanValue()) {
            portletApplicationId = this.servletContext.getContextPath();
        } else {
            IChannelParameter portletApplicaitonIdParam = channelDefinition.getParameter("portletApplicationId");
            if (portletApplicaitonIdParam == null) {
                throw new DataRetrievalFailureException("The specified ChannelDefinition does not provide the needed channel parameter 'portletApplicationId'. ChannelDefinition=" + channelDefinition);
            }
            portletApplicationId = portletApplicaitonIdParam.getValue();
        }
        IChannelParameter portletNameParam = channelDefinition.getParameter("portletName");
        if (portletNameParam == null) {
            throw new DataRetrievalFailureException("The specified ChannelDefinition does not provide the needed channel parameter 'portletName'. ChannelDefinition=" + channelDefinition);
        }
        String portletName = portletNameParam.getValue();
        return new Tuple<String, String>(portletApplicationId, portletName);
    }
}

