/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletPreferences;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.InterimPortletEntityImpl;
import org.jasig.portal.portlet.registry.PersistentPortletEntityWrapper;
import org.jasig.portal.portlet.registry.PortletEntityIdImpl;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.util.WebUtils;

public class PortletEntityRegistryImpl
implements IPortletEntityRegistry {
    public static final String INTERIM_PORTLET_ENTITY_MAP_ATTRIBUTE = PortletEntityRegistryImpl.class.getName() + ".INTERIM_PORTLET_ENTITY_MAP";
    public static final String PORTLET_ENTITY_ID_MAP_ATTRIBUTE = PortletEntityRegistryImpl.class.getName() + ".PORTLET_ENTITY_ID_MAP";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletEntityDao portletEntityDao;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;

    public IPortletEntityDao getPortletEntityDao() {
        return this.portletEntityDao;
    }

    @Required
    public void setPortletEntityDao(IPortletEntityDao portletEntityDao) {
        this.portletEntityDao = portletEntityDao;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Override
    public IPortletEntity createPortletEntity(IPortletDefinitionId portletDefinitionId, String channelSubscribeId, int userId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId can not be null");
        Validate.notNull((Object)channelSubscribeId, (String)"channelSubscribeId can not be null");
        InterimPortletEntityImpl interimPortletEntity = new InterimPortletEntityImpl(portletDefinitionId, channelSubscribeId, userId);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Created InterimPortletEntity " + interimPortletEntity.getPortletEntityId() + " for def=" + portletDefinitionId + ", sub=" + channelSubscribeId + ", usr=" + userId));
        }
        this.storeInterimPortletEntity(interimPortletEntity);
        return interimPortletEntity;
    }

    @Override
    public IPortletEntity getPortletEntity(IPortletEntityId portletEntityId) {
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        InterimPortletEntityImpl interimPortletEntity = this.getInterimPortletEntity(portletEntityId);
        if (interimPortletEntity != null) {
            return interimPortletEntity;
        }
        IPortletEntityId persistentEntityId = this.getPersistentId(portletEntityId);
        if (persistentEntityId == null) {
            return null;
        }
        IPortletEntity persistentPortletEntity = this.portletEntityDao.getPortletEntity(persistentEntityId);
        if (persistentPortletEntity == null) {
            return null;
        }
        return new PersistentPortletEntityWrapper(persistentPortletEntity);
    }

    @Override
    public IPortletEntity getPortletEntity(String portletEntityIdString) {
        Validate.notNull((Object)portletEntityIdString, (String)"portletEntityId can not be null");
        return this.getPortletEntity(new PortletEntityIdImpl(portletEntityIdString));
    }

    @Override
    public IPortletEntity getPortletEntity(String channelSubscribeId, int userId) {
        Validate.notNull((Object)channelSubscribeId, (String)"channelSubscribeId can not be null");
        InterimPortletEntityImpl interimPortletEntity = this.getInterimPortletEntity(channelSubscribeId, userId);
        if (interimPortletEntity != null) {
            return interimPortletEntity;
        }
        IPortletEntity persistentPortletEntity = this.portletEntityDao.getPortletEntity(channelSubscribeId, userId);
        if (persistentPortletEntity == null) {
            return null;
        }
        PersistentPortletEntityWrapper wrappedPortletEntity = new PersistentPortletEntityWrapper(persistentPortletEntity);
        this.setPersistentIdMapping(wrappedPortletEntity.getPortletEntityId(), persistentPortletEntity.getPortletEntityId());
        return wrappedPortletEntity;
    }

    @Override
    public Set<IPortletEntity> getPortletEntitiesForUser(int userId) {
        Set<IPortletEntity> persistentPortletEntities = this.portletEntityDao.getPortletEntitiesForUser(userId);
        LinkedHashSet<IPortletEntity> wrappedPortletEntities = new LinkedHashSet<IPortletEntity>();
        for (IPortletEntity persistentPortletEntity : persistentPortletEntities) {
            PersistentPortletEntityWrapper wrappedPortletEntity = new PersistentPortletEntityWrapper(persistentPortletEntity);
            this.setPersistentIdMapping(wrappedPortletEntity.getPortletEntityId(), persistentPortletEntity.getPortletEntityId());
            wrappedPortletEntities.add(wrappedPortletEntity);
        }
        Set<InterimPortletEntityImpl> interimPortletEntities = this.getInterimPortletEntities(userId);
        if (interimPortletEntities != null) {
            wrappedPortletEntities.addAll(interimPortletEntities);
        }
        return wrappedPortletEntities;
    }

    @Override
    public IPortletEntity getOrCreatePortletEntity(IPortletDefinitionId portletDefinitionId, String channelSubscribeId, int userId) {
        IPortletEntity portletEntity = this.getPortletEntity(channelSubscribeId, userId);
        if (portletEntity != null) {
            if (!portletDefinitionId.equals(portletEntity.getPortletDefinitionId())) {
                this.logger.warn((Object)("Found portlet entity '" + portletEntity + "' is not the correct entity for portlet definition id: " + portletDefinitionId + ". The entity will be deleted and a new one created."));
                this.deletePortletEntity(portletEntity);
            } else {
                return portletEntity;
            }
        }
        return this.createPortletEntity(portletDefinitionId, channelSubscribeId, userId);
    }

    @Override
    public void storePortletEntity(IPortletEntity portletEntity) {
        Validate.notNull((Object)portletEntity, (String)"portletEntity can not be null");
        IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
        IPortletPreferences portletPreferences = portletEntity.getPortletPreferences();
        List<IPortletPreference> preferences = portletPreferences.getPortletPreferences();
        if (portletEntity instanceof PersistentPortletEntityWrapper) {
            portletEntity = ((PersistentPortletEntityWrapper)portletEntity).getPersistentEntity();
            if (preferences.size() > 0) {
                this.portletEntityDao.updatePortletEntity(portletEntity);
            } else {
                this.portletEntityDao.deletePortletEntity(portletEntity);
                this.removePersistentId(portletEntityId);
                IPortletDefinitionId portletDefinitionId = portletEntity.getPortletDefinitionId();
                String channelSubscribeId = portletEntity.getChannelSubscribeId();
                int userId = portletEntity.getUserId();
                IPortletEntity interimPortletEntity = this.createPortletEntity(portletDefinitionId, channelSubscribeId, userId);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Persistent portlet entity " + portletEntityId + " no longer has preferences. Deleted it and created InterimPortletEntity " + interimPortletEntity.getPortletEntityId()));
                }
            }
        } else if (preferences.size() > 0) {
            IPortletDefinitionId portletDefinitionId = portletEntity.getPortletDefinitionId();
            String channelSubscribeId = portletEntity.getChannelSubscribeId();
            int userId = portletEntity.getUserId();
            IPortletEntity persistantEntity = this.portletEntityDao.createPortletEntity(portletDefinitionId, channelSubscribeId, userId);
            persistantEntity.setPortletPreferences(portletPreferences);
            this.portletEntityDao.updatePortletEntity(persistantEntity);
            this.removeInterimPortletEntity(portletEntityId);
            this.setPersistentIdMapping(portletEntityId, persistantEntity.getPortletEntityId());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("InterimPortletEntity " + portletEntityId + " now has preferences. Deleted it and created persistent portlet entity " + persistantEntity.getPortletEntityId()));
            }
        }
    }

    @Override
    public void deletePortletEntity(IPortletEntity portletEntity) {
        Validate.notNull((Object)portletEntity, (String)"portletEntity can not be null");
        if (portletEntity instanceof PersistentPortletEntityWrapper) {
            portletEntity = ((PersistentPortletEntityWrapper)portletEntity).getPersistentEntity();
            this.portletEntityDao.deletePortletEntity(portletEntity);
            this.removePersistentId(portletEntity.getPortletEntityId());
        } else {
            this.removeInterimPortletEntity(portletEntity.getPortletEntityId());
        }
    }

    @Override
    public IPortletDefinition getParentPortletDefinition(IPortletEntityId portletEntityId) {
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        IPortletEntity portletEntity = this.getPortletEntity(portletEntityId);
        IPortletDefinitionId portletDefinitionId = portletEntity.getPortletDefinitionId();
        return this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPersistentIdMapping(IPortletEntityId wrapperId, IPortletEntityId persistentId) {
        ConcurrentHashMap<IPortletEntityId, IPortletEntityId> idMapping;
        HttpSession session = this.getSession();
        if (session == null) {
            return;
        }
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            idMapping = (ConcurrentHashMap<IPortletEntityId, IPortletEntityId>)session.getAttribute(PORTLET_ENTITY_ID_MAP_ATTRIBUTE);
            if (idMapping == null) {
                idMapping = new ConcurrentHashMap<IPortletEntityId, IPortletEntityId>();
                session.setAttribute(PORTLET_ENTITY_ID_MAP_ATTRIBUTE, idMapping);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Mapping wraper ID " + wrapperId + " to persistent ID " + persistentId));
        }
        idMapping.put(wrapperId, persistentId);
    }

    protected IPortletEntityId getPersistentId(IPortletEntityId wrapperId) {
        Map<IPortletEntityId, IPortletEntityId> idMapping = this.getPersistentIdMap();
        if (idMapping == null) {
            return null;
        }
        return idMapping.get(wrapperId);
    }

    protected void removePersistentId(IPortletEntityId wrapperId) {
        Map<IPortletEntityId, IPortletEntityId> idMapping = this.getPersistentIdMap();
        if (idMapping == null) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Removed persistent ID for wraper ID " + wrapperId));
        }
        idMapping.remove(wrapperId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<IPortletEntityId, IPortletEntityId> getPersistentIdMap() {
        HttpSession session = this.getSession();
        if (session == null) {
            return null;
        }
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            return (Map)session.getAttribute(PORTLET_ENTITY_ID_MAP_ATTRIBUTE);
        }
    }

    protected void removeInterimPortletEntity(IPortletEntityId portletEntityId) {
        InterimPortletEntityCache entityCache = this.getInterimPortletEntityCache();
        if (entityCache == null) {
            return;
        }
        entityCache.removeEntity(portletEntityId);
    }

    protected InterimPortletEntityImpl getInterimPortletEntity(IPortletEntityId portletEntityId) {
        InterimPortletEntityCache entityCache = this.getInterimPortletEntityCache();
        if (entityCache == null) {
            return null;
        }
        return entityCache.getEntity(portletEntityId);
    }

    protected InterimPortletEntityImpl getInterimPortletEntity(String channelSubscribeId, int userId) {
        InterimPortletEntityCache entityCache = this.getInterimPortletEntityCache();
        if (entityCache == null) {
            return null;
        }
        return entityCache.getEntity(channelSubscribeId, userId);
    }

    protected Set<InterimPortletEntityImpl> getInterimPortletEntities(int userId) {
        InterimPortletEntityCache entityCache = this.getInterimPortletEntityCache();
        if (entityCache == null) {
            return null;
        }
        return entityCache.getEntities(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeInterimPortletEntity(InterimPortletEntityImpl interimPortletEntity) {
        InterimPortletEntityCache entityCache;
        HttpSession session = this.getSession();
        if (session == null) {
            return;
        }
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            entityCache = (InterimPortletEntityCache)session.getAttribute(INTERIM_PORTLET_ENTITY_MAP_ATTRIBUTE);
            if (entityCache == null) {
                entityCache = new InterimPortletEntityCache();
                session.setAttribute(INTERIM_PORTLET_ENTITY_MAP_ATTRIBUTE, (Object)entityCache);
            }
        }
        entityCache.storeEntity(interimPortletEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InterimPortletEntityCache getInterimPortletEntityCache() {
        HttpSession session = this.getSession();
        if (session == null) {
            return null;
        }
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            return (InterimPortletEntityCache)session.getAttribute(INTERIM_PORTLET_ENTITY_MAP_ATTRIBUTE);
        }
    }

    protected HttpSession getSession() {
        HttpServletRequest request;
        try {
            request = this.portalRequestUtils.getCurrentPortalRequest();
        }
        catch (IllegalStateException e) {
            return null;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("A HttpSession must already exist for the PortletEntityRegistryImpl to function");
        }
        return session;
    }

    private static final class InterimPortletEntityCache {
        private final ReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
        private final Map<SubscribeKey, InterimPortletEntityImpl> entitiesBySubscribeKey = new HashMap<SubscribeKey, InterimPortletEntityImpl>();
        private final Map<IPortletEntityId, InterimPortletEntityImpl> entitiesById = new HashMap<IPortletEntityId, InterimPortletEntityImpl>();

        private InterimPortletEntityCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeEntity(InterimPortletEntityImpl interimPortletEntity) {
            this.cacheLock.writeLock().lock();
            try {
                SubscribeKey subscribeKey = new SubscribeKey(interimPortletEntity.getUserId(), interimPortletEntity.getChannelSubscribeId());
                this.entitiesBySubscribeKey.put(subscribeKey, interimPortletEntity);
                this.entitiesById.put(interimPortletEntity.getPortletEntityId(), interimPortletEntity);
            }
            finally {
                this.cacheLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InterimPortletEntityImpl getEntity(String channelSubscribeId, int userId) {
            this.cacheLock.readLock().lock();
            try {
                SubscribeKey subscribeKey = new SubscribeKey(userId, channelSubscribeId);
                InterimPortletEntityImpl interimPortletEntityImpl = this.entitiesBySubscribeKey.get(subscribeKey);
                return interimPortletEntityImpl;
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<InterimPortletEntityImpl> getEntities(int userId) {
            LinkedHashSet<InterimPortletEntityImpl> entities = new LinkedHashSet<InterimPortletEntityImpl>();
            this.cacheLock.readLock().lock();
            try {
                for (InterimPortletEntityImpl interimPortletEntity : this.entitiesById.values()) {
                    if (userId != interimPortletEntity.getUserId()) continue;
                    entities.add(interimPortletEntity);
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
            return entities;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InterimPortletEntityImpl getEntity(IPortletEntityId portletEntityId) {
            this.cacheLock.readLock().lock();
            try {
                InterimPortletEntityImpl interimPortletEntityImpl = this.entitiesById.get(portletEntityId);
                return interimPortletEntityImpl;
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEntity(IPortletEntityId portletEntityId) {
            this.cacheLock.writeLock().lock();
            try {
                InterimPortletEntityImpl interimPortletEntity = this.entitiesById.remove(portletEntityId);
                if (interimPortletEntity != null) {
                    SubscribeKey subscribeKey = new SubscribeKey(interimPortletEntity.getUserId(), interimPortletEntity.getChannelSubscribeId());
                    this.entitiesBySubscribeKey.remove(subscribeKey);
                }
            }
            finally {
                this.cacheLock.writeLock().unlock();
            }
        }

        private static final class SubscribeKey {
            private final int userId;
            private final String channelSubscribeId;

            public SubscribeKey(int userId, String channelSubscribeId) {
                this.userId = userId;
                this.channelSubscribeId = channelSubscribeId;
            }

            public String toString() {
                return "[userId=" + this.userId + ", channelSubscribeId=" + this.channelSubscribeId + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.channelSubscribeId == null ? 0 : this.channelSubscribeId.hashCode());
                result = 31 * result + this.userId;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SubscribeKey other = (SubscribeKey)obj;
                if (this.channelSubscribeId == null ? other.channelSubscribeId != null : !this.channelSubscribeId.equals(other.channelSubscribeId)) {
                    return false;
                }
                return this.userId == other.userId;
            }
        }
    }
}

