/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.pluto.PortletWindowID;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;

class PortletWindowImpl
implements IPortletWindow {
    private static final long serialVersionUID = 1L;
    private final IPortletEntityId portletEntityId;
    private final IPortletWindowId portletWindowId;
    private final String contextPath;
    private final String portletName;
    private final IPortletWindowId delegationParent;
    private Map<String, List<String>> requestParameters = new HashMap<String, List<String>>();
    private transient PortletMode portletMode = PortletMode.VIEW;
    private transient WindowState windowState = WindowState.NORMAL;
    private Integer expirationCache = null;

    public PortletWindowImpl(IPortletWindowId portletWindowId, IPortletEntityId portletEntityId, String contextPath, String portletName, IPortletWindowId delegationParent) {
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        Validate.notNull((Object)contextPath, (String)"contextPath can not be null");
        Validate.notNull((Object)portletName, (String)"portletName can not be null");
        this.portletWindowId = portletWindowId;
        this.portletEntityId = portletEntityId;
        this.contextPath = contextPath;
        this.portletName = portletName;
        this.delegationParent = delegationParent;
    }

    public PortletWindowImpl(IPortletWindowId portletWindowId, IPortletEntityId portletEntityId, String contextPath, String portletName) {
        this(portletWindowId, portletEntityId, contextPath, portletName, null);
    }

    public PortletWindowImpl(IPortletWindowId portletWindowId, IPortletWindow portletWindow) {
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        Validate.notNull((Object)portletWindow, (String)"portletWindow can not be null");
        this.portletWindowId = portletWindowId;
        this.portletEntityId = portletWindow.getPortletEntityId();
        this.contextPath = portletWindow.getContextPath();
        this.portletName = portletWindow.getPortletName();
        this.portletMode = portletWindow.getPortletMode();
        this.windowState = portletWindow.getWindowState();
        this.delegationParent = portletWindow.getDelegationParent();
        Validate.notNull((Object)this.portletEntityId, (String)"portletWindow.parentPortletEntityId can not be null");
        Validate.notNull((Object)this.contextPath, (String)"portletWindow.contextPath can not be null");
        Validate.notNull((Object)this.portletName, (String)"portletWindow.portletName can not be null");
        Validate.notNull((Object)this.portletMode, (String)"portletWindow.portletMode can not be null");
        Validate.notNull((Object)this.windowState, (String)"portletWindow.windowState can not be null");
        Validate.notNull((Object)this.delegationParent, (String)"portletWindow.delegationParent can not be null");
    }

    public PortletWindowID getId() {
        return this.portletWindowId;
    }

    @Override
    public IPortletWindowId getPortletWindowId() {
        return this.portletWindowId;
    }

    @Override
    public IPortletEntityId getPortletEntityId() {
        return this.portletEntityId;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    @Override
    public void setPortletMode(PortletMode mode) {
        Validate.notNull((Object)mode, (String)"mode can not be null");
        this.portletMode = mode;
    }

    @Override
    public void setWindowState(WindowState state) {
        Validate.notNull((Object)state, (String)"state can not be null");
        this.windowState = state;
    }

    @Override
    public Map<String, List<String>> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public void setRequestParameters(Map<String, List<String>> requestParameters) {
        this.requestParameters = requestParameters;
    }

    @Override
    public Integer getExpirationCache() {
        return this.expirationCache;
    }

    @Override
    public void setExpirationCache(Integer expirationCache) {
        this.expirationCache = expirationCache;
    }

    @Override
    public IPortletWindowId getDelegationParent() {
        return this.delegationParent;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.portletMode.toString());
        oos.writeObject(this.windowState.toString());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.portletWindowId == null) {
            throw new InvalidObjectException("portletWindowId can not be null");
        }
        if (this.contextPath == null) {
            throw new InvalidObjectException("contextPath can not be null");
        }
        if (this.portletName == null) {
            throw new InvalidObjectException("portletName can not be null");
        }
        String portletModeStr = (String)ois.readObject();
        if (portletModeStr == null) {
            throw new InvalidObjectException("portletMode can not be null");
        }
        this.portletMode = new PortletMode(portletModeStr);
        String windowStateStr = (String)ois.readObject();
        if (windowStateStr == null) {
            throw new InvalidObjectException("windowState can not be null");
        }
        this.windowState = new WindowState(windowStateStr);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPortletWindow)) {
            return false;
        }
        IPortletWindow rhs = (IPortletWindow)object;
        return new EqualsBuilder().append((Object)this.portletWindowId, (Object)rhs.getId()).append((Object)this.contextPath, (Object)rhs.getContextPath()).append((Object)this.portletName, (Object)rhs.getPortletName()).append((Object)this.windowState, (Object)rhs.getWindowState()).append((Object)this.portletMode, (Object)rhs.getPortletMode()).append((Object)this.expirationCache, (Object)rhs.getExpirationCache()).append(this.requestParameters, rhs.getRequestParameters()).append((Object)this.delegationParent, (Object)rhs.getDelegationParent()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(1445247369, -1009176817).append((Object)this.portletWindowId).append((Object)this.contextPath).append((Object)this.portletName).append((Object)this.windowState).append((Object)this.portletMode).append((Object)this.expirationCache).append(this.requestParameters).append((Object)this.delegationParent).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("portletWindowId", (Object)this.portletWindowId).append("contextPath", (Object)this.contextPath).append("portletName", (Object)this.portletName).append("windowState", (Object)this.windowState).append("portletMode", (Object)this.portletMode).append("expirationCache", (Object)this.expirationCache).append("requestParameters", this.requestParameters).append("delegationParent", (Object)this.delegationParent).toString();
    }
}

