/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.WindowState;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.PortletWindowID;
import org.apache.pluto.internal.InternalPortletWindow;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.registry.PortletWindowIdImpl;
import org.jasig.portal.portlet.registry.PortletWindowImpl;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.util.WebUtils;

public class PortletWindowRegistryImpl
implements IPortletWindowRegistry {
    public static final String TRANSIENT_WINDOW_ID_PREFIX = "tp.";
    public static final String TRANSIENT_PORTLET_WINDOW_MAP_ATTRIBUTE = PortletWindowRegistryImpl.class.getName() + ".TRANSIENT_PORTLET_WINDOW_MAP";
    public static final String PORTLET_WINDOW_MAP_ATTRIBUTE = PortletWindowRegistryImpl.class.getName() + ".PORTLET_WINDOW_MAP";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IUserInstanceManager userInstanceManager;

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Required
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        Validate.notNull((Object)userInstanceManager);
        this.userInstanceManager = userInstanceManager;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        Validate.notNull((Object)portletEntityRegistry);
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        Validate.notNull((Object)portletDefinitionRegistry);
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Override
    public IPortletWindow convertPortletWindow(HttpServletRequest request, PortletWindow plutoPortletWindow) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)plutoPortletWindow, (String)"portletWindow can not be null");
        if (plutoPortletWindow instanceof InternalPortletWindow) {
            plutoPortletWindow = ((InternalPortletWindow)plutoPortletWindow).getOriginalPortletWindow();
        }
        if (plutoPortletWindow instanceof IPortletWindow) {
            return (IPortletWindow)plutoPortletWindow;
        }
        PortletWindowID plutoPortletWindowId = plutoPortletWindow.getId();
        IPortletWindowId portletWindowId = plutoPortletWindowId instanceof IPortletWindowId ? (IPortletWindowId)plutoPortletWindowId : this.getPortletWindowId(plutoPortletWindowId.getStringId());
        IPortletWindow portletWindow = this.getPortletWindow(request, portletWindowId);
        if (portletWindow == null) {
            throw new IllegalArgumentException("Could not cast Pluto PortletWindow to uPortal IPortletWindow and no IPortletWindow exists with the id: " + plutoPortletWindow.getId());
        }
        return portletWindow;
    }

    @Override
    public IPortletWindow createPortletWindow(HttpServletRequest request, String windowInstanceId, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)windowInstanceId, (String)"windowInstanceId can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        IPortletWindowId portletWindowId = this.createPortletWindowId(windowInstanceId, portletEntityId);
        IPortletWindow portletWindow = this.createPortletWindow(request, portletWindowId, portletEntityId);
        this.storePortletWindow(request, portletWindow);
        return portletWindow;
    }

    @Override
    public IPortletWindow getOrCreatePortletWindow(HttpServletRequest request, String windowInstanceId, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)windowInstanceId, (String)"windowInstanceId can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        IPortletWindow portletWindow = this.getPortletWindow(request, windowInstanceId, portletEntityId);
        if (portletWindow == null) {
            portletWindow = this.createPortletWindow(request, windowInstanceId, portletEntityId);
        }
        return portletWindow;
    }

    @Override
    public IPortletWindow getPortletWindow(HttpServletRequest request, IPortletWindowId portletWindowId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        if (this.isTransient(request, portletWindowId)) {
            String portletWindowIdString = portletWindowId.getStringId();
            String portletEntityIdString = portletWindowIdString.substring(TRANSIENT_WINDOW_ID_PREFIX.length());
            IPortletEntityRegistry portletEntityRegistry = this.getPortletEntityRegistry();
            IPortletEntity portletEntity = portletEntityRegistry.getPortletEntity(portletEntityIdString);
            return this.getTransientPortletWindow(request, portletWindowIdString, portletEntity.getPortletEntityId());
        }
        ConcurrentMap<IPortletWindowId, IPortletWindow> portletWindowMap = this.getPortletWindowMap(request);
        if (portletWindowMap == null) {
            return null;
        }
        return (IPortletWindow)portletWindowMap.get(portletWindowId);
    }

    @Override
    public IPortletWindow getPortletWindow(HttpServletRequest request, String windowInstanceId, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)windowInstanceId, (String)"windowInstanceId can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        if (windowInstanceId.startsWith(TRANSIENT_WINDOW_ID_PREFIX)) {
            return this.getTransientPortletWindow(request, windowInstanceId, portletEntityId);
        }
        IPortletWindowId portletWindowId = this.createPortletWindowId(windowInstanceId, portletEntityId);
        return this.getPortletWindow(request, portletWindowId);
    }

    @Override
    public IPortletWindowId getPortletWindowId(String portletWindowId) {
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        return new PortletWindowIdImpl(portletWindowId);
    }

    @Override
    public IPortletWindowId getDefaultPortletWindowId(IPortletEntityId portletEntityId) {
        IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(portletEntityId);
        String channelSubscribeId = portletEntity.getChannelSubscribeId();
        return this.createPortletWindowId(channelSubscribeId, portletEntityId);
    }

    @Override
    public IPortletEntity getParentPortletEntity(HttpServletRequest request, IPortletWindowId portletWindowId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        IPortletWindow portletWindow = this.getPortletWindow(request, portletWindowId);
        if (portletWindow == null) {
            return null;
        }
        IPortletEntityId parentPortletEntityId = portletWindow.getPortletEntityId();
        IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(parentPortletEntityId);
        return portletEntity;
    }

    @Override
    public IPortletWindow createDefaultPortletWindow(HttpServletRequest request, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        IPortletWindowId portletWindowId = this.getDefaultPortletWindowId(portletEntityId);
        IPortletWindow portletWindow = this.createPortletWindow(request, portletWindowId, portletEntityId);
        this.storePortletWindow(request, portletWindow);
        return portletWindow;
    }

    @Override
    public IPortletWindow getOrCreateDefaultPortletWindow(HttpServletRequest request, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        IPortletWindowId portletWindowId = this.getDefaultPortletWindowId(portletEntityId);
        IPortletWindow portletWindow = this.getPortletWindow(request, portletWindowId);
        if (portletWindow == null) {
            portletWindow = this.createDefaultPortletWindow(request, portletEntityId);
        }
        return portletWindow;
    }

    @Override
    public IPortletWindow createDelegatePortletWindow(HttpServletRequest request, IPortletEntityId portletEntityId, IPortletWindowId delegationParentId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        Validate.notNull((Object)delegationParentId, (String)"delegationParentId can not be null");
        IPortletWindowId portletWindowId = this.getDefaultPortletWindowId(portletEntityId);
        IPortletWindow portletWindow = this.createPortletWindow(request, portletWindowId, portletEntityId, delegationParentId);
        this.storePortletWindow(request, portletWindow);
        return portletWindow;
    }

    @Override
    public IPortletWindow getOrCreateDelegatePortletWindow(HttpServletRequest request, IPortletWindowId portletWindowId, IPortletEntityId portletEntityId, IPortletWindowId delegationParentId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        Validate.notNull((Object)delegationParentId, (String)"delegationParentId can not be null");
        IPortletWindow portletWindow = this.getPortletWindow(request, portletWindowId);
        if (!(portletWindow == null || portletWindow.getDelegationParent() != null && portletWindow.getDelegationParent().equals(delegationParentId))) {
            throw new IllegalArgumentException("Delegation parent '" + delegationParentId + "' is not set as the parent for the existing portle window '" + portletWindow + "'");
        }
        if (portletWindow == null) {
            portletWindow = this.createDelegatePortletWindow(request, portletEntityId, delegationParentId);
        }
        return portletWindow;
    }

    @Override
    public IPortletWindowId createTransientPortletWindowId(HttpServletRequest request, IPortletWindowId sourcePortletWindowId) {
        IPortletWindow sourcePortletWindow = this.getPortletWindow(request, sourcePortletWindowId);
        if (sourcePortletWindow == null) {
            throw new IllegalArgumentException("No IPortletWindow exists for id: " + sourcePortletWindowId);
        }
        IPortletEntityId portletEntityId = sourcePortletWindow.getPortletEntityId();
        return new PortletWindowIdImpl(TRANSIENT_WINDOW_ID_PREFIX + portletEntityId.getStringId());
    }

    @Override
    public boolean isTransient(HttpServletRequest request, IPortletWindowId portletWindowId) {
        String windowInstanceId = portletWindowId.getStringId();
        return windowInstanceId.startsWith(TRANSIENT_WINDOW_ID_PREFIX);
    }

    protected IPortletWindow createPortletWindow(HttpServletRequest request, IPortletWindowId portletWindowId, IPortletEntityId portletEntityId) {
        return this.createPortletWindow(request, portletWindowId, portletEntityId, null);
    }

    protected IPortletWindow createPortletWindow(HttpServletRequest request, IPortletWindowId portletWindowId, IPortletEntityId portletEntityId, IPortletWindowId delegateParent) {
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntityId);
        Tuple<String, String> portletDescriptorKeys = this.portletDefinitionRegistry.getPortletDescriptorKeys(portletDefinition);
        String portletApplicationId = (String)portletDescriptorKeys.first;
        String portletName = (String)portletDescriptorKeys.second;
        PortletWindowImpl portletWindow = delegateParent == null ? new PortletWindowImpl(portletWindowId, portletEntityId, portletApplicationId, portletName) : new PortletWindowImpl(portletWindowId, portletEntityId, portletApplicationId, portletName, delegateParent);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Created PortletWindow " + portletWindow.getId() + " for PortletEntity " + portletEntityId));
        }
        this.initializePortletWindow(request, portletEntityId, portletWindow);
        return portletWindow;
    }

    protected void initializePortletWindow(HttpServletRequest request, IPortletEntityId portletEntityId, PortletWindowImpl portletWindow) {
        IPortletEntity portletEntity;
        String channelSubscribeId;
        if (this.isTransient(request, portletWindow.getPortletWindowId())) {
            return;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        UserPreferences userPreferences = preferencesManager.getUserPreferences();
        ThemeStylesheetUserPreferences themeStylesheetUserPreferences = userPreferences.getThemeStylesheetUserPreferences();
        String minimized = themeStylesheetUserPreferences.getChannelAttributeValue(channelSubscribeId = (portletEntity = this.portletEntityRegistry.getPortletEntity(portletEntityId)).getChannelSubscribeId(), "minimized");
        if (Boolean.parseBoolean(minimized)) {
            portletWindow.setWindowState(WindowState.MINIMIZED);
        }
    }

    protected IPortletWindowId createPortletWindowId(String windowInstanceId, IPortletEntityId portletEntityId) {
        return new PortletWindowIdImpl(portletEntityId.getStringId() + "." + windowInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentMap<IPortletWindowId, IPortletWindow> getPortletWindowMap(HttpServletRequest request) {
        ConcurrentMap portletWindows;
        HttpSession session = this.getSession(request);
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            portletWindows = (ConcurrentMap)session.getAttribute(PORTLET_WINDOW_MAP_ATTRIBUTE);
        }
        return portletWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storePortletWindow(HttpServletRequest request, IPortletWindow portletWindow) {
        ConcurrentHashMap<IPortletWindowId, IPortletWindow> portletWindows;
        HttpSession session = this.getSession(request);
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            portletWindows = (ConcurrentHashMap<IPortletWindowId, IPortletWindow>)session.getAttribute(PORTLET_WINDOW_MAP_ATTRIBUTE);
            if (portletWindows == null) {
                portletWindows = new ConcurrentHashMap<IPortletWindowId, IPortletWindow>();
                session.setAttribute(PORTLET_WINDOW_MAP_ATTRIBUTE, portletWindows);
            }
        }
        portletWindows.put(portletWindow.getPortletWindowId(), portletWindow);
    }

    protected HttpSession getSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("A HttpSession must already exist for the PortletWindowRegistryImpl to function");
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPortletWindow getTransientPortletWindow(HttpServletRequest request, String windowInstanceId, IPortletEntityId portletEntityId) {
        IPortletWindow transientPortletWindow;
        HashMap<IPortletEntityId, IPortletWindow> transientPortletWindowMap;
        Object object = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
        synchronized (object) {
            transientPortletWindowMap = (HashMap<IPortletEntityId, IPortletWindow>)request.getAttribute(TRANSIENT_PORTLET_WINDOW_MAP_ATTRIBUTE);
            if (transientPortletWindowMap == null) {
                transientPortletWindowMap = new HashMap<IPortletEntityId, IPortletWindow>();
                request.setAttribute(TRANSIENT_PORTLET_WINDOW_MAP_ATTRIBUTE, transientPortletWindowMap);
            }
        }
        HashMap<IPortletEntityId, IPortletWindow> hashMap = transientPortletWindowMap;
        synchronized (hashMap) {
            transientPortletWindow = (IPortletWindow)transientPortletWindowMap.get(portletEntityId);
            if (transientPortletWindow == null) {
                PortletWindowIdImpl portletWindowId = new PortletWindowIdImpl(windowInstanceId);
                transientPortletWindow = this.createPortletWindow(request, portletWindowId, portletEntityId);
                transientPortletWindow.setWindowState(WindowState.NORMAL);
                transientPortletWindowMap.put(portletEntityId, transientPortletWindow);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created new transient portlet window and cached it as a request attribute: " + transientPortletWindow));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using cached transient portlet window: " + transientPortletWindow));
            }
        }
        return transientPortletWindow;
    }
}

