/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.url;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.url.IPortletRequestParameterManager;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.processing.RequestParameterProcessingIncompleteException;
import org.jasig.portal.url.support.ChannelRequestParameterManager;
import org.springframework.beans.factory.annotation.Required;

public class PortletRequestParameterManager
implements IPortletRequestParameterManager {
    protected static final String NO_PORTLET_URL_ATTRIBUTE = ChannelRequestParameterManager.class.getName() + ".NO_PORTLET_URL";
    protected static final String TARGETED_PORTLET_URL_ATTRIBUTE = ChannelRequestParameterManager.class.getName() + ".TARGETED_PORTLET_URL";
    protected static final String PORTLET_URL_MAP_ATTRIBUTE = ChannelRequestParameterManager.class.getName() + ".PORTLET_URL_MAP    ";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortalRequestUtils portalRequestUtils;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    @Override
    public IPortletWindowId getTargetedPortletWindowId(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"request can not be null");
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        PortletUrl portletUrl = this.getAndCheckRequestInfoMap(request);
        if (portletUrl == null) {
            return null;
        }
        return portletUrl.getTargetWindowId();
    }

    @Override
    public PortletUrl getPortletRequestInfo(HttpServletRequest request, IPortletWindowId portletWindowId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        this.getAndCheckRequestInfoMap(request);
        Map portletUrlMap = (Map)request.getAttribute(PORTLET_URL_MAP_ATTRIBUTE);
        if (portletUrlMap == null) {
            return null;
        }
        return (PortletUrl)portletUrlMap.get(portletWindowId);
    }

    @Override
    public void setTargetedPortletUrl(HttpServletRequest request, PortletUrl portletUrl) {
        Validate.notNull((Object)request, (String)"request can not be null");
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        PortletUrl existingPortletUrl = (PortletUrl)request.getAttribute(TARGETED_PORTLET_URL_ATTRIBUTE);
        if (existingPortletUrl != null) {
            throw new IllegalStateException("Portlet request info can only be set once per request");
        }
        if (portletUrl != null) {
            request.setAttribute(TARGETED_PORTLET_URL_ATTRIBUTE, (Object)portletUrl);
            this.setAdditionalPortletUrl(request, portletUrl);
        } else {
            request.setAttribute(NO_PORTLET_URL_ATTRIBUTE, (Object)NO_PORTLET_URL_ATTRIBUTE);
        }
    }

    @Override
    public void setAdditionalPortletUrl(HttpServletRequest request, PortletUrl portletUrl) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletUrl, (String)"portletUrl can not be null");
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        ConcurrentHashMap<IPortletWindowId, PortletUrl> portletUrlMap = (ConcurrentHashMap<IPortletWindowId, PortletUrl>)request.getAttribute(PORTLET_URL_MAP_ATTRIBUTE);
        if (portletUrlMap == null) {
            portletUrlMap = new ConcurrentHashMap<IPortletWindowId, PortletUrl>();
            request.setAttribute(PORTLET_URL_MAP_ATTRIBUTE, portletUrlMap);
        }
        do {
            portletUrlMap.put(portletUrl.getTargetWindowId(), portletUrl);
        } while ((portletUrl = portletUrl.getDelegatePortletUrl()) != null);
    }

    protected PortletUrl getAndCheckRequestInfoMap(HttpServletRequest request) {
        PortletUrl portletUrl = (PortletUrl)request.getAttribute(TARGETED_PORTLET_URL_ATTRIBUTE);
        if (portletUrl == null && request.getAttribute(NO_PORTLET_URL_ATTRIBUTE) == null) {
            throw new RequestParameterProcessingIncompleteException("No portlet parameter processing has been completed on this request");
        }
        return portletUrl;
    }
}

