/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.lookup;

import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlets.Attribute;
import org.jasig.portal.portlets.lookup.IPersonLookupHelper;
import org.jasig.portal.portlets.lookup.PersonQuery;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.webflow.context.ExternalContext;

public class PersonLookupHelperImpl
implements IPersonLookupHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPersonAttributeDao personAttributeDao;

    public IPersonAttributeDao getPersonAttributeDao() {
        return this.personAttributeDao;
    }

    public void setPersonAttributeDao(IPersonAttributeDao personLookupDao) {
        this.personAttributeDao = personLookupDao;
    }

    @Override
    public Set<String> getQueryAttributes(ExternalContext externalContext) {
        AbstractSet queryAttributes;
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] configuredAttributes = preferences.getValues("person-lookup.personLookup.queryAttributes", null);
        String[] excludedAttributes = preferences.getValues("person-lookup.personLookup.queryAttributes.exclude", null);
        if (configuredAttributes != null) {
            queryAttributes = new LinkedHashSet<String>(Arrays.asList(configuredAttributes));
        } else {
            Set availableAttributes = this.personAttributeDao.getAvailableQueryAttributes();
            queryAttributes = new TreeSet(availableAttributes);
        }
        if (excludedAttributes != null) {
            for (String excludedAttribute : excludedAttributes) {
                queryAttributes.remove(excludedAttribute);
            }
        }
        return queryAttributes;
    }

    @Override
    public Map<String, IPersonAttributes> doPersonQuery(ExternalContext externalContext, PersonQuery query) {
        Map<String, Attribute> attributes = query.getAttributes();
        HashMap<String, String> queryAttributes = new HashMap<String, String>();
        for (Map.Entry<String, Attribute> attrEntry : attributes.entrySet()) {
            queryAttributes.put(attrEntry.getKey(), attrEntry.getValue().getValue());
        }
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] configuredAttributes = preferences.getValues("person-lookup.personDetails.detailsAttributes", null);
        String[] excludedAttributes = preferences.getValues("person-lookup.personDetails.detailsAttributes.exclude", null);
        LinkedHashSet<String> allowedAttributes = new LinkedHashSet<String>();
        if (configuredAttributes != null) {
            allowedAttributes.addAll(Arrays.asList(configuredAttributes));
        } else {
            allowedAttributes.addAll(attributes.keySet());
        }
        if (excludedAttributes != null) {
            allowedAttributes.removeAll(Arrays.asList(excludedAttributes));
        }
        Iterator attributeItr = queryAttributes.keySet().iterator();
        while (attributeItr.hasNext()) {
            String attribute = (String)attributeItr.next();
            if (allowedAttributes.contains(attribute)) continue;
            attributeItr.remove();
            this.logger.warn((Object)("User '" + externalContext.getCurrentUser() + "' attempted searching on attribute '" + attribute + "' which is not allowed in the current configuration. The attribute will be ignored."));
        }
        Set people = this.personAttributeDao.getPeople(queryAttributes);
        if (people == null) {
            return null;
        }
        TreeMap<String, IPersonAttributes> sortedPeople = new TreeMap<String, IPersonAttributes>();
        for (IPersonAttributes personAttributes : people) {
            sortedPeople.put(personAttributes.getName(), personAttributes);
        }
        return sortedPeople;
    }

    @Override
    public Map<IPersonAttributes, String> getQueryDisplayResults(ExternalContext externalContext, Collection<IPersonAttributes> queryResults) {
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] resultsAttributes = preferences.getValues("person-lookup.personSearchResults.resultsAttributes", null);
        String resultsMessage = preferences.getValue("person-lookup.personSearchResults.resultsMessage", null);
        LinkedHashMap<IPersonAttributes, String> displayResults = new LinkedHashMap<IPersonAttributes, String>();
        if (resultsAttributes == null || resultsMessage == null) {
            for (IPersonAttributes personAttributes : queryResults) {
                String name = personAttributes.getName();
                displayResults.put(personAttributes, name);
            }
        } else {
            for (IPersonAttributes personAttributes : queryResults) {
                Object[] resultValues = new Object[resultsAttributes.length];
                for (int index = 0; index < resultsAttributes.length; ++index) {
                    Object attributeValue = personAttributes.getAttributeValue(resultsAttributes[index]);
                    resultValues[index] = attributeValue != null ? attributeValue : "";
                }
                String displayResult = MessageFormat.format(resultsMessage, resultValues);
                displayResults.put(personAttributes, displayResult);
            }
        }
        return displayResults;
    }

    @Override
    public Set<String> getDisplayAttributes(ExternalContext externalContext, IPersonAttributes person) {
        LinkedHashSet<String> displayAttributes;
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] configuredAttributes = preferences.getValues("person-lookup.personDetails.detailsAttributes", null);
        String[] excludedAttributes = preferences.getValues("person-lookup.personDetails.detailsAttributes.exclude", null);
        Map attributes = person.getAttributes();
        if (configuredAttributes != null) {
            displayAttributes = new LinkedHashSet();
            for (String configuredAttribute : configuredAttributes) {
                if (!attributes.containsKey(configuredAttribute)) continue;
                displayAttributes.add(configuredAttribute);
            }
        } else {
            displayAttributes = new TreeSet(attributes.keySet());
        }
        if (excludedAttributes != null) {
            for (String excludedAttribute : excludedAttributes) {
                displayAttributes.remove(excludedAttribute);
            }
        }
        return displayAttributes;
    }
}

