/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.portletadmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.common.DisplayNameDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.SupportsDD;
import org.apache.pluto.internal.impl.PortletContextImpl;
import org.apache.pluto.spi.optional.PortletRegistryService;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.api.portlet.DelegateState;
import org.jasig.portal.api.portlet.DelegationActionResponse;
import org.jasig.portal.api.portlet.PortletDelegationDispatcher;
import org.jasig.portal.api.portlet.PortletDelegationLocator;
import org.jasig.portal.channel.ChannelLifecycleState;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelPublishingService;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.channels.portlet.CSpringPortletAdaptor;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletPreferences;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.portlets.Attribute;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.portlets.portletadmin.ChannelDefinitionForm;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDParameter;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDPreference;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDStep;
import org.jasig.portal.portlets.portletadmin.xmlsupport.ChannelPublishingDefinition;
import org.jasig.portal.portlets.portletadmin.xmlsupport.IChannelPublishingDefinitionDao;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.ComparableExtractingComparator;
import org.jasig.portal.utils.Tuple;
import org.springframework.web.context.ServletContextAware;
import org.springframework.webflow.context.ExternalContext;

public class PortletAdministrationHelper
implements ServletContextAware {
    protected final Log logger = LogFactory.getLog(PortletAdministrationHelper.class);
    private IGroupListHelper groupListHelper;
    private IChannelRegistryStore channelRegistryStore;
    private OptionalContainerServices optionalContainerServices;
    private IChannelPublishingService channelPublishingService;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private PortletDelegationLocator portletDelegationLocator;
    private IChannelPublishingDefinitionDao channelPublishingDefinitionDao;
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setPortletDelegationLocator(PortletDelegationLocator portletDelegationLocator) {
        this.portletDelegationLocator = portletDelegationLocator;
    }

    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        this.channelRegistryStore = channelRegistryStore;
    }

    public void setOptionalContainerServices(OptionalContainerServices optionalContainerServices) {
        this.optionalContainerServices = optionalContainerServices;
    }

    public void setChannelPublishingService(IChannelPublishingService channelPublishingService) {
        this.channelPublishingService = channelPublishingService;
    }

    public void setChannelPublishingDefinitionDao(IChannelPublishingDefinitionDao channelPublishingDefinitionDao) {
        this.channelPublishingDefinitionDao = channelPublishingDefinitionDao;
    }

    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public ChannelDefinitionForm getChannelDefinitionForm(int chanId) {
        ChannelDefinitionForm form;
        IChannelDefinition def = this.channelRegistryStore.getChannelDefinition(chanId);
        if (def != null) {
            IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(def.getId());
            form = new ChannelDefinitionForm(def, portletDefinition);
            form.setId(def.getId());
        } else {
            form = new ChannelDefinitionForm();
        }
        if (def != null) {
            ChannelCategory[] categories;
            for (ChannelCategory cat : categories = this.channelRegistryStore.getParentCategories(def)) {
                form.addCategory(new JsonEntityBean(cat));
            }
            try {
                IPermissionManager pm = AuthorizationService.instance().newPermissionManager("UP_FRAMEWORK");
                IAuthorizationPrincipal[] prins = pm.getAuthorizedPrincipals("SUBSCRIBE", "CHAN_ID." + String.valueOf(form.getId()));
                for (int mp = 0; mp < prins.length; ++mp) {
                    JsonEntityBean bean;
                    IEntityGroup group = GroupService.findGroup(prins[mp].getKey());
                    if (group != null) {
                        bean = new JsonEntityBean(group, EntityEnum.GROUP.toString());
                    } else {
                        IGroupMember member = AuthorizationService.instance().getGroupMember(prins[mp]);
                        bean = new JsonEntityBean(member, EntityEnum.PERSON.toString());
                        String name = this.groupListHelper.lookupEntityName(bean);
                        bean.setName(name);
                    }
                    form.addGroup(bean);
                }
            }
            catch (GroupsException e) {
                e.printStackTrace();
            }
        } else {
            IEntityGroup channelCategoriesGroup = GroupService.getDistinguishedGroup(GroupService.CHANNEL_CATEGORIES);
            form.addCategory(new JsonEntityBean(channelCategoriesGroup, this.groupListHelper.getEntityType(channelCategoriesGroup)));
            IEntityGroup everyoneGroup = GroupService.getDistinguishedGroup(GroupService.EVERYONE);
            form.addGroup(new JsonEntityBean(everyoneGroup, this.groupListHelper.getEntityType(everyoneGroup)));
        }
        return form;
    }

    public ChannelDefinitionForm savePortletRegistration(ChannelDefinitionForm form, IPerson publisher) throws Exception {
        IChannelType channelType;
        IGroupMember[] groupMembers = new IGroupMember[form.getGroups().size()];
        for (int i = 0; i < groupMembers.length; ++i) {
            JsonEntityBean bean = form.getGroups().get(i);
            EntityEnum entityEnum = EntityEnum.getEntityEnum(bean.getEntityType());
            groupMembers[i] = entityEnum.isGroup() ? GroupService.findGroup(bean.getId()) : GroupService.getGroupMember(bean.getId(), entityEnum.getClazz());
        }
        ChannelCategory[] categories = new ChannelCategory[form.getCategories().size()];
        ListIterator<JsonEntityBean> iter = form.getCategories().listIterator();
        while (iter.hasNext()) {
            String id = iter.next().getId();
            String iCatID = id.startsWith("cat") ? id.substring(3) : id;
            categories[iter.previousIndex()] = this.channelRegistryStore.getChannelCategory(iCatID);
        }
        IChannelDefinition channelDef = this.channelRegistryStore.getChannelDefinition(form.getId());
        if (channelDef == null) {
            String fname = form.getFname();
            String clazz = form.getJavaClass();
            String name = form.getName();
            String title = form.getTitle();
            int typeId = form.getTypeId();
            channelDef = this.channelRegistryStore.newChannelDefinition(typeId, fname, clazz, name, title);
        }
        channelDef.setDescription(form.getDescription());
        channelDef.setEditable(form.isEditable());
        channelDef.setFName(form.getFname());
        channelDef.setHasAbout(form.isHasAbout());
        channelDef.setHasHelp(form.isHasHelp());
        channelDef.setIsSecure(form.isSecure());
        channelDef.setJavaClass(form.getJavaClass());
        channelDef.setName(form.getName());
        channelDef.setTimeout(form.getTimeout());
        channelDef.setTitle(form.getTitle());
        Date now = new Date();
        int order = form.getLifecycleState().getOrder();
        if (form.getId() < 0) {
            if (order >= ChannelLifecycleState.APPROVED.getOrder()) {
                channelDef.setApproverId(publisher.getID());
                channelDef.setApprovalDate(now);
            }
            if (order >= ChannelLifecycleState.PUBLISHED.getOrder()) {
                channelDef.setPublisherId(publisher.getID());
                if (channelDef.getPublishDate() == null) {
                    channelDef.setPublishDate(now);
                }
            } else if (form.getPublishDate() != null) {
                channelDef.setPublishDate(form.getPublishDateTime());
                channelDef.setPublisherId(publisher.getID());
            }
            if (order >= ChannelLifecycleState.EXPIRED.getOrder()) {
                channelDef.setExpirerId(publisher.getID());
                if (channelDef.getExpirationDate() == null) {
                    channelDef.setExpirationDate(now);
                }
            } else if (form.getExpirationDate() != null) {
                channelDef.setExpirationDate(form.getExpirationDateTime());
                channelDef.setExpirerId(publisher.getID());
            }
        } else {
            if (order >= ChannelLifecycleState.APPROVED.getOrder()) {
                if (channelDef.getApproverId() < 0) {
                    channelDef.setApproverId(publisher.getID());
                }
                if (channelDef.getApprovalDate() == null) {
                    channelDef.setApprovalDate(now);
                }
            } else {
                channelDef.setApprovalDate(null);
                channelDef.setApproverId(-1);
            }
            if (order >= ChannelLifecycleState.PUBLISHED.getOrder()) {
                if (channelDef.getPublisherId() < 0) {
                    channelDef.setPublisherId(publisher.getID());
                }
                if (channelDef.getPublishDate() == null) {
                    channelDef.setPublishDate(now);
                }
            } else if (form.getPublishDate() != null) {
                channelDef.setPublishDate(form.getPublishDate());
                if (channelDef.getPublisherId() < 0) {
                    channelDef.setPublisherId(publisher.getID());
                }
            } else {
                channelDef.setPublishDate(null);
                channelDef.setPublisherId(-1);
            }
            if (order >= ChannelLifecycleState.EXPIRED.getOrder()) {
                if (channelDef.getExpirerId() < 0) {
                    channelDef.setExpirerId(publisher.getID());
                }
                if (channelDef.getExpirationDate() == null) {
                    channelDef.setExpirationDate(now);
                }
            } else if (form.getExpirationDate() != null) {
                channelDef.setExpirationDate(form.getExpirationDate());
                if (channelDef.getExpirerId() < 0) {
                    channelDef.setExpirerId(publisher.getID());
                }
            } else {
                channelDef.setExpirationDate(null);
                channelDef.setExpirerId(-1);
            }
        }
        if ((channelType = this.channelRegistryStore.getChannelType(form.getTypeId())) == null) {
            throw new IllegalArgumentException("No IChannelType exists for ID " + form.getTypeId());
        }
        channelDef.setType(channelType);
        ArrayList<IPortletPreference> preferenceList = new ArrayList<IPortletPreference>();
        for (String key : form.getParameters().keySet()) {
            String value = form.getParameters().get(key).getValue();
            if (StringUtils.isBlank((String)value)) continue;
            boolean override = false;
            if (form.getParameterOverrides().containsKey(key)) {
                override = form.getParameterOverrides().get(key).getValue();
            }
            if (key.startsWith("PORTLET.")) {
                preferenceList.add(new PortletPreferenceImpl(key, !override, value));
                continue;
            }
            channelDef.addParameter(key, value, override);
        }
        for (String key : form.getPortletPreferences().keySet()) {
            List<String> prefValues = form.getPortletPreferences().get(key).getValue();
            if (prefValues == null || prefValues.size() <= 0) continue;
            String[] values = prefValues.toArray(new String[prefValues.size()]);
            boolean readOnly = true;
            if (form.getPortletPreferencesOverrides().containsKey(key)) {
                readOnly = !form.getPortletPreferencesOverrides().get(key).getValue();
            }
            preferenceList.add(new PortletPreferenceImpl(key, readOnly, values));
        }
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(channelDef.getId());
        IPortletPreferences portletPreferences = portletDefinition.getPortletPreferences();
        portletPreferences.setPortletPreferences(preferenceList);
        this.channelPublishingService.saveChannelDefinition(channelDef, publisher, categories, groupMembers);
        return this.getChannelDefinitionForm(channelDef.getId());
    }

    public void removePortletRegistration(int channelId, IPerson person) {
        IChannelDefinition channelDef = this.channelRegistryStore.getChannelDefinition(channelId);
        this.channelPublishingService.removeChannelDefinition(channelDef, person);
    }

    public Set<String> getArbitraryPortletPreferenceNames(ChannelDefinitionForm form) {
        ChannelPublishingDefinition cpd = this.channelPublishingDefinitionDao.getChannelPublishingDefinition(form.getTypeId());
        HashSet<String> currentPrefs = new HashSet<String>();
        currentPrefs.addAll(form.getPortletPreferences().keySet());
        for (CPDStep step : cpd.getParams().getSteps()) {
            if (step.getPreferences() != null) {
                for (CPDPreference pref : step.getPreferences()) {
                    currentPrefs.remove(pref.getName());
                }
            }
            if (step.getParameters() == null) continue;
            for (CPDParameter param : step.getParameters()) {
                if (!param.getName().startsWith("PORTLET.")) continue;
                currentPrefs.remove(param.getName().replace("PORTLET.", ""));
            }
        }
        return currentPrefs;
    }

    public boolean supportsConfigMode(ChannelDefinitionForm form) {
        PortletDD portletDescriptor;
        if (!form.isPortlet()) {
            return false;
        }
        Tuple<String, String> portletDescriptorKeys = this.getPortletDescriptorKeys(form);
        if (portletDescriptorKeys == null) {
            return false;
        }
        String portletAppId = (String)portletDescriptorKeys.first;
        String portletName = (String)portletDescriptorKeys.second;
        PortletRegistryService portletRegistryService = this.optionalContainerServices.getPortletRegistryService();
        try {
            portletDescriptor = portletRegistryService.getPortletDescriptor(portletAppId, portletName);
        }
        catch (PortletContainerException e) {
            this.logger.warn((Object)("Failed to load portlet descriptor for appId='" + portletAppId + "', portletName='" + portletName + "'"), (Throwable)e);
            return false;
        }
        if (portletDescriptor == null) {
            return false;
        }
        List supports = portletDescriptor.getSupports();
        for (SupportsDD support : supports) {
            List portletModes = support.getPortletModes();
            for (String portletMode : portletModes) {
                if (!IPortletAdaptor.CONFIG.equals((Object)new PortletMode(portletMode))) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanOptions(ChannelDefinitionForm form, PortletRequest request) {
        HashSet<String> preferenceNames = new HashSet<String>();
        HashSet<String> parameterNames = new HashSet<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.startsWith("portletPreferences[")) {
                preferenceNames.add(name.split("'")[1]);
                continue;
            }
            if (!name.startsWith("parameters[")) continue;
            parameterNames.add(name.split("'")[1]);
        }
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(form.getPortletPreferences().keySet());
        for (String key : keys) {
            if (!preferenceNames.contains(key)) {
                form.getPortletPreferences().remove(key);
                form.getPortletPreferencesOverrides().remove(key);
                continue;
            }
            if (form.getPortletPreferences().get(key) == null) {
                form.getPortletPreferences().remove(key);
                form.getPortletPreferencesOverrides().remove(key);
                continue;
            }
            List<String> values = form.getPortletPreferences().get(key).getValue();
            ListIterator<String> iter = values.listIterator();
            while (iter.hasNext()) {
                String value = iter.next();
                if (!StringUtils.isEmpty((String)value)) continue;
                iter.remove();
            }
            if (values.size() != 0) continue;
            form.getPortletPreferences().remove(key);
            form.getPortletPreferencesOverrides().remove(key);
        }
        keys = new HashSet();
        keys.addAll(form.getParameters().keySet());
        for (String key : keys) {
            if (!parameterNames.contains(key)) {
                form.getParameters().remove(key);
                form.getParameterOverrides().remove(key);
                continue;
            }
            if (form.getParameters().get(key) != null && !StringUtils.isBlank((String)form.getParameters().get(key).getValue())) continue;
            form.getParameters().remove(key);
            form.getParameterOverrides().remove(key);
        }
    }

    public List<PortletContextImpl> getPortletApplications() {
        PortletRegistryService portletRegistryService = this.optionalContainerServices.getPortletRegistryService();
        ArrayList<PortletContextImpl> contexts = new ArrayList<PortletContextImpl>();
        Iterator iter = portletRegistryService.getRegisteredPortletApplications();
        while (iter.hasNext()) {
            PortletContextImpl context = (PortletContextImpl)iter.next();
            List portlets = context.getPortletApplicationDefinition().getPortlets();
            Collections.sort(portlets, new ComparableExtractingComparator<PortletDD, String>(String.CASE_INSENSITIVE_ORDER){

                @Override
                protected String getComparable(PortletDD o) {
                    List displayNames = o.getDisplayNames();
                    if (displayNames != null && displayNames.size() > 0) {
                        return ((DisplayNameDD)displayNames.get(0)).getDisplayName();
                    }
                    return o.getPortletName();
                }
            });
            contexts.add(context);
        }
        Collections.sort(contexts, new ComparableExtractingComparator<PortletContextImpl, String>(String.CASE_INSENSITIVE_ORDER){

            @Override
            protected String getComparable(PortletContextImpl o) {
                String portletContextName = o.getPortletContextName();
                if (portletContextName != null) {
                    return portletContextName;
                }
                String applicationName = o.getApplicationName();
                if ("/".equals(applicationName)) {
                    return "ROOT";
                }
                if (applicationName.startsWith("/")) {
                    return applicationName.substring(1);
                }
                return applicationName;
            }
        });
        return contexts;
    }

    public PortletDD getPortletDescriptor(ChannelDefinitionForm form) {
        Tuple<String, String> portletDescriptorKeys = this.getPortletDescriptorKeys(form);
        if (portletDescriptorKeys == null) {
            return null;
        }
        String portletAppId = (String)portletDescriptorKeys.first;
        String portletName = (String)portletDescriptorKeys.second;
        PortletRegistryService portletRegistryService = this.optionalContainerServices.getPortletRegistryService();
        try {
            PortletDD portletDD = portletRegistryService.getPortletDescriptor(portletAppId, portletName);
            return portletDD;
        }
        catch (PortletContainerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void prepopulatePortlet(String application, String portlet, ChannelDefinitionForm form) {
        PortletDD portletDD;
        PortletRegistryService portletRegistryService = this.optionalContainerServices.getPortletRegistryService();
        try {
            portletDD = portletRegistryService.getPortletDescriptor(application, portlet);
        }
        catch (PortletContainerException e) {
            this.logger.warn((Object)("Failed to load portlet descriptor for appId='" + application + "', portletName='" + portlet + "'"), (Throwable)e);
            return;
        }
        form.setTitle(portletDD.getPortletName());
        form.setName(portletDD.getPortletName());
        form.getParameters().put("portletApplicationId", new Attribute(application));
        form.getParameters().put("portletName", new Attribute(portletDD.getPortletName()));
        for (Object obj : portletDD.getSupports()) {
            SupportsDD supports = (SupportsDD)obj;
            for (Object mode : supports.getPortletModes()) {
                if ("edit".equals(mode)) {
                    form.setEditable(true);
                    continue;
                }
                if (!"help".equals(mode)) continue;
                form.setHasHelp(true);
            }
        }
    }

    public ChannelLifecycleState[] getLifecycleStates() {
        return ChannelLifecycleState.values();
    }

    public Set<ChannelLifecycleState> getAllowedLifecycleStates(IPerson person, List<JsonEntityBean> categories) {
        TreeSet<ChannelLifecycleState> states = new TreeSet<ChannelLifecycleState>();
        if (this.hasLifecyclePermission(person, ChannelLifecycleState.EXPIRED, categories)) {
            states.add(ChannelLifecycleState.CREATED);
            states.add(ChannelLifecycleState.APPROVED);
            states.add(ChannelLifecycleState.EXPIRED);
            states.add(ChannelLifecycleState.PUBLISHED);
        } else if (this.hasLifecyclePermission(person, ChannelLifecycleState.PUBLISHED, categories)) {
            states.add(ChannelLifecycleState.CREATED);
            states.add(ChannelLifecycleState.APPROVED);
            states.add(ChannelLifecycleState.PUBLISHED);
        } else if (this.hasLifecyclePermission(person, ChannelLifecycleState.APPROVED, categories)) {
            states.add(ChannelLifecycleState.CREATED);
            states.add(ChannelLifecycleState.APPROVED);
        } else if (this.hasLifecyclePermission(person, ChannelLifecycleState.CREATED, categories)) {
            states.add(ChannelLifecycleState.CREATED);
        }
        return states;
    }

    public boolean hasLifecyclePermission(IPerson person, ChannelLifecycleState state, List<JsonEntityBean> categories) {
        String activity;
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        switch (state) {
            case APPROVED: {
                activity = "MANAGE_APPROVED";
                break;
            }
            case CREATED: {
                activity = "MANAGE_CREATED";
                break;
            }
            case PUBLISHED: {
                activity = "MANAGE";
                break;
            }
            case EXPIRED: {
                activity = "MANAGE_EXPIRED";
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        if (ap.hasPermission("UP_FRAMEWORK", activity, "ALL_CHANNELS")) {
            this.logger.debug((Object)("Found permission for category ALL_CHANNELS and lifecycle state " + state.toString()));
            return true;
        }
        for (JsonEntityBean category : categories) {
            if (!ap.canManage(state, category.getId())) continue;
            this.logger.debug((Object)("Found permission for category " + category.getName() + " and lifecycle state " + state.toString()));
            return true;
        }
        this.logger.debug((Object)("No permission for lifecycle state " + state.toString()));
        return false;
    }

    public boolean configModeAction(ExternalContext externalContext, String fname) throws IOException {
        ActionRequest actionRequest = (ActionRequest)externalContext.getNativeRequest();
        ActionResponse actionResponse = (ActionResponse)externalContext.getNativeResponse();
        PortletSession portletSession = actionRequest.getPortletSession();
        IPortletWindowId portletWindowId = (IPortletWindowId)portletSession.getAttribute("DELEGATE_WINDOW_ID__" + fname);
        if (portletWindowId == null) {
            throw new IllegalStateException("Cannot execute configModeAciton without a delegate window ID in the session for key: DELEGATE_WINDOW_ID__" + fname);
        }
        PortletDelegationDispatcher requestDispatcher = this.portletDelegationLocator.getRequestDispatcher((PortletRequest)actionRequest, portletWindowId);
        DelegationActionResponse delegationResponse = requestDispatcher.doAction(actionRequest, actionResponse);
        PortletUrl renderUrl = delegationResponse.getRenderUrl();
        DelegateState delegateState = delegationResponse.getDelegateState();
        return renderUrl == null || renderUrl.getPortletMode() != null && !IPortletAdaptor.CONFIG.equals((Object)renderUrl.getPortletMode()) || !IPortletAdaptor.CONFIG.equals((Object)delegateState.getPortletMode());
    }

    public boolean offerPortletSelection(ChannelDefinitionForm form) {
        if (!CSpringPortletAdaptor.class.getName().equals(form.getJavaClass())) {
            return false;
        }
        Map<String, Attribute> parameters = form.getParameters();
        return parameters.get("portletName") == null || StringUtils.isBlank((String)parameters.get("portletName").getValue());
    }

    protected Tuple<String, String> getPortletDescriptorKeys(ChannelDefinitionForm form) {
        Map<String, Attribute> parameters = form.getParameters();
        Attribute frameworkPortletAttribute = parameters.get("isFrameworkPortlet");
        Attribute portletAppIdAttribute = parameters.get("portletApplicationId");
        Attribute portletNameAttribute = parameters.get("portletName");
        if (portletAppIdAttribute == null && frameworkPortletAttribute == null || portletNameAttribute == null) {
            return null;
        }
        String portletAppId = frameworkPortletAttribute != null && Boolean.valueOf(frameworkPortletAttribute.getValue()) != false ? this.servletContext.getContextPath() : portletAppIdAttribute.getValue();
        String portletName = portletNameAttribute.getValue();
        return new Tuple<String, String>(portletAppId, portletName);
    }
}

