/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.registerportal;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlets.registerportal.IPortalDataSubmitter;
import org.jasig.portal.portlets.registerportal.PortalRegistrationData;
import org.springframework.beans.BeanUtils;

public class CommonsHttpPortalDataSubmitter
implements IPortalDataSubmitter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String submitUrl = null;
    private Set<String> ignoreProperties = new HashSet<String>();

    public CommonsHttpPortalDataSubmitter() {
        this.ignoreProperties.add("class");
        this.ignoreProperties.add("dataToSubmit");
    }

    public void setSubmitUrl(String submitUrl) {
        this.submitUrl = submitUrl;
    }

    public void setIgnoreProperties(Set<String> ignoreProperties) {
        this.ignoreProperties = ignoreProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitPortalData(PortalRegistrationData portalRegistrationData) {
        HttpClient client = new HttpClient();
        HttpClientParams httpClientParams = client.getParams();
        httpClientParams.setSoTimeout(5000);
        String postUrl = this.submitUrl;
        for (int redirectCounter = 0; redirectCounter < 10; ++redirectCounter) {
            PostMethod post = new PostMethod(postUrl);
            try {
                block12: {
                    this.addParameters(portalRegistrationData, post);
                    Integer result = null;
                    try {
                        result = client.executeMethod((HttpMethod)post);
                        if (result == 200) {
                            this.logger.info((Object)("Portal registration data successfully submitted to " + this.submitUrl));
                            boolean bl = true;
                            return bl;
                        }
                        if (result >= 300 && result <= 399) break block12;
                    }
                    catch (HttpException e) {
                        this.logger.warn((Object)"Portal registration data failed to submit due to a HTTP exception", (Throwable)e);
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException e) {
                        this.logger.warn((Object)"Portal registration data failed to submit due to an IO exception", (Throwable)e);
                        boolean bl = false;
                        return bl;
                    }
                    this.logger.warn((Object)("Portal registration data failed to submit with return code " + result));
                    boolean bl = false;
                    return bl;
                }
                Header newLocation = post.getResponseHeader("location");
                postUrl = newLocation.getValue();
                this.logger.info((Object)("Handling redirect to " + postUrl));
                continue;
            }
            finally {
                post.releaseConnection();
            }
        }
        this.logger.warn((Object)"Portal registration data failed to submit due to too many redirects");
        return false;
    }

    protected void addParameters(PortalRegistrationData portalRegistrationData, PostMethod post) {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(portalRegistrationData.getClass())) {
            Object value;
            Method readMethod;
            String name = propertyDescriptor.getName();
            if (this.ignoreProperties != null && this.ignoreProperties.contains(name) || (readMethod = propertyDescriptor.getReadMethod()) == null) continue;
            try {
                value = readMethod.invoke((Object)portalRegistrationData, new Object[0]);
            }
            catch (Exception e) {
                this.logger.info((Object)("Failed to read property " + name + " and will skip it. From bean " + portalRegistrationData));
                continue;
            }
            if (value instanceof Map) {
                Map dataMap = (Map)value;
                for (Map.Entry dataEntry : dataMap.entrySet()) {
                    String dataKey = String.valueOf(dataEntry.getKey());
                    Object dataValue = dataEntry.getValue();
                    if (dataValue instanceof Map) {
                        Map valueMap = (Map)dataValue;
                        for (Map.Entry valueEntry : valueMap.entrySet()) {
                            String valueKey = String.valueOf(valueEntry.getKey());
                            Object valueValue = valueEntry.getValue();
                            if (valueValue == null) continue;
                            post.addParameter(dataKey + "_" + valueKey, String.valueOf(valueValue));
                        }
                        continue;
                    }
                    if (dataValue == null) continue;
                    post.addParameter(dataKey, String.valueOf(dataValue));
                }
                continue;
            }
            if (value == null) continue;
            post.addParameter(name, String.valueOf(value));
        }
    }
}

