/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rdbm;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.rdbm.IDatabaseMetadata;
import org.jasig.portal.rdbm.IJoinQueryString;
import org.jasig.portal.rdbm.JoinQueryString;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseMetaDataImpl
implements IDatabaseMetadata,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(DatabaseMetaDataImpl.class);
    private static final SimpleDateFormat TO_DATE_FORMAT = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
    private static final JoinQueryString jdbcDb = new JdbcDb("{oj UP_USER LEFT OUTER JOIN UP_USER_LAYOUT ON UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID} WHERE");
    private static final JoinQueryString postgreSQLDb = new PostgreSQLDb("UP_USER LEFT OUTER JOIN UP_USER_LAYOUT ON UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID WHERE");
    private static final JoinQueryString oracleDb = new OracleDb("UP_USER, UP_USER_LAYOUT WHERE UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID(+) AND");
    private static final JoinQueryString[] joinTests = new JoinQueryString[]{oracleDb, postgreSQLDb, jdbcDb};
    private final DataSource dataSource;
    private final PlatformTransactionManager transactionManager;
    private TransactionTemplate transactionTemplate;
    private IJoinQueryString joinTest = null;
    private boolean dbmdSupportsOuterJoins = false;
    private boolean portalTablesExist = false;
    private boolean useTSWrapper = false;
    private boolean useToDate = false;
    private String databaseProductName = null;
    private String databaseProductVersion = null;
    private String driverName = null;
    private String driverVersion = null;
    private String userName = null;
    private String dbUrl = null;

    public DatabaseMetaDataImpl(DataSource ds, PlatformTransactionManager transactionManager) {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        this.dataSource = ds;
        this.transactionManager = transactionManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.transactionTemplate = new TransactionTemplate(this.transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.setReadOnly(true);
        this.transactionTemplate.afterPropertiesSet();
        this.runDatabaseTests();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)this.toString());
        }
    }

    private void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occured while closing a connection.", (Throwable)e);
        }
    }

    @Override
    public final IJoinQueryString getJoinQuery() {
        return this.joinTest;
    }

    @Override
    public final boolean supportsOuterJoins() {
        return this.joinTest != null;
    }

    @Override
    public final boolean supportsTransactions() {
        return true;
    }

    @Override
    public final boolean supportsPreparedStatements() {
        return true;
    }

    @Override
    public String getJdbcDriver() {
        return this.driverName;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public String getJdbcDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public String getJdbcUrl() {
        return this.dbUrl;
    }

    @Override
    public String getJdbcUser() {
        return this.userName;
    }

    @Override
    public String sqlTimeStamp() {
        return this.sqlTimeStamp(System.currentTimeMillis());
    }

    @Override
    public String sqlTimeStamp(long date) {
        StringBuffer sqlTS = new StringBuffer();
        if (this.useToDate) {
            sqlTS.append("TO_DATE('");
            sqlTS.append(TO_DATE_FORMAT.format(new Date(date)));
            sqlTS.append("', 'YYYY MM DD HH24:MI:SS')");
        } else if (this.useTSWrapper) {
            sqlTS.append("{ts '");
            sqlTS.append(new Timestamp(date).toString());
            sqlTS.append("'}");
        } else {
            sqlTS.append("'");
            sqlTS.append(new Timestamp(date).toString());
            sqlTS.append("'");
        }
        return sqlTS.toString();
    }

    @Override
    public String sqlTimeStamp(Date date) {
        if (date == null) {
            return "NULL";
        }
        return this.sqlTimeStamp(date.getTime());
    }

    public String toString() {
        StringBuilder dbInfo = new StringBuilder();
        dbInfo.append(this.databaseProductName);
        dbInfo.append(" (");
        dbInfo.append(this.databaseProductVersion);
        dbInfo.append(") / ");
        dbInfo.append(this.driverName);
        dbInfo.append(" (");
        dbInfo.append(this.driverVersion);
        dbInfo.append(") database/driver");
        dbInfo.append("\n");
        dbInfo.append("    Connected To: ");
        dbInfo.append(this.dbUrl);
        dbInfo.append("\n");
        if (this.portalTablesExist) {
            dbInfo.append("    Supports:");
            dbInfo.append("\n");
            dbInfo.append("        Outer Joins:          ");
            dbInfo.append(this.supportsOuterJoins());
            dbInfo.append("\n");
            dbInfo.append("        {ts metasyntax:       ");
            dbInfo.append(this.useTSWrapper);
            dbInfo.append("\n");
            dbInfo.append("        TO_DATE():            ");
            dbInfo.append(this.useToDate);
        } else {
            dbInfo.append("    WARNING: uPortal tables do no exist, not all meta-data tests were executed.");
        }
        return dbInfo.toString();
    }

    private void runDatabaseTests() {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            this.getMetaData(conn);
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
            this.testDatabaseInitialized(jdbcTemplate);
            if (this.portalTablesExist) {
                this.testOuterJoins(jdbcTemplate);
                this.testTimeStamp(jdbcTemplate);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Error during database initialization. ", (Throwable)e);
            throw new DataAccessResourceFailureException("Error during database initialization. ", (Throwable)e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    private void getMetaData(Connection conn) {
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            this.databaseProductName = dmd.getDatabaseProductName();
            this.databaseProductVersion = dmd.getDatabaseProductVersion();
            this.driverName = dmd.getDriverName();
            this.driverVersion = dmd.getDriverVersion();
            this.userName = dmd.getUserName();
            this.dbUrl = dmd.getURL();
            this.dbmdSupportsOuterJoins = dmd.supportsOuterJoins();
        }
        catch (SQLException sqle) {
            LOG.error((Object)"Error getting database meta data.", (Throwable)sqle);
        }
    }

    private void testDatabaseInitialized(SimpleJdbcTemplate jdbcTemplate) {
        try {
            jdbcTemplate.queryForInt("SELECT COUNT(USER_ID) FROM UP_USER", new Object[0]);
            this.portalTablesExist = true;
        }
        catch (BadSqlGrammarException bsge) {
            LOG.warn((Object)"The uPortal database is not initialized, the database tests will not be performed.");
        }
    }

    private void testOuterJoins(final SimpleJdbcTemplate jdbcTemplate) {
        if (this.dbmdSupportsOuterJoins) {
            for (JoinQueryString joinQueryString : joinTests) {
                final String joinTestQuery = "SELECT COUNT(UP_USER.USER_ID) FROM " + joinQueryString.getTestJoin() + " UP_USER.USER_ID=0";
                try {
                    this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        public void doInTransactionWithoutResult(TransactionStatus status) {
                            jdbcTemplate.getJdbcOperations().execute(joinTestQuery);
                        }
                    });
                    this.joinTest = joinQueryString;
                    if (!LOG.isInfoEnabled()) break;
                    LOG.info((Object)("Using join test: " + this.joinTest.getClass().getName()));
                    break;
                }
                catch (DataAccessException e) {
                    String logMessage = "Join test failed: " + joinQueryString.getClass().getName() + " on statement: '" + joinTestQuery + "':";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)logMessage, (Throwable)e);
                        continue;
                    }
                    LOG.info((Object)(logMessage + "\n" + e.getMessage()));
                }
            }
        }
    }

    private void testTimeStamp(SimpleJdbcTemplate jdbcTemplate) {
        block7: {
            try {
                String timeStampTestQuery = "SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT={ts '2001-01-01 00:00:00.0'} AND USER_ID = 0";
                jdbcTemplate.queryForList("SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT={ts '2001-01-01 00:00:00.0'} AND USER_ID = 0", new Object[0]);
                this.useTSWrapper = true;
            }
            catch (DataAccessException dae1) {
                String logMessage1 = "Error running {ts } test.";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error running {ts } test.", (Throwable)dae1);
                } else {
                    LOG.info((Object)("Error running {ts } test.\n" + dae1.getMessage()));
                }
                try {
                    String toDateTestQuery = "SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT>TO_DATE('2001 01 01 00:00', 'YYYY MM DD HH24:MI:SS') AND USER_ID=0";
                    jdbcTemplate.queryForList("SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT>TO_DATE('2001 01 01 00:00', 'YYYY MM DD HH24:MI:SS') AND USER_ID=0", new Object[0]);
                    this.useToDate = true;
                }
                catch (DataAccessException dae2) {
                    String logMessage2 = "Error running TO_DATE() test.";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Error running TO_DATE() test.", (Throwable)dae2);
                        break block7;
                    }
                    LOG.info((Object)("Error running TO_DATE() test.\n" + dae2.getMessage()));
                }
            }
        }
    }

    public static final class JdbcDb
    extends JoinQueryString {
        public JdbcDb(String testString) {
            super(testString);
        }
    }

    public static final class OracleDb
    extends JoinQueryString {
        public OracleDb(String testString) {
            super(testString);
        }
    }

    public static final class PostgreSQLDb
    extends JoinQueryString {
        public PostgreSQLDb(String testString) {
            super(testString);
        }
    }
}

