/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.UserIdentityStoreFactory;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.InitialSecurityContextFactory;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.security.provider.RestrictedPerson;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;

public class PersonFactory {
    public static final String GUEST_USERNAME = PropertiesManager.getProperty("org.jasig.portal.security.PersonFactory.guest_user_name", "guest");
    private static final SingletonDoubleCheckedCreator<Integer> GUEST_USER_ID_LOADER = new SingletonDoubleCheckedCreator<Integer>(){

        @Override
        protected Integer createSingleton(Object ... args) {
            IPerson person = (IPerson)args[0];
            IUserIdentityStore userIdentityStore = UserIdentityStoreFactory.getUserIdentityStoreImpl();
            try {
                return userIdentityStore.getPortalUID(person);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while finding user id for person: " + person, e);
            }
        }
    };

    public static IPerson createPerson() {
        return new PersonImpl();
    }

    public static IPerson createSystemPerson() {
        IPerson person = PersonFactory.createPerson();
        person.setAttribute("username", "SYSTEM_USER");
        person.setID(0);
        return person;
    }

    public static IPerson createGuestPerson() throws Exception {
        IPerson person = PersonFactory.createPerson();
        person.setAttribute("username", GUEST_USERNAME);
        int guestUserId = (Integer)GUEST_USER_ID_LOADER.get(person);
        person.setID(guestUserId);
        person.setSecurityContext(InitialSecurityContextFactory.getInitialContext("root"));
        return person;
    }

    public static RestrictedPerson createRestrictedPerson() {
        IPerson person = PersonFactory.createPerson();
        return new RestrictedPerson(person);
    }
}

