/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.ChannelLifecycleState;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPermissionPolicy;
import org.jasig.portal.security.IPermissionSet;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.security.provider.AuthorizationPrincipalImpl;
import org.jasig.portal.security.provider.PermissionManagerImpl;
import org.jasig.portal.security.provider.PermissionSetImpl;
import org.jasig.portal.security.provider.UpdatingPermissionManagerImpl;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.cache.CacheFactoryLocator;

public class AuthorizationImpl
implements IAuthorizationService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final String PRINCIPAL_SEPARATOR = ".";
    private static final IAuthorizationService singleton = new AuthorizationImpl();
    private IPermissionStore permissionStore;
    private IPermissionPolicy defaultPermissionPolicy;
    protected final IChannelRegistryStore channelRegistryStore;
    private Map<String, IAuthorizationPrincipal> principalCache = CacheFactoryLocator.getCacheFactory().getCache("org.jasig.portal.security.provider.AuthorizationImpl.AUTH_PRINCIPAL_CACHE");
    private Map<String, Set<String>> entityParentsCache = CacheFactoryLocator.getCacheFactory().getCache("org.jasig.portal.security.provider.AuthorizationImpl.ENTITY_PARENTS_CACHE");
    private Class PERMISSION_SET_TYPE;
    private boolean cachePermissions;

    protected AuthorizationImpl() {
        this.initialize();
        this.channelRegistryStore = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
    }

    @Override
    public void addPermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().add(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    protected void cacheAdd(IPermissionSet ps) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().add(ps);
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem adding permissions for " + ps + " to cache", (Throwable)ce);
        }
    }

    protected IPermissionSet cacheGet(IAuthorizationPrincipal principal) throws AuthorizationException {
        try {
            return (IPermissionSet)EntityCachingService.getEntityCachingService().get(this.PERMISSION_SET_TYPE, principal.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem getting permissions for " + principal + " from cache", (Throwable)ce);
        }
    }

    protected void cacheRemove(IAuthorizationPrincipal ap) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().remove(this.PERMISSION_SET_TYPE, ap.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem removing permissions for " + ap + " from cache", (Throwable)ce);
        }
    }

    protected void cacheUpdate(IPermissionSet ps) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().update(ps);
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem updating permissions for " + ps + " in cache", (Throwable)ce);
        }
    }

    @Override
    public boolean canPrincipalConfigure(IAuthorizationPrincipal principal, int channelPublishId) throws AuthorizationException {
        String owner = "UP_FRAMEWORK";
        String target = "CHAN_ID." + channelPublishId;
        IChannelDefinition channel = this.channelRegistryStore.getChannelDefinition(channelPublishId);
        if (channel == null) {
            throw new AuthorizationException("Unable to locate channel " + channelPublishId);
        }
        String activity = "PORTLET_MODE_CONFIG";
        return this.doesPrincipalHavePermission(principal, owner, "PORTLET_MODE_CONFIG", "ALL_CHANNELS") || this.doesPrincipalHavePermission(principal, owner, "PORTLET_MODE_CONFIG", target);
    }

    @Override
    public boolean canPrincipalManage(IAuthorizationPrincipal principal, int channelPublishId) throws AuthorizationException {
        String owner = "UP_FRAMEWORK";
        String target = "CHAN_ID." + channelPublishId;
        IChannelDefinition channel = this.channelRegistryStore.getChannelDefinition(channelPublishId);
        if (channel == null) {
            return this.doesPrincipalHavePermission(principal, owner, "MANAGE_APPROVED", target);
        }
        ChannelLifecycleState state = channel.getLifecycleState();
        int order = state.getOrder();
        String all = "ALL_CHANNELS";
        String activity = "MANAGE_EXPIRED";
        if ((order <= ChannelLifecycleState.EXPIRED.getOrder() || channel.getExpirationDate() != null) && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, target))) {
            return true;
        }
        activity = "MANAGE";
        if ((order <= ChannelLifecycleState.PUBLISHED.getOrder() || channel.getPublishDate() != null) && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, target))) {
            return true;
        }
        activity = "MANAGE_APPROVED";
        this.log.debug((Object)("order: " + order + ", approved order: " + ChannelLifecycleState.APPROVED.getOrder()));
        if (order <= ChannelLifecycleState.APPROVED.getOrder() && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, target))) {
            return true;
        }
        activity = "MANAGE_CREATED";
        return order <= ChannelLifecycleState.CREATED.getOrder() && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, target));
    }

    @Override
    public boolean canPrincipalManage(IAuthorizationPrincipal principal, ChannelLifecycleState state, String categoryId) throws AuthorizationException {
        String owner = "UP_FRAMEWORK";
        ChannelCategory category = this.channelRegistryStore.getChannelCategory(categoryId);
        if (category == null) {
            throw new AuthorizationException("Unable to locate category " + categoryId);
        }
        int order = state.getOrder();
        String all = "ALL_CHANNELS";
        String activity = "MANAGE_EXPIRED";
        if (order <= ChannelLifecycleState.EXPIRED.getOrder() && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, categoryId))) {
            return true;
        }
        activity = "MANAGE";
        if (order <= ChannelLifecycleState.PUBLISHED.getOrder() && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, categoryId))) {
            return true;
        }
        activity = "MANAGE_APPROVED";
        if (order <= ChannelLifecycleState.APPROVED.getOrder() && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, categoryId))) {
            return true;
        }
        activity = "MANAGE_CREATED";
        return order <= ChannelLifecycleState.CREATED.getOrder() && (this.doesPrincipalHavePermission(principal, owner, activity, all) || this.doesPrincipalHavePermission(principal, owner, activity, categoryId));
    }

    @Override
    public boolean canPrincipalRender(IAuthorizationPrincipal principal, int channelPublishId) throws AuthorizationException {
        return this.canPrincipalSubscribe(principal, channelPublishId);
    }

    @Override
    public boolean canPrincipalSubscribe(IAuthorizationPrincipal principal, int channelPublishId) {
        String permission;
        String owner = "UP_FRAMEWORK";
        String target = "CHAN_ID." + channelPublishId;
        IChannelDefinition channel = this.channelRegistryStore.getChannelDefinition(channelPublishId);
        if (channel == null) {
            return false;
        }
        ChannelLifecycleState state = channel.getLifecycleState();
        if (state.equals((Object)ChannelLifecycleState.PUBLISHED)) {
            permission = "SUBSCRIBE";
        } else if (state.equals((Object)ChannelLifecycleState.APPROVED)) {
            permission = "SUBSCRIBE_APPROVED";
        } else if (state.equals((Object)ChannelLifecycleState.CREATED)) {
            permission = "SUBSCRIBE_CREATED";
        } else if (state.equals((Object)ChannelLifecycleState.EXPIRED)) {
            permission = "SUBSCRIBE_EXPIRED";
        } else {
            throw new AuthorizationException("Unrecognized lifecycle state for channel " + channelPublishId);
        }
        return this.doesPrincipalHavePermission(principal, owner, permission, "ALL_CHANNELS") || this.doesPrincipalHavePermission(principal, owner, permission, target);
    }

    @Override
    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.doesPrincipalHavePermission(principal, owner, activity, target, this.getDefaultPermissionPolicy());
    }

    @Override
    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target, IPermissionPolicy policy) throws AuthorizationException {
        return policy.doesPrincipalHavePermission(this, principal, owner, activity, target);
    }

    @Override
    public IPermission[] getAllPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        IPermission[] perms = this.getPermissionsForPrincipal(principal, owner, activity, target);
        ArrayList<IPermission> al = new ArrayList<IPermission>(Arrays.asList(perms));
        Iterator i = this.getInheritedPrincipals(principal);
        while (i.hasNext()) {
            IAuthorizationPrincipal p = (IAuthorizationPrincipal)i.next();
            perms = this.getPermissionsForPrincipal(p, owner, activity, target);
            al.addAll(Arrays.asList(perms));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("query for all permissions for prcinipal=[" + principal + "], owner=[" + owner + "], activity=[" + activity + "], target=[" + target + "] returned permissions [" + al + "]"));
        }
        return al.toArray(new IPermission[al.size()]);
    }

    @Override
    public Vector getAuthorizedChannels(IAuthorizationPrincipal principal) throws AuthorizationException {
        return new Vector();
    }

    public IAuthorizationPrincipal[] getAuthorizedPrincipals(String owner, String activity, String target) throws AuthorizationException {
        IPermission[] permissions = this.getPermissionsForOwner(owner, activity, target);
        return this.getPrincipalsFromPermissions(permissions);
    }

    protected IPermissionPolicy getDefaultPermissionPolicy() {
        return this.defaultPermissionPolicy;
    }

    @Override
    public IGroupMember getGroupMember(IAuthorizationPrincipal principal) throws GroupsException {
        return this.getGroupMemberForPrincipal(principal);
    }

    private IGroupMember getGroupMemberForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        IGroupMember gm = GroupService.getGroupMember(principal.getKey(), principal.getType());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AuthorizationImpl.getGroupMemberForPrincipal(): principal [" + principal + "] " + "got group member [" + gm + "]"));
        }
        return gm;
    }

    private Iterator getGroupsForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        IGroupMember gm = this.getGroupMemberForPrincipal(principal);
        return gm.getAllContainingGroups();
    }

    private Iterator getInheritedPrincipals(IAuthorizationPrincipal principal) throws AuthorizationException {
        Iterator i = null;
        ArrayList<IAuthorizationPrincipal> al = new ArrayList<IAuthorizationPrincipal>(5);
        try {
            i = this.getGroupsForPrincipal(principal);
        }
        catch (GroupsException ge) {
            throw new AuthorizationException("Could not retrieve Groups for " + principal, (Throwable)ge);
        }
        while (i.hasNext()) {
            IEntityGroup group = (IEntityGroup)i.next();
            IAuthorizationPrincipal p = this.getPrincipalForGroup(group);
            al.add(p);
        }
        return al.iterator();
    }

    @Override
    public IPermission[] getPermissionsForOwner(String owner, String activity, String target) throws AuthorizationException {
        return this.primRetrievePermissions(owner, null, activity, target);
    }

    @Override
    public IPermission[] getPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.primGetPermissionsForPrincipal(principal, owner, activity, target);
    }

    private IPermissionStore getPermissionStore() {
        return this.permissionStore;
    }

    @Override
    public IAuthorizationPrincipal getPrincipal(IPermission permission) throws AuthorizationException {
        String principalString = permission.getPrincipal();
        int idx = principalString.indexOf(PRINCIPAL_SEPARATOR);
        Integer typeId = new Integer(principalString.substring(0, idx));
        Class type = EntityTypes.getEntityType(typeId);
        String key = principalString.substring(idx + 1);
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal getPrincipalForGroup(IEntityGroup group) {
        String key = group.getKey();
        Class type = EntityTypes.GROUP_ENTITY_TYPE;
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal[] getPrincipalsFromPermissions(IPermission[] permissions) throws AuthorizationException {
        HashSet<IAuthorizationPrincipal> principals = new HashSet<IAuthorizationPrincipal>();
        for (int i = 0; i < permissions.length; ++i) {
            IAuthorizationPrincipal principal = this.getPrincipal(permissions[i]);
            principals.add(principal);
        }
        return principals.toArray(new IAuthorizationPrincipal[principals.size()]);
    }

    @Override
    public String getPrincipalString(IAuthorizationPrincipal principal) {
        return this.getPrincipalString(principal.getType(), principal.getKey());
    }

    private String getPrincipalString(Class pType, String pKey) {
        Integer type = EntityTypes.getEntityTypeID(pType);
        return type + PRINCIPAL_SEPARATOR + pKey;
    }

    public IPermission[] getUncachedPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        String pString = this.getPrincipalString(principal);
        return this.primRetrievePermissions(owner, pString, activity, target);
    }

    private void initialize() throws IllegalArgumentException {
        boolean DEFAULT_CACHE_PERMISSIONS = false;
        String factoryName = PropertiesManager.getProperty("org.jasig.portal.security.IPermissionStore.implementation", null);
        String policyName = PropertiesManager.getProperty("org.jasig.portal.security.IPermissionPolicy.defaultImplementation", null);
        this.cachePermissions = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.security.IAuthorizationService.cachePermissions", false);
        if (factoryName == null) {
            String eMsg = "AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionStore.implementation portal.properties.";
            this.log.error((Object)"AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionStore.implementation portal.properties.");
            throw new IllegalArgumentException("AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionStore.implementation portal.properties.");
        }
        if (policyName == null) {
            String eMsg = "AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionPolicy.defaultImplementation portal.properties.";
            this.log.error((Object)"AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionPolicy.defaultImplementation portal.properties.");
            throw new IllegalArgumentException("AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionPolicy.defaultImplementation portal.properties.");
        }
        try {
            this.permissionStore = (IPermissionStore)Class.forName(factoryName).newInstance();
        }
        catch (Exception e) {
            String eMsg = "AuthorizationImpl.initialize(): Problem creating permission store... ";
            this.log.error((Object)"AuthorizationImpl.initialize(): Problem creating permission store... ", (Throwable)e);
            throw new IllegalArgumentException("AuthorizationImpl.initialize(): Problem creating permission store... ");
        }
        try {
            this.defaultPermissionPolicy = (IPermissionPolicy)Class.forName(policyName).newInstance();
        }
        catch (Exception e) {
            String eMsg = "AuthorizationImpl.initialize(): Problem creating default permission policy... ";
            this.log.error((Object)"AuthorizationImpl.initialize(): Problem creating default permission policy... ", (Throwable)e);
            throw new IllegalArgumentException("AuthorizationImpl.initialize(): Problem creating default permission policy... ");
        }
        try {
            this.PERMISSION_SET_TYPE = Class.forName("org.jasig.portal.security.IPermissionSet");
        }
        catch (ClassNotFoundException cnfe) {
            String eMsg = "AuthorizationImpl.initialize(): Problem initializing service. ";
            this.log.error((Object)"AuthorizationImpl.initialize(): Problem initializing service. ", (Throwable)cnfe);
            throw new IllegalArgumentException("AuthorizationImpl.initialize(): Problem initializing service. ");
        }
    }

    public IPermission newPermission(String owner) {
        return this.newPermission(owner, null);
    }

    @Override
    public IPermission newPermission(String owner, IAuthorizationPrincipal principal) {
        IPermission p = this.getPermissionStore().newInstance(owner);
        if (principal != null) {
            String pString = this.getPrincipalString(principal);
            p.setPrincipal(pString);
        }
        return p;
    }

    @Override
    public IPermissionManager newPermissionManager(String owner) {
        return new PermissionManagerImpl(owner, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuthorizationPrincipal newPrincipal(String key, Class type) {
        String principalKey = this.getPrincipalString(type, key);
        IAuthorizationPrincipal principal = null;
        Map<String, IAuthorizationPrincipal> map = this.principalCache;
        synchronized (map) {
            principal = this.principalCache.get(principalKey);
            if (principal == null) {
                principal = this.primNewPrincipal(key, type);
                this.principalCache.put(principalKey, principal);
            }
        }
        return principal;
    }

    @Override
    public IAuthorizationPrincipal newPrincipal(IGroupMember groupMember) throws GroupsException {
        String key = groupMember.getKey();
        Class type = groupMember.getType();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AuthorizationImpl.newPrincipal(): for " + type + "(" + key + ")"));
        }
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal primNewPrincipal(String key, Class type) {
        return new AuthorizationPrincipalImpl(key, type, this);
    }

    @Override
    public IUpdatingPermissionManager newUpdatingPermissionManager(String owner) {
        return new UpdatingPermissionManagerImpl(owner, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal) throws AuthorizationException {
        if (!this.cachePermissions) {
            return this.getUncachedPermissionsForPrincipal(principal, null, null, null);
        }
        IPermissionSet ps = null;
        ps = this.cacheGet(principal);
        if (ps == null) {
            IAuthorizationPrincipal iAuthorizationPrincipal = principal;
            synchronized (iAuthorizationPrincipal) {
                ps = this.cacheGet(principal);
                if (ps == null) {
                    IPermission[] permissions = this.getUncachedPermissionsForPrincipal(principal, null, null, null);
                    ps = new PermissionSetImpl(permissions, principal);
                    this.cacheAdd(ps);
                }
            }
        }
        return ps.getPermissions();
    }

    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        Set<Object> containingGroups;
        IPermission[] perms = this.primGetPermissionsForPrincipal(principal);
        if (owner == null && activity == null && target == null) {
            return perms;
        }
        if (target != null) {
            containingGroups = this.entityParentsCache.get(target);
            if (containingGroups == null) {
                containingGroups = new HashSet();
                IGroupMember targetEntity = GroupService.findGroup(target);
                if (targetEntity == null) {
                    targetEntity = target.startsWith("CHAN_ID.") ? GroupService.getGroupMember(target.replace("CHAN_ID.", ""), IChannelDefinition.class) : GroupService.getGroupMember(target, IPerson.class);
                }
                if (targetEntity != null) {
                    Iterator containing = targetEntity.getAllContainingGroups();
                    while (containing.hasNext()) {
                        containingGroups.add(((IEntityGroup)containing.next()).getKey());
                    }
                }
                this.entityParentsCache.put(target, containingGroups);
            }
        } else {
            containingGroups = new HashSet();
        }
        ArrayList<IPermission> al = new ArrayList<IPermission>(perms.length);
        for (int i = 0; i < perms.length; ++i) {
            String permissionTarget = perms[i].getTarget();
            if (owner != null && !owner.equals(perms[i].getOwner()) || activity != null && !activity.equals(perms[i].getActivity()) || target != null && !target.equals(permissionTarget) && !containingGroups.contains(permissionTarget)) continue;
            al.add(perms[i]);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("AuthorizationImpl.primGetPermissionsForPrincipal(): Principal: " + principal + " owner: " + owner + " activity: " + activity + " target: " + target + " : permissions retrieved: " + al));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AuthorizationImpl.primGetPermissionsForPrincipal(): Principal: " + principal + " owner: " + owner + " activity: " + activity + " target: " + target + " : number of permissions retrieved: " + al.size()));
        }
        return al.toArray(new IPermission[al.size()]);
    }

    private IPermission[] primRetrievePermissions(String owner, String principal, String activity, String target) throws AuthorizationException {
        return this.getPermissionStore().select(owner, principal, activity, target, null);
    }

    private void removeFromPermissionsCache(IAuthorizationPrincipal[] principals) throws AuthorizationException {
        for (int i = 0; i < principals.length; ++i) {
            this.cacheRemove(principals[i]);
        }
    }

    private void removeFromPermissionsCache(IPermission[] permissions) throws AuthorizationException {
        IAuthorizationPrincipal[] principals = this.getPrincipalsFromPermissions(permissions);
        this.removeFromPermissionsCache(principals);
    }

    @Override
    public void removePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().delete(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    protected void setDefaultPermissionPolicy(IPermissionPolicy newDefaultPermissionPolicy) {
        this.defaultPermissionPolicy = newDefaultPermissionPolicy;
    }

    public static IAuthorizationService singleton() {
        return singleton;
    }

    @Override
    public void updatePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().update(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }
}

