/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.services.HttpClientManager;
import org.jasig.portal.utils.CommonUtils;

public class ProxyWriter {
    private static final Log log = LogFactory.getLog(ProxyWriter.class);
    protected boolean _proxying;
    private static final String[] _proxiableElements = new String[]{"image", "img", "input"};
    private static boolean PROXY_ENABLED = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.serialize.ProxyWriter.resource_proxy_enabled");
    private static String PROXIED_FILES_URI = PropertiesManager.getProperty("org.jasig.portal.serialize.ProxyWriter.proxy_files_uri");
    private static String PROXIED_FILES_PATH = PropertiesManager.getProperty("org.jasig.portal.serialize.ProxyWriter.proxy_files_path");
    private static final String PROXY_REWRITE_PREFIX = PropertiesManager.getProperty("org.jasig.portal.serialize.ProxyWriter.resource_proxy_rewrite_prefix");
    private static final String PROXY_REWRITE_NO_REDIRECT_DOMAIN = PropertiesManager.getProperty("org.jasig.portal.serialize.ProxyWriter.no_redirect_domain");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String considerProxyRewrite(String name, String localName, String url) {
        if (!PROXY_ENABLED || !name.equalsIgnoreCase("src") && !name.equalsIgnoreCase("archive") || url.indexOf("http://") == -1) return url;
        String skip_protocol = url.substring(7);
        String domain_only = skip_protocol.substring(0, skip_protocol.indexOf("/"));
        if (PROXY_REWRITE_NO_REDIRECT_DOMAIN.length() != 0 && domain_only.endsWith(PROXY_REWRITE_NO_REDIRECT_DOMAIN)) return url;
        String work_url = url;
        block13: while (true) {
            String string;
            HttpClient client = HttpClientManager.getNewHTTPClient();
            GetMethod get = new GetMethod(work_url);
            try {
                int responseCode = client.executeMethod((HttpMethod)get);
                if (responseCode != 301 && responseCode != 302) {
                    if (localName.equalsIgnoreCase("script")) {
                        string = ProxyWriter.reWrite(work_url, get);
                        return string;
                    }
                    for (int i = 0; i < _proxiableElements.length; ++i) {
                        if (!localName.equalsIgnoreCase(_proxiableElements[i])) continue;
                        work_url = PROXY_REWRITE_PREFIX + work_url.substring(7);
                        break;
                    }
                    String i = work_url;
                    return i;
                }
                Header location = get.getResponseHeader("location");
                if (location == null) {
                    String string2 = url;
                    return string2;
                }
                work_url = location.getValue();
                InputStream in = get.getResponseBodyAsStream();
                try {
                    byte[] buff = new byte[4096];
                    while (true) {
                        if (in.read(buff) <= 0) continue block13;
                    }
                }
                finally {
                    in.close();
                    continue;
                }
            }
            catch (ConnectTimeoutException cte) {
                string = "";
                return string;
            }
            catch (IOException ioe) {
                string = url;
                return string;
            }
            finally {
                get.releaseConnection();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String reWrite(String scriptUri, GetMethod get) {
        String fileName = ProxyWriter.fileNameGenerator(scriptUri);
        String filePath = PROXIED_FILES_PATH + fileName;
        try {
            File outputFile = new File(filePath);
            if (!outputFile.exists() || System.currentTimeMillis() - outputFile.lastModified() > 1800000L) {
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream()));
                    try {
                        FileWriter out = new FileWriter(outputFile);
                        try {
                            String line;
                            while ((line = in.readLine()) != null) {
                                out.write(ProxyWriter.processLine(line) + "\t\n");
                            }
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("ProxyWriter::rewrite():Failed to rewrite the file for: " + scriptUri), (Throwable)e);
                    outputFile.delete();
                    return scriptUri;
                }
            }
            String newScriptPath = PROXIED_FILES_URI + fileName;
            HttpClient client = HttpClientManager.getNewHTTPClient();
            GetMethod getTest = new GetMethod(newScriptPath);
            try {
                int rc = client.executeMethod((HttpMethod)getTest);
                if (rc != 200) {
                    log.error((Object)("ProxyWriter::rewrite(): The file  " + filePath + " is written but cannot be reached at " + newScriptPath));
                    String string = scriptUri;
                    return string;
                }
                String string = PROXY_REWRITE_PREFIX + PROXIED_FILES_URI.substring(7) + fileName;
                return string;
            }
            finally {
                getTest.releaseConnection();
            }
        }
        catch (IOException e) {
            log.error((Object)("ProxyWriter::rewrite(): Failed to read the file at : " + filePath), (Throwable)e);
            return scriptUri;
        }
    }

    private static String fileNameGenerator(String addr) {
        String newName = CommonUtils.replaceText(addr, "/", "");
        newName = CommonUtils.replaceText(newName, "http:", "");
        newName = CommonUtils.replaceText(newName, "www.", "");
        newName = CommonUtils.replaceText(newName, ".", "");
        newName = CommonUtils.replaceText(newName, "?", "");
        newName = CommonUtils.replaceText(newName, "&", "");
        return newName.substring(0, Math.min(16, newName.length())) + ".html";
    }

    private static String processLine(String line) throws Exception {
        try {
            if (line.indexOf(" src") != -1 && line.indexOf("http://") != -1) {
                String srcValue = ProxyWriter.extractURL(line);
                String srcNewValue = ProxyWriter.createProxyURL(srcValue);
                line = CommonUtils.replaceText(line, srcValue, srcNewValue);
                int firstPartIndex = line.lastIndexOf(srcNewValue) + srcNewValue.length();
                String remaining = line.substring(firstPartIndex);
                return line.substring(0, firstPartIndex) + "  " + ProxyWriter.processLine(remaining);
            }
            return line;
        }
        catch (Exception e) {
            log.error((Object)("Failed to process a line : " + line), (Throwable)e);
            throw e;
        }
    }

    private static String extractURL(String line) {
        int URLStartIndex = 0;
        int URLEndIndex = 0;
        int srcIndex = line.indexOf(" src");
        if (line.indexOf("https://", srcIndex) != -1) {
            return "";
        }
        if (line.indexOf("http://", srcIndex) == -1) {
            return "";
        }
        URLStartIndex = line.indexOf("http", srcIndex);
        URLEndIndex = line.indexOf(" ", URLStartIndex);
        String srcValue = line.substring(URLStartIndex, URLEndIndex);
        return srcValue;
    }

    private static String createProxyURL(String srcValue) {
        String srcNewValue = "";
        if (srcValue.indexOf("https://") != -1) {
            return srcValue;
        }
        srcNewValue = srcValue.indexOf("http://") != -1 ? CommonUtils.replaceText(srcValue, "http://", PROXY_REWRITE_PREFIX) : "";
        return srcNewValue;
    }
}

