/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.UserIdentityStoreFactory;
import org.jasig.portal.events.EventPublisherLocator;
import org.jasig.portal.events.support.UserLoggedInPortalEvent;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IAdditionalDescriptor;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPrincipal;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.services.PersonDirectory;
import org.jasig.portal.utils.MovingAverage;
import org.jasig.portal.utils.MovingAverageSample;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.context.ApplicationEvent;

public class Authentication {
    private static final Log log = LogFactory.getLog(Authentication.class);
    private static final String BASE_CONTEXT_NAME = "root";
    protected IPerson m_Person = null;
    protected ISecurityContext ic = null;
    private static final MovingAverage authenticationTimes = new MovingAverage();
    public static MovingAverageSample lastAuthentication = new MovingAverageSample();

    public void authenticate(HashMap principals, HashMap credentials, IPerson person) throws PortalSecurityException {
        ISecurityContext securityContext = person.getSecurityContext();
        this.configureSecurityContextChain(principals, credentials, person, securityContext, BASE_CONTEXT_NAME);
        long start = System.currentTimeMillis();
        securityContext.authenticate();
        long elapsed = System.currentTimeMillis() - start;
        if (securityContext.isAuthenticated()) {
            boolean autocreate;
            String username;
            IPersonAttributeDao pa;
            IPersonAttributes personAttributes;
            lastAuthentication = authenticationTimes.add(elapsed);
            person.setAttribute("username", securityContext.getPrincipal().getUID());
            IAdditionalDescriptor addInfo = person.getSecurityContext().getAdditionalDescriptor();
            if (addInfo != null) {
                if (addInfo instanceof IPerson) {
                    IPerson newPerson = (IPerson)addInfo;
                    person.setFullName(newPerson.getFullName());
                    Enumeration<String> e = newPerson.getAttributeNames();
                    while (e.hasMoreElements()) {
                        String attributeName = e.nextElement();
                        person.setAttribute(attributeName, newPerson.getAttribute(attributeName));
                    }
                    this.resetEntityIdentifier(person, newPerson);
                } else if (addInfo instanceof Map) {
                    Map additionalAttributes = (Map)((Object)addInfo);
                    for (String key : additionalAttributes.keySet()) {
                        person.setAttribute(key, additionalAttributes.get(key));
                    }
                } else if (!(addInfo instanceof ChainingSecurityContext.ChainingAdditionalDescriptor) && log.isWarnEnabled()) {
                    log.warn((Object)("Authentication Service recieved unknown additional descriptor [" + addInfo + "]"));
                }
            }
            if (PropertiesManager.getPropertyAsBoolean("org.jasig.portal.services.Authentication.usePersonDirectory") && (personAttributes = (pa = PersonDirectory.getPersonAttributeDao()).getPerson(username = this.getUsername(person))) != null) {
                person.setAttributes(personAttributes.getAttributes());
            }
            if (person.getFullName() == null) {
                if (person.getAttribute("portalDisplayName") != null) {
                    person.setFullName((String)person.getAttribute("portalDisplayName"));
                } else if (person.getAttribute("displayName") != null) {
                    person.setFullName((String)person.getAttribute("displayName"));
                }
                if (person.getFullName() == null) {
                    person.setFullName("Unrecognized person: " + person.getAttribute("username"));
                }
            }
            if ((autocreate = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.services.Authentication.autoCreateUsers")) && person.getAttribute("uPortalTemplateUserName") == null) {
                String defaultTemplateUserName = PropertiesManager.getProperty("org.jasig.portal.services.Authentication.defaultTemplateUserName");
                person.setAttribute("uPortalTemplateUserName", defaultTemplateUserName);
            }
            try {
                int newUID = UserIdentityStoreFactory.getUserIdentityStoreImpl().getPortalUID(person, autocreate);
                person.setID(newUID);
            }
            catch (AuthorizationException ae) {
                log.error((Object)"Exception retrieving ID", (Throwable)ae);
                throw new PortalSecurityException("Authentication Service: Exception retrieving UID");
            }
            EventPublisherLocator.getApplicationEventPublisher().publishEvent((ApplicationEvent)new UserLoggedInPortalEvent(this, person));
        }
    }

    protected String getUsername(IPerson person) {
        return (String)person.getAttribute("username");
    }

    protected void resetEntityIdentifier(IPerson person, IPerson newPerson) {
    }

    public IPerson getPerson() {
        return this.m_Person;
    }

    public ISecurityContext getSecurityContext() {
        return this.ic;
    }

    public void setContextParameters(HashMap principals, HashMap credentials, String ctxName, ISecurityContext securityContext, IPerson person) {
        IOpaqueCredentials credentialsInstance;
        if (log.isDebugEnabled()) {
            Map.Entry y;
            Map.Entry o;
            StringBuilder msg = new StringBuilder();
            msg.append("Preparing to authenticate;  setting parameters for context name '").append(ctxName).append("', context class '").append(securityContext.getClass().getName()).append("'");
            msg.append("\n\t Available Principal Tokens");
            Iterator i$ = principals.entrySet().iterator();
            while (i$.hasNext()) {
                y = o = i$.next();
                msg.append("\n\t\t").append(y.getKey()).append("=").append(y.getValue());
            }
            msg.append("\n\t Available Credential Tokens");
            i$ = credentials.entrySet().iterator();
            while (i$.hasNext()) {
                y = o = i$.next();
                String val = (String)y.getValue();
                String valWasSpecified = null;
                if (val != null) {
                    valWasSpecified = val.trim().length() == 0 ? "empty" : "provided";
                }
                msg.append("\n\t\t").append(y.getKey()).append(" was ").append(valWasSpecified);
            }
            log.debug((Object)msg.toString());
        }
        String username = (String)principals.get(ctxName);
        String credential = (String)credentials.get(ctxName);
        username = username != null ? username : (String)principals.get(BASE_CONTEXT_NAME);
        String string = credential = credential != null ? credential : (String)credentials.get(BASE_CONTEXT_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication::setContextParameters() username: " + username));
        }
        IPrincipal principalInstance = securityContext.getPrincipalInstance();
        if (username != null && !username.equals("")) {
            principalInstance.setUID(username);
        }
        if ((credentialsInstance = securityContext.getOpaqueCredentialsInstance()) != null) {
            credentialsInstance.setCredentials(credential);
        }
    }

    private void configureSecurityContextChain(HashMap principals, HashMap credentials, IPerson person, ISecurityContext securityContext, String baseContextName) throws PortalSecurityException {
        this.setContextParameters(principals, credentials, baseContextName, securityContext, person);
        Enumeration subCtxNames = securityContext.getSubContextNames();
        while (subCtxNames.hasMoreElements()) {
            String fullSubCtxName;
            String localSubCtxName = fullSubCtxName = (String)subCtxNames.nextElement();
            if (fullSubCtxName.startsWith(baseContextName + ".")) {
                localSubCtxName = localSubCtxName.substring(baseContextName.length() + 1);
            }
            ISecurityContext sc = securityContext.getSubContext(localSubCtxName);
            this.configureSecurityContextChain(principals, credentials, person, sc, fullSubCtxName);
        }
    }
}

