/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import org.jasig.portal.tools.checks.BaseCheck;
import org.jasig.portal.tools.checks.CheckResult;

public class ClassPresenceCheck
extends BaseCheck {
    private final String targetClass;
    private String remediationAdvice;

    public String getRemediationAdvice() {
        return this.remediationAdvice;
    }

    public void setRemediationAdvice(String remediationAdvice) {
        this.remediationAdvice = remediationAdvice;
    }

    public ClassPresenceCheck(String targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException("The constructor argument to the ClassPresenceCheck constructor was illegally null.");
        }
        this.targetClass = targetClass;
        this.setDescription("Checks for the presence of class " + targetClass);
        this.setRemediationAdvice("Is a required .jar missing from the /WEB-INF/lib directory or from the JRE endorsed directory or from the Tomcat endorsed directory?");
    }

    @Override
    protected CheckResult doCheckInternal() {
        try {
            this.getClass().getClassLoader().loadClass(this.targetClass);
        }
        catch (ClassNotFoundException e) {
            return this.getFailureResult();
        }
        return this.getSuccessResult();
    }

    CheckResult getFailureResult() {
        return CheckResult.createFailure("Failed to touch class " + this.targetClass, this.remediationAdvice);
    }

    CheckResult getSuccessResult() {
        return CheckResult.createSuccess("Successfully touched class " + this.targetClass);
    }

    String getTargetClass() {
        return this.targetClass;
    }
}

