/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import java.util.Arrays;
import org.apache.commons.lang.Validate;
import org.jasig.portal.tools.checks.CheckResult;
import org.jasig.portal.tools.checks.ClassPresenceCheck;

public class MethodPresenceCheck
extends ClassPresenceCheck {
    private final String targetMethod;
    private final Class<?>[] arguments;

    public MethodPresenceCheck(String targetClass, String targetMethod) {
        super(targetClass);
        Validate.notNull((Object)targetMethod, (String)"targetMethod can not be null");
        this.targetMethod = targetMethod;
        this.arguments = new Class[0];
    }

    public MethodPresenceCheck(String targetClass, String targetMethod, Class<?>[] arguments) {
        super(targetClass);
        Validate.notNull((Object)targetMethod, (String)"targetMethod can not be null");
        Validate.notNull(arguments, (String)"arguments can not be null");
        Validate.noNullElements((Object[])arguments, (String)"arguments can not contain null elements");
        this.targetMethod = targetMethod;
        this.arguments = arguments;
    }

    @Override
    protected CheckResult doCheckInternal() {
        Class<?> targetClass;
        CheckResult classCheckResult = super.doCheckInternal();
        if (!classCheckResult.isSuccess()) {
            return classCheckResult;
        }
        try {
            targetClass = this.getClass().getClassLoader().loadClass(this.getTargetClass());
        }
        catch (ClassNotFoundException e) {
            return this.getFailureResult();
        }
        try {
            targetClass.getMethod(this.targetMethod, this.arguments);
        }
        catch (SecurityException e) {
            return CheckResult.createFailure("Could not access method '" + this.targetMethod + "' " + "with arguments " + Arrays.asList(this.arguments) + " " + "on class '" + this.getTargetClass() + "'", this.getRemediationAdvice());
        }
        catch (NoSuchMethodException e) {
            return CheckResult.createFailure("Method '" + this.targetMethod + "' " + "with arguments " + Arrays.asList(this.arguments) + " " + "does not exist on class '" + this.getTargetClass() + "'", this.getRemediationAdvice());
        }
        return CheckResult.createSuccess("Found method  '" + this.targetMethod + "' " + "with arguments " + Arrays.asList(this.arguments) + " " + "on class '" + this.getTargetClass() + "'");
    }
}

