/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import java.io.IOException;
import java.sql.Connection;
import javax.sql.DataSource;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jasig.portal.tools.dbloader.ISchemaExport;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DataSourceSchemaExport
implements ISchemaExport {
    private Resource configuration;
    private DataSource dataSource;
    private String dialect;

    public Resource getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Resource configuration) {
        this.configuration = configuration;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hbm2ddl(boolean export, boolean create, boolean drop, String outputFile) {
        AnnotationConfiguration configuration = new AnnotationConfiguration();
        try {
            configuration.configure(this.configuration.getURL());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load configuration file '" + this.configuration + "'", e);
        }
        configuration.setProperty("hibernate.dialect", this.dialect);
        configuration.buildMappings();
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            SchemaExport exporter = new SchemaExport((Configuration)configuration, connection);
            exporter.setFormat(false);
            if (outputFile != null) {
                exporter.setOutputFile(outputFile);
            }
            exporter.execute(true, export, !create, !drop);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }
}

