/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.jasig.portal.tools.dbloader.BaseDbXmlHandler;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataXmlHandler
extends BaseDbXmlHandler {
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final Map<String, Map<String, Integer>> tableColumnInfo;
    private final List<String> script = new LinkedList<String>();
    private String currentTable = null;
    private String currentColumn = null;
    private String currentValue = null;
    private Map<String, String> rowData;

    public DataXmlHandler(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, Map<String, Map<String, Integer>> tableColumnTypes) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
        this.tableColumnInfo = tableColumnTypes;
    }

    public List<String> getScript() {
        return this.script;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("row".equals(name)) {
            this.rowData = new LinkedHashMap<String, String>();
        }
        this.chars = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("name".equals(name)) {
            String itemName = this.chars.toString().trim();
            if (this.currentTable == null) {
                this.currentTable = itemName;
            } else if (this.currentColumn == null) {
                this.currentColumn = itemName;
            }
        } else if ("value".equals(name)) {
            this.currentValue = this.chars.toString().trim();
        } else if ("column".equals(name)) {
            this.rowData.put(this.currentColumn, this.currentValue);
            this.currentColumn = null;
            this.currentValue = null;
        } else if ("row".equals(name)) {
            this.doInsert();
            this.rowData = null;
        } else if ("table".equals(name)) {
            this.currentTable = null;
        }
        this.chars = null;
    }

    protected final void doInsert() {
        if (this.rowData.size() == 0) {
            this.logger.warn((Object)("Found a row with no data for table " + this.currentTable + ", the row will be ignored"));
            return;
        }
        Map<String, Integer> columnInfo = this.tableColumnInfo.get(this.currentTable);
        StringBuilder columns = new StringBuilder();
        StringBuilder parameters = new StringBuilder();
        final Object[] values = new Object[this.rowData.size()];
        final int[] types = new int[this.rowData.size()];
        int index = 0;
        Iterator<Map.Entry<String, String>> rowIterator = this.rowData.entrySet().iterator();
        while (rowIterator.hasNext()) {
            Map.Entry<String, String> row = rowIterator.next();
            String columnName = row.getKey();
            columns.append(columnName);
            parameters.append("?");
            values[index] = row.getValue();
            types[index] = columnInfo.get(columnName);
            if (rowIterator.hasNext()) {
                columns.append(", ");
                parameters.append(", ");
            }
            ++index;
        }
        final String sql = "INSERT INTO " + this.currentTable + " (" + columns + ") VALUES (" + parameters + ")";
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(sql + "\t" + Arrays.asList(values) + "\t" + Arrays.asList(ArrayUtils.toObject((int[])types))));
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return DataXmlHandler.this.jdbcTemplate.update(sql, values, types);
            }
        });
    }
}

