/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.jasig.portal.tools.dbloader.DbLoaderConfiguration;
import org.jasig.portal.tools.dbloader.IDbLoader;
import org.springframework.context.ApplicationContext;

public class DbLoaderRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CommandLine commandLine;
        Options options = DbLoaderConfiguration.getOptions();
        try {
            PosixParser cliParser = new PosixParser();
            commandLine = cliParser.parse(options, args);
        }
        catch (ParseException exp) {
            DbLoaderRunner.printHelp(options);
            return;
        }
        if (commandLine.getOptions().length == 0) {
            DbLoaderRunner.printHelp(options);
            return;
        }
        DbLoaderConfiguration configuration = new DbLoaderConfiguration(commandLine);
        try {
            ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
            IDbLoader dbLoader = (IDbLoader)applicationContext.getBean("dbLoader", IDbLoader.class);
            dbLoader.process(configuration);
        }
        finally {
            PortalApplicationContextLocator.shutdown();
        }
    }

    protected static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(120, "HibernateDbLoader", "", options, "", true);
    }
}

