/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.io.FileCleaner;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.Errors;
import org.jasig.portal.ExceptionHelper;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.MultipartDataSource;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UploadStatus;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.portlet.url.IPortletRequestParameterManager;
import org.jasig.portal.url.IWritableHttpServletRequest;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.jasig.portal.url.processing.RequestParameterProcessingIncompleteException;
import org.jasig.portal.url.support.IChannelRequestParameterManager;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;

public class ChannelRequestParameterProcessor
extends CommonsFileUploadSupport
implements IRequestParameterProcessor,
DisposableBean {
    public static final String UPLOAD_STATUS = "up_upload_status";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletRequestParameterManager portletRequestParameterManager;
    private IChannelRequestParameterManager channelRequestParameterManager;
    private IUserInstanceManager userInstanceManager;

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Required
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        Validate.notNull((Object)userInstanceManager);
        this.userInstanceManager = userInstanceManager;
    }

    public IPortletRequestParameterManager getPortletRequestParameterManager() {
        return this.portletRequestParameterManager;
    }

    @Required
    public void setPortletRequestParameterManager(IPortletRequestParameterManager portletRequestParameterManager) {
        Validate.notNull((Object)portletRequestParameterManager, (String)"IPortletRequestParameterManager can not be null");
        this.portletRequestParameterManager = portletRequestParameterManager;
    }

    public IChannelRequestParameterManager getChannelRequestParameterManager() {
        return this.channelRequestParameterManager;
    }

    @Required
    public void setChannelRequestParameterManager(IChannelRequestParameterManager channelRequestParameterManager) {
        Validate.notNull((Object)channelRequestParameterManager, (String)"IChannelRequestParameterManager can not be null");
        this.channelRequestParameterManager = channelRequestParameterManager;
    }

    @Override
    public boolean processParameters(IWritableHttpServletRequest request, HttpServletResponse response) {
        boolean isPortletRequest = false;
        try {
            if (this.portletRequestParameterManager.getTargetedPortletWindowId(request) != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Request is targeting a portlet, channel parameter processing will not take place.");
                }
                isPortletRequest = true;
            }
        }
        catch (RequestParameterProcessingIncompleteException rppie) {
            return false;
        }
        String targetChannelId = this.getTargetChannelId(request);
        if (targetChannelId == null) {
            this.channelRequestParameterManager.setNoChannelParameters(request);
            return true;
        }
        HashMap<String, Object[]> channelParameters = new HashMap<String, Object[]>();
        if (isPortletRequest) {
            this.channelRequestParameterManager.setChannelParameters(request, targetChannelId, channelParameters);
            return true;
        }
        if (ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext((HttpServletRequest)request))) {
            UploadStatus uploadStatus;
            String encoding = this.determineEncoding(request);
            FileUpload fileUpload = this.prepareFileUpload(encoding);
            try {
                List fileItems = ((ServletFileUpload)fileUpload).parseRequest((HttpServletRequest)request);
                CommonsFileUploadSupport.MultipartParsingResult parsingResult = this.parseFileItems(fileItems, encoding);
                Map<String, MultipartDataSource[]> multipartDataSources = this.getMultipartDataSources(parsingResult);
                channelParameters.putAll(multipartDataSources);
                Map multipartParameters = parsingResult.getMultipartParameters();
                channelParameters.putAll(multipartParameters);
                uploadStatus = new UploadStatus(0, this.getFileUpload().getFileSizeMax());
            }
            catch (FileUploadException fue) {
                this.logger.warn((Object)"Failed to parse multipart upload, processing will continue but not all parameters may be available.", (Throwable)fue);
                uploadStatus = new UploadStatus(1, this.getFileUpload().getFileSizeMax());
                ExceptionHelper.genericTopHandler(Errors.bug, fue);
            }
            channelParameters.put(UPLOAD_STATUS, new UploadStatus[]{uploadStatus});
        }
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames != null && parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (parameterName.equals("uP_channelTarget") || parameterName.equals("uP_fname") || parameterName.equals("uP_help_target") || parameterName.equals("uP_about_target") || parameterName.equals("uP_edit_target") || parameterName.equals("uP_detach_target")) continue;
            String[] parameterValues = request.getParameterValues(parameterName);
            channelParameters.put(parameterName, parameterValues);
        }
        this.channelRequestParameterManager.setChannelParameters(request, targetChannelId, channelParameters);
        return true;
    }

    public void destroy() throws Exception {
        FileCleaner.exitWhenFinished();
    }

    protected String getTargetChannelId(IWritableHttpServletRequest request) {
        String methodNodeId;
        String targetChannelId = null;
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager userPreferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManger = userPreferencesManager.getUserLayoutManager();
        String fname = request.getParameter("uP_fname");
        if (fname != null) {
            try {
                targetChannelId = userLayoutManger.getSubscribeId(fname);
            }
            catch (PortalException pe) {
                this.logger.error((Object)("Unable to get subscribe ID for fname=" + fname), (Throwable)pe);
            }
        }
        if (targetChannelId == null) {
            targetChannelId = request.getParameter("uP_channelTarget");
        }
        if (targetChannelId == null) {
            targetChannelId = request.getParameter("uP_help_target");
        }
        if (targetChannelId == null) {
            targetChannelId = request.getParameter("uP_about_target");
        }
        if (targetChannelId == null) {
            targetChannelId = request.getParameter("uP_edit_target");
        }
        if (targetChannelId == null) {
            targetChannelId = request.getParameter("uP_detach_target");
        }
        UPFileSpec upfs = new UPFileSpec(request);
        if (targetChannelId == null) {
            targetChannelId = upfs.getTargetNodeId();
        }
        if (targetChannelId == null && !"userLayoutRootNode".equals(methodNodeId = upfs.getMethodNodeId())) {
            targetChannelId = methodNodeId;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("targetChannelId='" + targetChannelId + "'."));
        }
        return targetChannelId;
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        return new ServletFileUpload(fileItemFactory);
    }

    protected String determineEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    protected Map<String, MultipartDataSource[]> getMultipartDataSources(CommonsFileUploadSupport.MultipartParsingResult parsingResult) {
        Map multipartFiles = parsingResult.getMultipartFiles();
        HashMap<String, MultipartDataSource[]> multipartDataSources = new HashMap<String, MultipartDataSource[]>(multipartFiles.size());
        for (Map.Entry multipartFileEntry : multipartFiles.entrySet()) {
            MultipartFile multipartFile = (MultipartFile)multipartFileEntry.getValue();
            if (!StringUtils.isNotEmpty((String)multipartFile.getOriginalFilename())) continue;
            MultipartDataSource multipartDataSource = new MultipartDataSource(multipartFile);
            multipartDataSources.put((String)multipartFileEntry.getKey(), new MultipartDataSource[]{multipartDataSource});
        }
        return multipartDataSources;
    }
}

