/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.url.IWritableHttpServletRequest;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Required;

public class UrlRequestParameterProcessor
implements IRequestParameterProcessor {
    private static final Map<String, Pattern> structureParameters = new ConcurrentHashMap<String, Pattern>();
    private static final Map<String, Pattern> themeParameters = new ConcurrentHashMap<String, Pattern>();
    private IUserInstanceManager userInstanceManager;
    private final Log log = LogFactory.getLog(this.getClass());

    @Required
    public void setUserInstanceManager(IUserInstanceManager uim) {
        Validate.notNull((Object)uim);
        this.userInstanceManager = uim;
    }

    public void setStructureParameters(Map<String, String> params) {
        if (!structureParameters.isEmpty()) {
            String msg = "Property 'requestUrlParameters' may only be set once.";
            throw new IllegalStateException(msg);
        }
        for (Map.Entry<String, String> y : params.entrySet()) {
            structureParameters.put(y.getKey(), Pattern.compile(y.getValue()));
        }
    }

    public void setThemeParameters(Map<String, String> params) {
        if (!structureParameters.isEmpty()) {
            String msg = "Property 'requestUrlParameters' may only be set once.";
            throw new IllegalStateException(msg);
        }
        for (Map.Entry<String, String> y : params.entrySet()) {
            themeParameters.put(y.getKey(), Pattern.compile(y.getValue()));
        }
    }

    @Override
    public boolean processParameters(IWritableHttpServletRequest req, HttpServletResponse res) {
        IUserInstance user = this.userInstanceManager.getUserInstance(req);
        UserPreferences preferences = user.getPreferencesManager().getUserPreferences();
        String requestUrl = req.getRequestURL().toString();
        StructureStylesheetUserPreferences ssup = preferences.getStructureStylesheetUserPreferences();
        for (Map.Entry<String, Pattern> y : structureParameters.entrySet()) {
            Matcher m = y.getValue().matcher(requestUrl);
            if (!m.find()) continue;
            ssup.putParameterValue(y.getKey(), m.group(1));
        }
        ThemeStylesheetUserPreferences tsup = preferences.getThemeStylesheetUserPreferences();
        for (Map.Entry<String, Pattern> y : themeParameters.entrySet()) {
            Matcher m = y.getValue().matcher(requestUrl);
            if (!m.find()) continue;
            tsup.putParameterValue(y.getKey(), m.group(1));
        }
        return true;
    }
}

