/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.user;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.GuestUserInstance;
import org.jasig.portal.GuestUserPreferencesManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserInstance;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.spring.web.context.support.HttpSessionDestroyedEvent;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class UserInstanceManagerImpl
implements IUserInstanceManager,
ApplicationListener {
    protected final Log logger = LogFactory.getLog(UserInstanceManagerImpl.class);
    private Map<Integer, GuestUserPreferencesManager> guestUserPreferencesManagers = new HashMap<Integer, GuestUserPreferencesManager>();
    private IPersonManager personManager;
    private IPortalRequestUtils portalRequestUtils;

    public IPersonManager getPersonManager() {
        return this.personManager;
    }

    @Required
    public void setPersonManager(IPersonManager personManager) {
        Validate.notNull((Object)personManager);
        this.personManager = personManager;
    }

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IUserInstance getUserInstance(HttpServletRequest request) throws PortalException {
        IUserInstance userInstance;
        IPerson person;
        try {
            request = this.portalRequestUtils.getOriginalPortalRequest(request);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            person = this.personManager.getPerson(request);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception while retrieving IPerson!", (Throwable)e);
            throw new PortalSecurityException("Could not retrieve IPerson", (Throwable)e);
        }
        if (person == null) {
            throw new PortalSecurityException("PersonManager returned null person for this request.  With no user, there's no UserInstance.  Is PersonManager misconfigured?  RDBMS access misconfigured?");
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("An existing HttpSession is required while retrieving a UserInstance for a HttpServletRequest");
        }
        UserInstanceHolder userInstanceHolder = this.getUserInstanceHolder(session);
        if (userInstanceHolder != null && (userInstance = userInstanceHolder.getUserInstance()) != null) {
            return userInstance;
        }
        if (person.isGuest()) {
            GuestUserPreferencesManager guestUserPreferencesManager;
            Integer personId = person.getID();
            Map<Integer, GuestUserPreferencesManager> map = this.guestUserPreferencesManagers;
            synchronized (map) {
                guestUserPreferencesManager = this.guestUserPreferencesManagers.get(personId);
                if (guestUserPreferencesManager == null) {
                    guestUserPreferencesManager = new GuestUserPreferencesManager(person);
                    this.guestUserPreferencesManagers.put(personId, guestUserPreferencesManager);
                }
            }
            userInstance = new GuestUserInstance(person, guestUserPreferencesManager, request);
        } else {
            ISecurityContext securityContext = person.getSecurityContext();
            if (securityContext.isAuthenticated()) {
                userInstance = new UserInstance(person, request);
            } else {
                throw new PortalSecurityException("System does not allow for unauthenticated non-guest users.");
            }
        }
        if (userInstanceHolder == null) {
            userInstanceHolder = new UserInstanceHolder();
        }
        userInstanceHolder.setUserInstance(userInstance);
        session.setAttribute(UserInstanceHolder.KEY, (Object)userInstanceHolder);
        return userInstance;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionDestroyedEvent) {
            HttpSession session = ((HttpSessionDestroyedEvent)event).getSession();
            UserInstanceHolder userInstanceHolder = this.getUserInstanceHolder(session);
            if (userInstanceHolder == null) {
                return;
            }
            IUserInstance userInstance = userInstanceHolder.getUserInstance();
            if (userInstance != null) {
                userInstance.destroySession(session);
            }
        }
    }

    protected UserInstanceHolder getUserInstanceHolder(HttpSession session) {
        return (UserInstanceHolder)session.getAttribute(UserInstanceHolder.KEY);
    }

    private static class UserInstanceHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final transient String KEY = UserInstanceHolder.class.getName();
        private transient IUserInstance ui = null;

        private UserInstanceHolder() {
        }

        protected IUserInstance getUserInstance() {
            return this.ui;
        }

        protected void setUserInstance(IUserInstance userInstance) {
            this.ui = userInstance;
        }
    }
}

