/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.LinkedList;

public class BlockingQueue {
    int maxSize = -1;
    int minSize = 0;
    volatile LinkedList queue = new LinkedList();

    BlockingQueue() {
    }

    BlockingQueue(int min, int max) {
        this();
        this.maxSize = max;
        this.minSize = min;
    }

    BlockingQueue(int max) {
        this(0, max);
    }

    public synchronized void enqueue(Object o) throws InterruptedException {
        while (this.queue.size() >= this.maxSize && this.maxSize != -1) {
            this.wait();
        }
        this.queue.addLast(o);
        this.notifyAll();
    }

    public synchronized Object dequeue() throws InterruptedException {
        while (this.queue.size() <= this.minSize) {
            this.wait();
        }
        this.notifyAll();
        return this.queue.removeFirst();
    }

    public synchronized void setLimits(int max, int min) {
        this.maxSize = max;
        this.minSize = min;
        this.notifyAll();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public synchronized void setMaxSize(int max) {
        this.maxSize = max;
        this.notifyAll();
    }

    public synchronized void setMinSize(int min) {
        this.minSize = min;
        this.notifyAll();
    }

    public synchronized int size() {
        return this.queue.size();
    }
}

