/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.Random;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.utils.ICounterStore;
import org.jasig.portal.utils.threading.MapCachingDoubleCheckedCreator;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class PooledCounterStore
implements ICounterStore {
    private static final String GET_NEXT_VALUE = "SELECT SEQUENCE_VALUE FROM UP_SEQUENCE WHERE SEQUENCE_NAME=?";
    private static final String UPDATE_COUNTER_VALUE = "UPDATE UP_SEQUENCE SET SEQUENCE_VALUE=? WHERE SEQUENCE_NAME=? AND SEQUENCE_VALUE=?";
    private static final String CREATE_SEQUENCE = "INSERT INTO UP_SEQUENCE (SEQUENCE_NAME, SEQUENCE_VALUE) VALUES (?, ?)";
    private static final String FORCED_UPDATE_COUNTER_VALUE = "UPDATE UP_SEQUENCE SET SEQUENCE_VALUE=? WHERE SEQUENCE_NAME=?";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final MapCachingDoubleCheckedCreator<String, CounterPool> counterPools = new CounterPoolHolder();
    private final Random random = new Random();
    private TransactionTemplate transactionTemplate;
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private int initialValue = 1;
    private int increment = 50;
    private int retryCount = 10;
    private int minWait = 1;
    private int maxWait = 10;

    @Required
    public void setDataSource(DataSource dataSource) {
        Validate.notNull((Object)dataSource);
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Required
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        Validate.notNull((Object)transactionManager);
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getMinWait() {
        return this.minWait;
    }

    public void setMinWait(int minWait) {
        this.minWait = minWait;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCounter(String counterName) {
        CounterPool counterPool;
        CounterPool counterPool2 = counterPool = (CounterPool)this.counterPools.get(counterName);
        synchronized (counterPool2) {
            if (!counterPool.initialized) {
                boolean counterCreated;
                for (int attempt = 0; attempt < this.retryCount && !(counterCreated = ((Boolean)this.transactionTemplate.execute((TransactionCallback)counterPool.createCounterCallback)).booleanValue()); ++attempt) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Failed to create counter '" + counterName + "' waiting to retry"));
                    }
                    this.waitToRetry();
                }
            } else {
                this.logger.warn((Object)("Requested creation of counter '" + counterName + "' but the corresponding CounterPool is initialized, assuming it exists"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIncrementIntegerId(String counterName) {
        CounterPool counterPool;
        CounterPool counterPool2 = counterPool = (CounterPool)this.counterPools.get(counterName);
        synchronized (counterPool2) {
            if (counterPool.needsUpdate()) {
                boolean counterUpdated;
                for (int attempt = 0; attempt < this.retryCount && !(counterUpdated = ((Boolean)this.transactionTemplate.execute((TransactionCallback)counterPool.incrementCounterCallback)).booleanValue()); ++attempt) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Failed to update counter '" + counterName + "' waiting to retry"));
                    }
                    this.waitToRetry();
                }
            }
            return counterPool.nextValue++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCounter(String counterName, int value) {
        CounterPool counterPool;
        CounterPool counterPool2 = counterPool = (CounterPool)this.counterPools.get(counterName);
        synchronized (counterPool2) {
            boolean counterSet;
            ForceUpdateCounterCallback forceUpdateCounterCallback = new ForceUpdateCounterCallback(counterPool, this.increment, value, this.simpleJdbcTemplate);
            for (int attempt = 0; attempt < this.retryCount && !(counterSet = ((Boolean)this.transactionTemplate.execute((TransactionCallback)forceUpdateCounterCallback)).booleanValue()); ++attempt) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to set counter '" + counterName + "' waiting to retry"));
                }
                this.waitToRetry();
            }
        }
    }

    public void reset() {
        this.counterPools.clear();
    }

    protected void waitToRetry() {
        int waitTime = this.minWait >= this.maxWait ? this.minWait : this.random.nextInt(this.maxWait - this.minWait) + this.minWait;
        if (this.logger.isDebugEnabled()) {
            this.logger.warn((Object)("Waiting " + waitTime));
        }
        if (waitTime <= 0) {
            return;
        }
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static abstract class BaseCounterCallback
    implements TransactionCallback {
        private final CounterPool counterPool;
        private final SimpleJdbcTemplate simpleJdbcTemplate;
        private final int initialValue;
        private final int increment;

        public BaseCounterCallback(CounterPool counterPool, int increment, int initialValue, SimpleJdbcTemplate simpleJdbcTemplate) {
            this.counterPool = counterPool;
            this.increment = increment;
            this.initialValue = initialValue;
            this.simpleJdbcTemplate = simpleJdbcTemplate;
        }

        protected boolean createCounter(TransactionStatus status) {
            int maxValue = this.initialValue + this.increment - 1;
            int updateCount = this.simpleJdbcTemplate.update(PooledCounterStore.CREATE_SEQUENCE, new Object[]{this.counterPool.name, maxValue});
            if (updateCount == 1) {
                this.counterPool.initialized = true;
                this.counterPool.nextValue = this.initialValue;
                this.counterPool.maxValue = maxValue;
                return true;
            }
            return false;
        }
    }

    private static final class ForceUpdateCounterCallback
    extends BaseCounterCallback {
        private final CounterPool counterPool;
        private final SimpleJdbcTemplate simpleJdbcTemplate;
        private final int forcedValue;
        private final int increment;

        public ForceUpdateCounterCallback(CounterPool counterPool, int increment, int forcedValue, SimpleJdbcTemplate simpleJdbcTemplate) {
            super(counterPool, increment, forcedValue, simpleJdbcTemplate);
            this.counterPool = counterPool;
            this.increment = increment;
            this.forcedValue = forcedValue;
            this.simpleJdbcTemplate = simpleJdbcTemplate;
        }

        public Object doInTransaction(TransactionStatus status) {
            int maxValue = this.forcedValue + this.increment - 1;
            int updateCount = this.simpleJdbcTemplate.update(PooledCounterStore.FORCED_UPDATE_COUNTER_VALUE, new Object[]{maxValue, this.counterPool.name});
            if (updateCount == 1) {
                this.counterPool.initialized = true;
                this.counterPool.nextValue = this.forcedValue;
                this.counterPool.maxValue = maxValue;
                return true;
            }
            return this.createCounter(status);
        }
    }

    private static final class CreateCounterCallback
    extends BaseCounterCallback {
        private final CounterPool counterPool;
        private final SimpleJdbcTemplate simpleJdbcTemplate;

        public CreateCounterCallback(CounterPool counterPool, int increment, int initialValue, SimpleJdbcTemplate simpleJdbcTemplate) {
            super(counterPool, increment, initialValue, simpleJdbcTemplate);
            this.counterPool = counterPool;
            this.simpleJdbcTemplate = simpleJdbcTemplate;
        }

        public Object doInTransaction(TransactionStatus status) {
            try {
                this.simpleJdbcTemplate.queryForInt(PooledCounterStore.GET_NEXT_VALUE, new Object[]{this.counterPool.name});
                return true;
            }
            catch (IncorrectResultSizeDataAccessException irsdae) {
                if (irsdae.getActualSize() != 0) {
                    throw irsdae;
                }
                return this.createCounter(status);
            }
        }
    }

    private static final class IncrementCounterCallback
    extends BaseCounterCallback {
        private final CounterPool counterPool;
        private final SimpleJdbcTemplate simpleJdbcTemplate;
        private final int increment;

        public IncrementCounterCallback(CounterPool counterPool, int increment, int initialValue, SimpleJdbcTemplate simpleJdbcTemplate) {
            super(counterPool, increment, initialValue, simpleJdbcTemplate);
            this.counterPool = counterPool;
            this.increment = increment;
            this.simpleJdbcTemplate = simpleJdbcTemplate;
        }

        public Object doInTransaction(TransactionStatus status) {
            int lastValue;
            try {
                lastValue = this.simpleJdbcTemplate.queryForInt(PooledCounterStore.GET_NEXT_VALUE, new Object[]{this.counterPool.name});
            }
            catch (IncorrectResultSizeDataAccessException irsdae) {
                if (irsdae.getActualSize() != 0) {
                    throw irsdae;
                }
                return this.createCounter(status);
            }
            int nextEndValue = lastValue + this.increment;
            int updateCount = this.simpleJdbcTemplate.update(PooledCounterStore.UPDATE_COUNTER_VALUE, new Object[]{nextEndValue, this.counterPool.name, lastValue});
            if (updateCount == 1) {
                this.counterPool.initialized = true;
                this.counterPool.nextValue = lastValue + 1;
                this.counterPool.maxValue = nextEndValue;
                return true;
            }
            return false;
        }
    }

    private static class CounterPool {
        public final String name;
        public int nextValue = 0;
        public int maxValue = 0;
        public boolean initialized = false;
        public final IncrementCounterCallback incrementCounterCallback;
        public final CreateCounterCallback createCounterCallback;

        public CounterPool(String name, int increment, int initialValue, SimpleJdbcTemplate simpleJdbcTemplate) {
            this.name = name;
            this.incrementCounterCallback = new IncrementCounterCallback(this, increment, initialValue, simpleJdbcTemplate);
            this.createCounterCallback = new CreateCounterCallback(this, increment, initialValue, simpleJdbcTemplate);
        }

        public boolean needsUpdate() {
            return !this.initialized || this.nextValue > this.maxValue;
        }
    }

    private final class CounterPoolHolder
    extends MapCachingDoubleCheckedCreator<String, CounterPool> {
        private CounterPoolHolder() {
        }

        @Override
        protected CounterPool createInternal(String counterName, Object ... args) {
            return new CounterPool(counterName, PooledCounterStore.this.increment, PooledCounterStore.this.initialValue, PooledCounterStore.this.simpleJdbcTemplate);
        }

        @Override
        protected String getKey(Object ... args) {
            return (String)args[0];
        }
    }
}

