/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.TriggersRemove;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.spring.locator.EntityTypesLocator;
import org.jasig.portal.utils.ICounterStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository(value="entityTypes")
public class EntityTypes {
    private static final RowMapper<Class> CLASS_ROW_MAPPER = new /* Unavailable Anonymous Inner Class!! */;
    public static final Class<IEntityGroup> GROUP_ENTITY_TYPE = IEntityGroup.class;
    public static final Class<IEntity> LEAF_ENTITY_TYPE = IEntity.class;
    private JdbcOperations jdbcOperations;
    private ICounterStore counterStore;

    @Deprecated
    public static Class<? extends IBasicEntity> getEntityType(Integer typeID) {
        return EntityTypes.singleton().getEntityTypeFromID(typeID);
    }

    @Deprecated
    public static Integer getEntityTypeID(Class<? extends IBasicEntity> type) {
        return EntityTypes.singleton().getEntityIDFromType(type);
    }

    @Deprecated
    public static EntityTypes singleton() {
        return EntityTypesLocator.getEntityTypes();
    }

    @Autowired
    public void setJdbcOperations(@Qualifier(value="PortalDb") JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    @Autowired
    public void setCounterStore(ICounterStore counterStore) {
        this.counterStore = counterStore;
    }

    @Cacheable(cacheName="org.jasig.portal.EntityTypes.CLASS_BY_ID", keyGeneratorName="com.googlecode.ehcache.annotations.key.ListCacheKeyGenerator.DEFAULT_BEAN_NAME")
    public Class<? extends IBasicEntity> getEntityTypeFromID(Integer id) {
        List result = this.jdbcOperations.query("SELECT ENTITY_TYPE_NAME FROM UP_ENTITY_TYPE WHERE ENTITY_TYPE_ID = ?", CLASS_ROW_MAPPER, new Object[]{id});
        return (Class)DataAccessUtils.singleResult((Collection)result);
    }

    @Cacheable(cacheName="org.jasig.portal.EntityTypes.ID_BY_CLASS", keyGeneratorName="com.googlecode.ehcache.annotations.key.ListCacheKeyGenerator.DEFAULT_BEAN_NAME")
    public Integer getEntityIDFromType(Class<? extends IBasicEntity> type) {
        return (Integer)DataAccessUtils.singleResult((Collection)this.jdbcOperations.queryForList("SELECT ENTITY_TYPE_ID FROM UP_ENTITY_TYPE WHERE ENTITY_TYPE_NAME = ?", Integer.class, new Object[]{type.getName()}));
    }

    @Cacheable(cacheName="org.jasig.portal.EntityTypes.ALL", keyGeneratorName="com.googlecode.ehcache.annotations.key.ListCacheKeyGenerator.DEFAULT_BEAN_NAME")
    public Iterator<Class> getAllEntityTypes() {
        return this.jdbcOperations.query("SELECT ENTITY_TYPE_NAME FROM UP_ENTITY_TYPE", CLASS_ROW_MAPPER).iterator();
    }

    @TriggersRemove(cacheName={"org.jasig.portal.EntityTypes.ALL"}, removeAll=true)
    @Transactional
    public void addEntityTypeIfNecessary(Class<? extends IBasicEntity> newType, String description) throws Exception {
        Integer existingId = this.getEntityIDFromType(newType);
        if (existingId != null) {
            return;
        }
        int nextId = this.counterStore.getNextId("UP_ENTITY_TYPE");
        this.jdbcOperations.update("INSERT INTO UP_ENTITY_TYPE (ENTITY_TYPE_ID, ENTITY_TYPE_NAME, DESCRIPTIVE_NAME) VALUES (?, ?, ?)", new Object[]{nextId, newType.getName(), description});
    }

    @TriggersRemove(cacheName={"org.jasig.portal.EntityTypes.CLASS_BY_ID", "org.jasig.portal.EntityTypes.ID_BY_CLASS", "org.jasig.portal.EntityTypes.ALL"}, removeAll=true)
    @Transactional
    public void deleteEntityType(Class type) throws SQLException {
        this.jdbcOperations.update("DELETE FROM UP_ENTITY_TYPE WHERE ENTITY_TYPE_NAME = ?", new Object[]{type.getName()});
    }
}

